/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.privatedns.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.privatedns.PrivateDnsZoneManager;
import com.azure.resourcemanager.privatedns.fluent.PrivateDnsManagementClient;
import com.azure.resourcemanager.privatedns.fluent.VirtualNetworkLinksClient;
import com.azure.resourcemanager.privatedns.fluent.models.VirtualNetworkLinkInner;
import com.azure.resourcemanager.privatedns.implementation.PrivateDnsZoneImpl;
import com.azure.resourcemanager.privatedns.implementation.VirtualNetworkLinkImpl;
import com.azure.resourcemanager.privatedns.models.PrivateDnsZone;
import com.azure.resourcemanager.privatedns.models.VirtualNetworkLink;
import com.azure.resourcemanager.privatedns.models.VirtualNetworkLinks;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.ExternalChildResourcesNonCachedImpl;
import reactor.core.publisher.Mono;

class VirtualNetworkLinksImpl
extends ExternalChildResourcesNonCachedImpl<VirtualNetworkLinkImpl, VirtualNetworkLink, VirtualNetworkLinkInner, PrivateDnsZoneImpl, PrivateDnsZone>
implements VirtualNetworkLinks {
    VirtualNetworkLinksImpl(PrivateDnsZoneImpl parent) {
        super((Object)parent, parent.taskGroup(), "VirtualNetworkLink");
    }

    @Override
    public PagedIterable<VirtualNetworkLink> list(int pageSize) {
        return new PagedIterable(this.listAsync(pageSize));
    }

    @Override
    public PagedFlux<VirtualNetworkLink> listAsync(int pageSize) {
        return ((PrivateDnsManagementClient)((PrivateDnsZoneManager)((Object)this.parent().manager())).serviceClient()).getVirtualNetworkLinks().listAsync(this.parent().resourceGroupName(), this.parent().name(), pageSize).mapPage(this::wrapModel);
    }

    @Override
    public void deleteById(String id) {
        this.deleteByIdAsync(id).block();
    }

    @Override
    public Mono<Void> deleteByIdAsync(String id) {
        return this.deleteByResourceGroupNameAsync(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)id), null);
    }

    @Override
    public void deleteById(String id, String etagValue) {
        this.deleteByResourceGroupNameAsync(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)id), etagValue).block();
    }

    @Override
    public Mono<Void> deleteByIdAsync(String id, String etagValue) {
        return this.deleteByResourceGroupNameAsync(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)id), etagValue);
    }

    @Override
    public void deleteByResourceGroupName(String resourceGroupName, String name) {
        this.deleteByResourceGroupNameAsync(resourceGroupName, name, null).block();
    }

    @Override
    public Mono<Void> deleteByResourceGroupNameAsync(String resourceGroupName, String name) {
        return this.deleteByResourceGroupNameAsync(resourceGroupName, name, null);
    }

    @Override
    public void deleteByResourceGroupName(String resourceGroupName, String name, String etagValue) {
        this.deleteByResourceGroupNameAsync(resourceGroupName, name, etagValue).block();
    }

    @Override
    public Mono<Void> deleteByResourceGroupNameAsync(String resourceGroupName, String name, String etagValue) {
        return ((PrivateDnsManagementClient)((PrivateDnsZoneManager)((Object)this.parent().manager())).serviceClient()).getVirtualNetworkLinks().deleteAsync(resourceGroupName, name, etagValue);
    }

    public VirtualNetworkLink getById(String id) {
        return (VirtualNetworkLink)this.getByIdAsync(id).block();
    }

    public Mono<VirtualNetworkLink> getByIdAsync(String id) {
        return this.getByNameAsync(ResourceUtils.nameFromResourceId((String)id));
    }

    public VirtualNetworkLink getByName(String name) {
        return (VirtualNetworkLink)this.getByNameAsync(name).block();
    }

    public Mono<VirtualNetworkLink> getByNameAsync(String name) {
        return ((PrivateDnsManagementClient)((PrivateDnsZoneManager)((Object)this.parent().manager())).serviceClient()).getVirtualNetworkLinks().getAsync(this.parent().resourceGroupName(), this.parent().name(), name).map(this::wrapModel);
    }

    public PrivateDnsZone parent() {
        return (PrivateDnsZone)this.getParent();
    }

    public PagedIterable<VirtualNetworkLink> list() {
        return new PagedIterable(this.listAsync());
    }

    public PagedFlux<VirtualNetworkLink> listAsync() {
        return ((PrivateDnsManagementClient)((PrivateDnsZoneManager)((Object)this.parent().manager())).serviceClient()).getVirtualNetworkLinks().listAsync(this.parent().resourceGroupName(), this.parent().name()).mapPage(this::wrapModel);
    }

    public VirtualNetworkLinksClient inner() {
        return ((PrivateDnsManagementClient)((PrivateDnsZoneManager)((Object)this.parent().manager())).serviceClient()).getVirtualNetworkLinks();
    }

    private VirtualNetworkLink wrapModel(VirtualNetworkLinkInner inner) {
        return inner == null ? null : new VirtualNetworkLinkImpl(inner.name(), (PrivateDnsZoneImpl)this.getParent(), inner);
    }

    VirtualNetworkLinkImpl defineVirtualNetworkLink(String name) {
        return (VirtualNetworkLinkImpl)this.prepareInlineDefine(VirtualNetworkLinkImpl.newVirtualNetworkLink(name, (PrivateDnsZoneImpl)this.getParent()));
    }

    VirtualNetworkLinkImpl updateVirtualNetworkLink(String name) {
        return (VirtualNetworkLinkImpl)this.prepareInlineUpdate(VirtualNetworkLinkImpl.newVirtualNetworkLink(name, (PrivateDnsZoneImpl)this.getParent()));
    }

    void withoutVirtualNetworkLink(String name, String etagValue) {
        this.prepareInlineRemove(VirtualNetworkLinkImpl.newVirtualNetworkLink(name, (PrivateDnsZoneImpl)this.getParent()).withETagOnDelete(etagValue));
    }
}

