// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.privatedns.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.privatedns.fluent.PrivateZonesClient;
import com.azure.resourcemanager.privatedns.fluent.models.PrivateZoneInner;
import com.azure.resourcemanager.privatedns.models.PrivateZoneListResult;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in PrivateZonesClient. */
public final class PrivateZonesClientImpl
    implements InnerSupportsGet<PrivateZoneInner>,
        InnerSupportsListing<PrivateZoneInner>,
        InnerSupportsDelete<Void>,
        PrivateZonesClient {
    private final ClientLogger logger = new ClientLogger(PrivateZonesClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final PrivateZonesService service;

    /** The service client containing this operation class. */
    private final PrivateDnsManagementClientImpl client;

    /**
     * Initializes an instance of PrivateZonesClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    PrivateZonesClientImpl(PrivateDnsManagementClientImpl client) {
        this.service =
            RestProxy.create(PrivateZonesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for PrivateDnsManagementClientPrivateZones to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "PrivateDnsManagement")
    private interface PrivateZonesService {
        @Headers({"Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/privateDnsZones/{privateZoneName}")
        @ExpectedResponses({200, 201, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdate(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("privateZoneName") String privateZoneName,
            @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("If-None-Match") String ifNoneMatch,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") PrivateZoneInner parameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/privateDnsZones/{privateZoneName}")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> update(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("privateZoneName") String privateZoneName,
            @HeaderParam("If-Match") String ifMatch,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") PrivateZoneInner parameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/privateDnsZones/{privateZoneName}")
        @ExpectedResponses({200, 202, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("privateZoneName") String privateZoneName,
            @HeaderParam("If-Match") String ifMatch,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/privateDnsZones/{privateZoneName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PrivateZoneInner>> getByResourceGroup(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("privateZoneName") String privateZoneName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Network/privateDnsZones")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PrivateZoneListResult>> list(
            @HostParam("$host") String endpoint,
            @QueryParam("$top") Integer top,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/privateDnsZones")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PrivateZoneListResult>> listByResourceGroup(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @QueryParam("$top") Integer top,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PrivateZoneListResult>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PrivateZoneListResult>> listByResourceGroupNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Creates or updates a Private DNS zone. Does not modify Links to virtual networks or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always overwrite the current zone. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new Private DNS zone to be created, but to prevent updating an existing
     *     zone. Other values will be ignored.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String privateZoneName,
        PrivateZoneInner parameters,
        String ifMatch,
        String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createOrUpdate(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            privateZoneName,
                            ifMatch,
                            ifNoneMatch,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            parameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates or updates a Private DNS zone. Does not modify Links to virtual networks or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always overwrite the current zone. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new Private DNS zone to be created, but to prevent updating an existing
     *     zone. Other values will be ignored.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String privateZoneName,
        PrivateZoneInner parameters,
        String ifMatch,
        String ifNoneMatch,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .createOrUpdate(
                this.client.getEndpoint(),
                resourceGroupName,
                privateZoneName,
                ifMatch,
                ifNoneMatch,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                parameters,
                accept,
                context);
    }

    /**
     * Creates or updates a Private DNS zone. Does not modify Links to virtual networks or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always overwrite the current zone. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new Private DNS zone to be created, but to prevent updating an existing
     *     zone. Other values will be ignored.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<PrivateZoneInner>, PrivateZoneInner> beginCreateOrUpdateAsync(
        String resourceGroupName,
        String privateZoneName,
        PrivateZoneInner parameters,
        String ifMatch,
        String ifNoneMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            createOrUpdateWithResponseAsync(resourceGroupName, privateZoneName, parameters, ifMatch, ifNoneMatch);
        return this
            .client
            .<PrivateZoneInner, PrivateZoneInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                PrivateZoneInner.class,
                PrivateZoneInner.class,
                this.client.getContext());
    }

    /**
     * Creates or updates a Private DNS zone. Does not modify Links to virtual networks or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always overwrite the current zone. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new Private DNS zone to be created, but to prevent updating an existing
     *     zone. Other values will be ignored.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<PrivateZoneInner>, PrivateZoneInner> beginCreateOrUpdateAsync(
        String resourceGroupName,
        String privateZoneName,
        PrivateZoneInner parameters,
        String ifMatch,
        String ifNoneMatch,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            createOrUpdateWithResponseAsync(
                resourceGroupName, privateZoneName, parameters, ifMatch, ifNoneMatch, context);
        return this
            .client
            .<PrivateZoneInner, PrivateZoneInner>getLroResult(
                mono, this.client.getHttpPipeline(), PrivateZoneInner.class, PrivateZoneInner.class, context);
    }

    /**
     * Creates or updates a Private DNS zone. Does not modify Links to virtual networks or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always overwrite the current zone. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new Private DNS zone to be created, but to prevent updating an existing
     *     zone. Other values will be ignored.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<PrivateZoneInner>, PrivateZoneInner> beginCreateOrUpdate(
        String resourceGroupName,
        String privateZoneName,
        PrivateZoneInner parameters,
        String ifMatch,
        String ifNoneMatch) {
        return beginCreateOrUpdateAsync(resourceGroupName, privateZoneName, parameters, ifMatch, ifNoneMatch)
            .getSyncPoller();
    }

    /**
     * Creates or updates a Private DNS zone. Does not modify Links to virtual networks or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always overwrite the current zone. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new Private DNS zone to be created, but to prevent updating an existing
     *     zone. Other values will be ignored.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<PrivateZoneInner>, PrivateZoneInner> beginCreateOrUpdate(
        String resourceGroupName,
        String privateZoneName,
        PrivateZoneInner parameters,
        String ifMatch,
        String ifNoneMatch,
        Context context) {
        return beginCreateOrUpdateAsync(resourceGroupName, privateZoneName, parameters, ifMatch, ifNoneMatch, context)
            .getSyncPoller();
    }

    /**
     * Creates or updates a Private DNS zone. Does not modify Links to virtual networks or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always overwrite the current zone. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new Private DNS zone to be created, but to prevent updating an existing
     *     zone. Other values will be ignored.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PrivateZoneInner> createOrUpdateAsync(
        String resourceGroupName,
        String privateZoneName,
        PrivateZoneInner parameters,
        String ifMatch,
        String ifNoneMatch) {
        return beginCreateOrUpdateAsync(resourceGroupName, privateZoneName, parameters, ifMatch, ifNoneMatch)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates or updates a Private DNS zone. Does not modify Links to virtual networks or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PrivateZoneInner> createOrUpdateAsync(
        String resourceGroupName, String privateZoneName, PrivateZoneInner parameters) {
        final String ifMatch = null;
        final String ifNoneMatch = null;
        return beginCreateOrUpdateAsync(resourceGroupName, privateZoneName, parameters, ifMatch, ifNoneMatch)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates or updates a Private DNS zone. Does not modify Links to virtual networks or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always overwrite the current zone. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new Private DNS zone to be created, but to prevent updating an existing
     *     zone. Other values will be ignored.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PrivateZoneInner> createOrUpdateAsync(
        String resourceGroupName,
        String privateZoneName,
        PrivateZoneInner parameters,
        String ifMatch,
        String ifNoneMatch,
        Context context) {
        return beginCreateOrUpdateAsync(resourceGroupName, privateZoneName, parameters, ifMatch, ifNoneMatch, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates or updates a Private DNS zone. Does not modify Links to virtual networks or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always overwrite the current zone. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new Private DNS zone to be created, but to prevent updating an existing
     *     zone. Other values will be ignored.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PrivateZoneInner createOrUpdate(
        String resourceGroupName,
        String privateZoneName,
        PrivateZoneInner parameters,
        String ifMatch,
        String ifNoneMatch) {
        return createOrUpdateAsync(resourceGroupName, privateZoneName, parameters, ifMatch, ifNoneMatch).block();
    }

    /**
     * Creates or updates a Private DNS zone. Does not modify Links to virtual networks or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PrivateZoneInner createOrUpdate(
        String resourceGroupName, String privateZoneName, PrivateZoneInner parameters) {
        final String ifMatch = null;
        final String ifNoneMatch = null;
        return createOrUpdateAsync(resourceGroupName, privateZoneName, parameters, ifMatch, ifNoneMatch).block();
    }

    /**
     * Creates or updates a Private DNS zone. Does not modify Links to virtual networks or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always overwrite the current zone. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new Private DNS zone to be created, but to prevent updating an existing
     *     zone. Other values will be ignored.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PrivateZoneInner createOrUpdate(
        String resourceGroupName,
        String privateZoneName,
        PrivateZoneInner parameters,
        String ifMatch,
        String ifNoneMatch,
        Context context) {
        return createOrUpdateAsync(resourceGroupName, privateZoneName, parameters, ifMatch, ifNoneMatch, context)
            .block();
    }

    /**
     * Updates a Private DNS zone. Does not modify virtual network links or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the Update operation.
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always overwrite the current zone. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(
        String resourceGroupName, String privateZoneName, PrivateZoneInner parameters, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .update(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            privateZoneName,
                            ifMatch,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            parameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Updates a Private DNS zone. Does not modify virtual network links or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the Update operation.
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always overwrite the current zone. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(
        String resourceGroupName,
        String privateZoneName,
        PrivateZoneInner parameters,
        String ifMatch,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .update(
                this.client.getEndpoint(),
                resourceGroupName,
                privateZoneName,
                ifMatch,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                parameters,
                accept,
                context);
    }

    /**
     * Updates a Private DNS zone. Does not modify virtual network links or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the Update operation.
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always overwrite the current zone. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<PrivateZoneInner>, PrivateZoneInner> beginUpdateAsync(
        String resourceGroupName, String privateZoneName, PrivateZoneInner parameters, String ifMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            updateWithResponseAsync(resourceGroupName, privateZoneName, parameters, ifMatch);
        return this
            .client
            .<PrivateZoneInner, PrivateZoneInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                PrivateZoneInner.class,
                PrivateZoneInner.class,
                this.client.getContext());
    }

    /**
     * Updates a Private DNS zone. Does not modify virtual network links or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the Update operation.
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always overwrite the current zone. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<PrivateZoneInner>, PrivateZoneInner> beginUpdateAsync(
        String resourceGroupName,
        String privateZoneName,
        PrivateZoneInner parameters,
        String ifMatch,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            updateWithResponseAsync(resourceGroupName, privateZoneName, parameters, ifMatch, context);
        return this
            .client
            .<PrivateZoneInner, PrivateZoneInner>getLroResult(
                mono, this.client.getHttpPipeline(), PrivateZoneInner.class, PrivateZoneInner.class, context);
    }

    /**
     * Updates a Private DNS zone. Does not modify virtual network links or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the Update operation.
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always overwrite the current zone. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<PrivateZoneInner>, PrivateZoneInner> beginUpdate(
        String resourceGroupName, String privateZoneName, PrivateZoneInner parameters, String ifMatch) {
        return beginUpdateAsync(resourceGroupName, privateZoneName, parameters, ifMatch).getSyncPoller();
    }

    /**
     * Updates a Private DNS zone. Does not modify virtual network links or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the Update operation.
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always overwrite the current zone. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<PrivateZoneInner>, PrivateZoneInner> beginUpdate(
        String resourceGroupName,
        String privateZoneName,
        PrivateZoneInner parameters,
        String ifMatch,
        Context context) {
        return beginUpdateAsync(resourceGroupName, privateZoneName, parameters, ifMatch, context).getSyncPoller();
    }

    /**
     * Updates a Private DNS zone. Does not modify virtual network links or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the Update operation.
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always overwrite the current zone. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PrivateZoneInner> updateAsync(
        String resourceGroupName, String privateZoneName, PrivateZoneInner parameters, String ifMatch) {
        return beginUpdateAsync(resourceGroupName, privateZoneName, parameters, ifMatch)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates a Private DNS zone. Does not modify virtual network links or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the Update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PrivateZoneInner> updateAsync(
        String resourceGroupName, String privateZoneName, PrivateZoneInner parameters) {
        final String ifMatch = null;
        return beginUpdateAsync(resourceGroupName, privateZoneName, parameters, ifMatch)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates a Private DNS zone. Does not modify virtual network links or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the Update operation.
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always overwrite the current zone. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PrivateZoneInner> updateAsync(
        String resourceGroupName,
        String privateZoneName,
        PrivateZoneInner parameters,
        String ifMatch,
        Context context) {
        return beginUpdateAsync(resourceGroupName, privateZoneName, parameters, ifMatch, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates a Private DNS zone. Does not modify virtual network links or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the Update operation.
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always overwrite the current zone. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PrivateZoneInner update(
        String resourceGroupName, String privateZoneName, PrivateZoneInner parameters, String ifMatch) {
        return updateAsync(resourceGroupName, privateZoneName, parameters, ifMatch).block();
    }

    /**
     * Updates a Private DNS zone. Does not modify virtual network links or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the Update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PrivateZoneInner update(String resourceGroupName, String privateZoneName, PrivateZoneInner parameters) {
        final String ifMatch = null;
        return updateAsync(resourceGroupName, privateZoneName, parameters, ifMatch).block();
    }

    /**
     * Updates a Private DNS zone. Does not modify virtual network links or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the Update operation.
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always overwrite the current zone. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PrivateZoneInner update(
        String resourceGroupName,
        String privateZoneName,
        PrivateZoneInner parameters,
        String ifMatch,
        Context context) {
        return updateAsync(resourceGroupName, privateZoneName, parameters, ifMatch, context).block();
    }

    /**
     * Deletes a Private DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be
     * undone. Private DNS zone cannot be deleted unless all virtual network links to it are removed.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always delete the current zone. Specify the
     *     last-seen ETag value to prevent accidentally deleting any concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String privateZoneName, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            privateZoneName,
                            ifMatch,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a Private DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be
     * undone. Private DNS zone cannot be deleted unless all virtual network links to it are removed.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always delete the current zone. Specify the
     *     last-seen ETag value to prevent accidentally deleting any concurrent changes.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String privateZoneName, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .delete(
                this.client.getEndpoint(),
                resourceGroupName,
                privateZoneName,
                ifMatch,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                accept,
                context);
    }

    /**
     * Deletes a Private DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be
     * undone. Private DNS zone cannot be deleted unless all virtual network links to it are removed.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always delete the current zone. Specify the
     *     last-seen ETag value to prevent accidentally deleting any concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName, String privateZoneName, String ifMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono = deleteWithResponseAsync(resourceGroupName, privateZoneName, ifMatch);
        return this
            .client
            .<Void, Void>getLroResult(
                mono, this.client.getHttpPipeline(), Void.class, Void.class, this.client.getContext());
    }

    /**
     * Deletes a Private DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be
     * undone. Private DNS zone cannot be deleted unless all virtual network links to it are removed.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always delete the current zone. Specify the
     *     last-seen ETag value to prevent accidentally deleting any concurrent changes.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName, String privateZoneName, String ifMatch, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteWithResponseAsync(resourceGroupName, privateZoneName, ifMatch, context);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, context);
    }

    /**
     * Deletes a Private DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be
     * undone. Private DNS zone cannot be deleted unless all virtual network links to it are removed.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always delete the current zone. Specify the
     *     last-seen ETag value to prevent accidentally deleting any concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String privateZoneName, String ifMatch) {
        return beginDeleteAsync(resourceGroupName, privateZoneName, ifMatch).getSyncPoller();
    }

    /**
     * Deletes a Private DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be
     * undone. Private DNS zone cannot be deleted unless all virtual network links to it are removed.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always delete the current zone. Specify the
     *     last-seen ETag value to prevent accidentally deleting any concurrent changes.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String privateZoneName, String ifMatch, Context context) {
        return beginDeleteAsync(resourceGroupName, privateZoneName, ifMatch, context).getSyncPoller();
    }

    /**
     * Deletes a Private DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be
     * undone. Private DNS zone cannot be deleted unless all virtual network links to it are removed.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always delete the current zone. Specify the
     *     last-seen ETag value to prevent accidentally deleting any concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String privateZoneName, String ifMatch) {
        return beginDeleteAsync(resourceGroupName, privateZoneName, ifMatch)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a Private DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be
     * undone. Private DNS zone cannot be deleted unless all virtual network links to it are removed.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String privateZoneName) {
        final String ifMatch = null;
        return beginDeleteAsync(resourceGroupName, privateZoneName, ifMatch)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a Private DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be
     * undone. Private DNS zone cannot be deleted unless all virtual network links to it are removed.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always delete the current zone. Specify the
     *     last-seen ETag value to prevent accidentally deleting any concurrent changes.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String privateZoneName, String ifMatch, Context context) {
        return beginDeleteAsync(resourceGroupName, privateZoneName, ifMatch, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a Private DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be
     * undone. Private DNS zone cannot be deleted unless all virtual network links to it are removed.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always delete the current zone. Specify the
     *     last-seen ETag value to prevent accidentally deleting any concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String privateZoneName, String ifMatch) {
        deleteAsync(resourceGroupName, privateZoneName, ifMatch).block();
    }

    /**
     * Deletes a Private DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be
     * undone. Private DNS zone cannot be deleted unless all virtual network links to it are removed.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String privateZoneName) {
        final String ifMatch = null;
        deleteAsync(resourceGroupName, privateZoneName, ifMatch).block();
    }

    /**
     * Deletes a Private DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be
     * undone. Private DNS zone cannot be deleted unless all virtual network links to it are removed.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always delete the current zone. Specify the
     *     last-seen ETag value to prevent accidentally deleting any concurrent changes.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String privateZoneName, String ifMatch, Context context) {
        deleteAsync(resourceGroupName, privateZoneName, ifMatch, context).block();
    }

    /**
     * Gets a Private DNS zone. Retrieves the zone properties, but not the virtual networks links or the record sets
     * within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PrivateZoneInner>> getByResourceGroupWithResponseAsync(
        String resourceGroupName, String privateZoneName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getByResourceGroup(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            privateZoneName,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a Private DNS zone. Retrieves the zone properties, but not the virtual networks links or the record sets
     * within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PrivateZoneInner>> getByResourceGroupWithResponseAsync(
        String resourceGroupName, String privateZoneName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getByResourceGroup(
                this.client.getEndpoint(),
                resourceGroupName,
                privateZoneName,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                accept,
                context);
    }

    /**
     * Gets a Private DNS zone. Retrieves the zone properties, but not the virtual networks links or the record sets
     * within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PrivateZoneInner> getByResourceGroupAsync(String resourceGroupName, String privateZoneName) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, privateZoneName)
            .flatMap(
                (Response<PrivateZoneInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets a Private DNS zone. Retrieves the zone properties, but not the virtual networks links or the record sets
     * within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PrivateZoneInner getByResourceGroup(String resourceGroupName, String privateZoneName) {
        return getByResourceGroupAsync(resourceGroupName, privateZoneName).block();
    }

    /**
     * Gets a Private DNS zone. Retrieves the zone properties, but not the virtual networks links or the record sets
     * within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PrivateZoneInner> getByResourceGroupWithResponse(
        String resourceGroupName, String privateZoneName, Context context) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, privateZoneName, context).block();
    }

    /**
     * Lists the Private DNS zones in all resource groups in a subscription.
     *
     * @param top The maximum number of Private DNS zones to return. If not specified, returns up to 100 zones.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a Private DNS zone list operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PrivateZoneInner>> listSinglePageAsync(Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .list(
                            this.client.getEndpoint(),
                            top,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            accept,
                            context))
            .<PagedResponse<PrivateZoneInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists the Private DNS zones in all resource groups in a subscription.
     *
     * @param top The maximum number of Private DNS zones to return. If not specified, returns up to 100 zones.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a Private DNS zone list operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PrivateZoneInner>> listSinglePageAsync(Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(
                this.client.getEndpoint(),
                top,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Lists the Private DNS zones in all resource groups in a subscription.
     *
     * @param top The maximum number of Private DNS zones to return. If not specified, returns up to 100 zones.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a Private DNS zone list operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PrivateZoneInner> listAsync(Integer top) {
        return new PagedFlux<>(() -> listSinglePageAsync(top), nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the Private DNS zones in all resource groups in a subscription.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a Private DNS zone list operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PrivateZoneInner> listAsync() {
        final Integer top = null;
        return new PagedFlux<>(() -> listSinglePageAsync(top), nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the Private DNS zones in all resource groups in a subscription.
     *
     * @param top The maximum number of Private DNS zones to return. If not specified, returns up to 100 zones.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a Private DNS zone list operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<PrivateZoneInner> listAsync(Integer top, Context context) {
        return new PagedFlux<>(
            () -> listSinglePageAsync(top, context), nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists the Private DNS zones in all resource groups in a subscription.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a Private DNS zone list operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PrivateZoneInner> list() {
        final Integer top = null;
        return new PagedIterable<>(listAsync(top));
    }

    /**
     * Lists the Private DNS zones in all resource groups in a subscription.
     *
     * @param top The maximum number of Private DNS zones to return. If not specified, returns up to 100 zones.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a Private DNS zone list operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PrivateZoneInner> list(Integer top, Context context) {
        return new PagedIterable<>(listAsync(top, context));
    }

    /**
     * Lists the Private DNS zones within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a Private DNS zone list operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PrivateZoneInner>> listByResourceGroupSinglePageAsync(
        String resourceGroupName, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listByResourceGroup(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            top,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            accept,
                            context))
            .<PagedResponse<PrivateZoneInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists the Private DNS zones within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a Private DNS zone list operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PrivateZoneInner>> listByResourceGroupSinglePageAsync(
        String resourceGroupName, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroup(
                this.client.getEndpoint(),
                resourceGroupName,
                top,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Lists the Private DNS zones within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a Private DNS zone list operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PrivateZoneInner> listByResourceGroupAsync(String resourceGroupName, Integer top) {
        return new PagedFlux<>(
            () -> listByResourceGroupSinglePageAsync(resourceGroupName, top),
            nextLink -> listByResourceGroupNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the Private DNS zones within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a Private DNS zone list operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PrivateZoneInner> listByResourceGroupAsync(String resourceGroupName) {
        final Integer top = null;
        return new PagedFlux<>(
            () -> listByResourceGroupSinglePageAsync(resourceGroupName, top),
            nextLink -> listByResourceGroupNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the Private DNS zones within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a Private DNS zone list operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<PrivateZoneInner> listByResourceGroupAsync(
        String resourceGroupName, Integer top, Context context) {
        return new PagedFlux<>(
            () -> listByResourceGroupSinglePageAsync(resourceGroupName, top, context),
            nextLink -> listByResourceGroupNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists the Private DNS zones within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a Private DNS zone list operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PrivateZoneInner> listByResourceGroup(String resourceGroupName) {
        final Integer top = null;
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName, top));
    }

    /**
     * Lists the Private DNS zones within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a Private DNS zone list operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PrivateZoneInner> listByResourceGroup(String resourceGroupName, Integer top, Context context) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName, top, context));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a Private DNS zone list operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PrivateZoneInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<PrivateZoneInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a Private DNS zone list operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PrivateZoneInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a Private DNS zone list operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PrivateZoneInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<PrivateZoneInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a Private DNS zone list operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PrivateZoneInner>> listByResourceGroupNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroupNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
