/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.privatedns.implementation;

import com.azure.resourcemanager.privatedns.PrivateDnsZoneManager;
import com.azure.resourcemanager.privatedns.fluent.PrivateDnsManagementClient;
import com.azure.resourcemanager.privatedns.fluent.models.RecordSetInner;
import com.azure.resourcemanager.privatedns.implementation.PrivateDnsZoneImpl;
import com.azure.resourcemanager.privatedns.models.ARecord;
import com.azure.resourcemanager.privatedns.models.AaaaRecord;
import com.azure.resourcemanager.privatedns.models.CnameRecord;
import com.azure.resourcemanager.privatedns.models.MxRecord;
import com.azure.resourcemanager.privatedns.models.PrivateDnsRecordSet;
import com.azure.resourcemanager.privatedns.models.PrivateDnsZone;
import com.azure.resourcemanager.privatedns.models.PtrRecord;
import com.azure.resourcemanager.privatedns.models.RecordType;
import com.azure.resourcemanager.privatedns.models.SrvRecord;
import com.azure.resourcemanager.privatedns.models.TxtRecord;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ETagState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

class PrivateDnsRecordSetImpl
extends ExternalChildResourceImpl<PrivateDnsRecordSet, RecordSetInner, PrivateDnsZoneImpl, PrivateDnsZone>
implements PrivateDnsRecordSet,
PrivateDnsRecordSet.Definition<PrivateDnsZone.DefinitionStages.WithCreate>,
PrivateDnsRecordSet.UpdateDefinition<PrivateDnsZone.Update>,
PrivateDnsRecordSet.UpdateCombined {
    protected final RecordSetInner recordSetRemoveInfo;
    protected final String type;
    private final ETagState etagState = new ETagState();

    protected PrivateDnsRecordSetImpl(String name, String type, PrivateDnsZoneImpl parent, RecordSetInner innerModel) {
        super(name, (Object)parent, (Object)innerModel);
        this.type = type;
        this.recordSetRemoveInfo = new RecordSetInner().withAaaaRecords(new ArrayList<AaaaRecord>()).withARecords(new ArrayList<ARecord>()).withCnameRecord(new CnameRecord()).withMxRecords(new ArrayList<MxRecord>()).withPtrRecords(new ArrayList<PtrRecord>()).withSrvRecords(new ArrayList<SrvRecord>()).withTxtRecords(new ArrayList<TxtRecord>()).withMetadata(new HashMap<String, String>());
    }

    @Override
    public String etag() {
        return ((RecordSetInner)((Object)this.innerModel())).etag();
    }

    @Override
    public Map<String, String> metadata() {
        return ((RecordSetInner)((Object)this.innerModel())).metadata();
    }

    @Override
    public long timeToLive() {
        return ((RecordSetInner)((Object)this.innerModel())).ttl() == null ? 0L : ((RecordSetInner)((Object)this.innerModel())).ttl();
    }

    @Override
    public String fqdn() {
        return ((RecordSetInner)((Object)this.innerModel())).fqdn();
    }

    @Override
    public boolean isAutoRegistered() {
        return ((RecordSetInner)((Object)this.innerModel())).isAutoRegistered();
    }

    @Override
    public PrivateDnsRecordSetImpl withIPv6Address(String ipv6Address) {
        ((RecordSetInner)((Object)this.innerModel())).aaaaRecords().add(new AaaaRecord().withIpv6Address(ipv6Address));
        return this;
    }

    @Override
    public PrivateDnsRecordSetImpl withoutIPv6Address(String ipv6Address) {
        this.recordSetRemoveInfo.aaaaRecords().add(new AaaaRecord().withIpv6Address(ipv6Address));
        return this;
    }

    @Override
    public PrivateDnsRecordSetImpl withIPv4Address(String ipv4Address) {
        ((RecordSetInner)((Object)this.innerModel())).aRecords().add(new ARecord().withIpv4Address(ipv4Address));
        return this;
    }

    @Override
    public PrivateDnsRecordSetImpl withoutIPv4Address(String ipv4Address) {
        this.recordSetRemoveInfo.aRecords().add(new ARecord().withIpv4Address(ipv4Address));
        return this;
    }

    @Override
    public PrivateDnsRecordSetImpl withAlias(String alias) {
        ((RecordSetInner)((Object)this.innerModel())).cnameRecord().withCname(alias);
        return this;
    }

    @Override
    public PrivateDnsRecordSetImpl withMailExchange(String mailExchangeHostName, int priority) {
        ((RecordSetInner)((Object)this.innerModel())).mxRecords().add(new MxRecord().withExchange(mailExchangeHostName).withPreference(priority));
        return this;
    }

    @Override
    public PrivateDnsRecordSetImpl withoutMailExchange(String mailExchangeHostName, int priority) {
        this.recordSetRemoveInfo.mxRecords().add(new MxRecord().withExchange(mailExchangeHostName).withPreference(priority));
        return this;
    }

    @Override
    public PrivateDnsRecordSetImpl withTargetDomainName(String targetDomainName) {
        ((RecordSetInner)((Object)this.innerModel())).ptrRecords().add(new PtrRecord().withPtrdname(targetDomainName));
        return this;
    }

    @Override
    public PrivateDnsRecordSetImpl withoutTargetDomainName(String targetDomainName) {
        this.recordSetRemoveInfo.ptrRecords().add(new PtrRecord().withPtrdname(targetDomainName));
        return this;
    }

    @Override
    public PrivateDnsRecordSetImpl withAuthoritativeServer(String authoritativeServerHostName) {
        ((RecordSetInner)((Object)this.innerModel())).soaRecord().withHost(authoritativeServerHostName);
        return this;
    }

    @Override
    public PrivateDnsRecordSetImpl withEmailServer(String emailServerHostName) {
        ((RecordSetInner)((Object)this.innerModel())).soaRecord().withEmail(emailServerHostName);
        return this;
    }

    @Override
    public PrivateDnsRecordSetImpl withSerialNumber(long serialNumber) {
        ((RecordSetInner)((Object)this.innerModel())).soaRecord().withSerialNumber(serialNumber);
        return this;
    }

    @Override
    public PrivateDnsRecordSetImpl withRefreshTimeInSeconds(long refreshTimeInSeconds) {
        ((RecordSetInner)((Object)this.innerModel())).soaRecord().withRefreshTime(refreshTimeInSeconds);
        return this;
    }

    @Override
    public PrivateDnsRecordSetImpl withRetryTimeInSeconds(long retryTimeInSeconds) {
        ((RecordSetInner)((Object)this.innerModel())).soaRecord().withRetryTime(retryTimeInSeconds);
        return this;
    }

    @Override
    public PrivateDnsRecordSetImpl withExpireTimeInSeconds(long expireTimeInSeconds) {
        ((RecordSetInner)((Object)this.innerModel())).soaRecord().withExpireTime(expireTimeInSeconds);
        return this;
    }

    @Override
    public PrivateDnsRecordSetImpl withNegativeResponseCachingTimeToLiveInSeconds(long negativeCachingTimeToLive) {
        ((RecordSetInner)((Object)this.innerModel())).soaRecord().withMinimumTtl(negativeCachingTimeToLive);
        return this;
    }

    @Override
    public PrivateDnsRecordSetImpl withRecord(String target, int port, int priority, int weight) {
        ((RecordSetInner)((Object)this.innerModel())).srvRecords().add(new SrvRecord().withTarget(target).withPort(port).withPriority(priority).withWeight(weight));
        return this;
    }

    @Override
    public PrivateDnsRecordSetImpl withoutRecord(String target, int port, int priority, int weight) {
        this.recordSetRemoveInfo.srvRecords().add(new SrvRecord().withTarget(target).withPort(port).withPriority(priority).withWeight(weight));
        return this;
    }

    @Override
    public PrivateDnsRecordSetImpl withText(String text) {
        if (text == null) {
            return this;
        }
        ArrayList<String> chunks = new ArrayList<String>();
        for (String chunk : text.split("(?<=\\G.{250})")) {
            chunks.add(chunk);
        }
        ((RecordSetInner)((Object)this.innerModel())).txtRecords().add(new TxtRecord().withValue(chunks));
        return this;
    }

    @Override
    public PrivateDnsRecordSetImpl withoutText(String text) {
        if (text == null) {
            return this;
        }
        ArrayList<String> chunks = new ArrayList<String>();
        chunks.add(text);
        return this.withoutText(chunks);
    }

    @Override
    public PrivateDnsRecordSetImpl withoutText(List<String> textChunks) {
        this.recordSetRemoveInfo.txtRecords().add(new TxtRecord().withValue(textChunks));
        return this;
    }

    @Override
    public PrivateDnsRecordSetImpl withTimeToLive(long ttlInSeconds) {
        ((RecordSetInner)((Object)this.innerModel())).withTtl(ttlInSeconds);
        return this;
    }

    @Override
    public PrivateDnsRecordSetImpl withMetadata(String key, String value) {
        if (((RecordSetInner)((Object)this.innerModel())).metadata() == null) {
            ((RecordSetInner)((Object)this.innerModel())).withMetadata(new HashMap<String, String>());
        }
        ((RecordSetInner)((Object)this.innerModel())).metadata().put(key, value);
        return this;
    }

    @Override
    public PrivateDnsRecordSetImpl withoutMetadata(String key) {
        this.recordSetRemoveInfo.metadata().put(key, null);
        return this;
    }

    @Override
    public PrivateDnsRecordSetImpl withETagCheck() {
        this.etagState.withImplicitETagCheckOnCreateOrUpdate(this.isInCreateMode());
        return this;
    }

    @Override
    public PrivateDnsRecordSetImpl withETagCheck(String etagValue) {
        this.etagState.withExplicitETagCheckOnUpdate(etagValue);
        return this;
    }

    public Mono<PrivateDnsRecordSet> createResourceAsync() {
        return this.createOrUpdateAsync((RecordSetInner)((Object)this.innerModel()));
    }

    public Mono<PrivateDnsRecordSet> updateResourceAsync() {
        return ((PrivateDnsManagementClient)((PrivateDnsZoneManager)((PrivateDnsZoneImpl)this.parent()).manager()).serviceClient()).getRecordSets().getAsync(((PrivateDnsZoneImpl)this.parent()).resourceGroupName(), ((PrivateDnsZoneImpl)this.parent()).name(), this.recordType(), this.name()).map(recordSetInner -> this.prepare((RecordSetInner)((Object)recordSetInner))).flatMap(recordSetInner -> this.createOrUpdateAsync((RecordSetInner)((Object)recordSetInner)));
    }

    public Mono<Void> deleteResourceAsync() {
        return ((PrivateDnsManagementClient)((PrivateDnsZoneManager)((PrivateDnsZoneImpl)this.parent()).manager()).serviceClient()).getRecordSets().deleteAsync(((PrivateDnsZoneImpl)this.parent()).resourceGroupName(), ((PrivateDnsZoneImpl)this.parent()).name(), this.recordType(), this.name(), this.etagState.ifMatchValueOnDelete());
    }

    protected Mono<RecordSetInner> getInnerAsync() {
        return ((PrivateDnsManagementClient)((PrivateDnsZoneManager)((PrivateDnsZoneImpl)this.parent()).manager()).serviceClient()).getRecordSets().getAsync(((PrivateDnsZoneImpl)this.parent()).resourceGroupName(), ((PrivateDnsZoneImpl)this.parent()).name(), this.recordType(), this.name());
    }

    public String id() {
        return ((RecordSetInner)((Object)this.innerModel())).id();
    }

    @Override
    public RecordType recordType() {
        String fullyQualifiedType = this.type;
        String[] parts = fullyQualifiedType.split("/");
        return RecordType.fromString(parts[parts.length - 1]);
    }

    public PrivateDnsZoneImpl attach() {
        return (PrivateDnsZoneImpl)this.parent();
    }

    public String childResourceKey() {
        return this.name() + "_" + this.recordType().toString();
    }

    private Mono<PrivateDnsRecordSet> createOrUpdateAsync(RecordSetInner resource) {
        PrivateDnsRecordSetImpl self = this;
        return ((PrivateDnsManagementClient)((PrivateDnsZoneManager)((PrivateDnsZoneImpl)this.parent()).manager()).serviceClient()).getRecordSets().createOrUpdateAsync(((PrivateDnsZoneImpl)this.parent()).resourceGroupName(), ((PrivateDnsZoneImpl)this.parent()).name(), this.recordType(), this.name(), resource, this.etagState.ifMatchValueOnUpdate(resource.etag()), this.etagState.ifNonMatchValueOnCreate()).map(recordSetInner -> {
            this.setInner(recordSetInner);
            self.etagState.clear();
            return self;
        });
    }

    private RecordSetInner prepare(RecordSetInner resource) {
        if (this.recordSetRemoveInfo.metadata().size() > 0) {
            if (resource.metadata() != null) {
                for (String string : this.recordSetRemoveInfo.metadata().keySet()) {
                    resource.metadata().remove(string);
                }
            }
            this.recordSetRemoveInfo.metadata().clear();
        }
        if (((RecordSetInner)((Object)this.innerModel())).metadata() != null && ((RecordSetInner)((Object)this.innerModel())).metadata().size() > 0) {
            if (resource.metadata() == null) {
                resource.withMetadata(new HashMap<String, String>());
            }
            for (Map.Entry entry : ((RecordSetInner)((Object)this.innerModel())).metadata().entrySet()) {
                resource.metadata().put((String)entry.getKey(), (String)entry.getValue());
            }
            ((RecordSetInner)((Object)this.innerModel())).metadata().clear();
        }
        if (((RecordSetInner)((Object)this.innerModel())).ttl() != null) {
            resource.withTtl(((RecordSetInner)((Object)this.innerModel())).ttl());
            ((RecordSetInner)((Object)this.innerModel())).withTtl(null);
        }
        return this.prepareForUpdate(resource);
    }

    protected RecordSetInner prepareForUpdate(RecordSetInner resource) {
        return resource;
    }

    PrivateDnsRecordSetImpl withETagOnDelete(String etagValue) {
        this.etagState.withExplicitETagCheckOnDelete(etagValue);
        return this;
    }

    private boolean isInCreateMode() {
        return ((RecordSetInner)((Object)this.innerModel())).id() == null;
    }
}

