// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.privatedns.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.privatedns.fluent.models.PrivateZoneInner;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in PrivateZonesClient. */
public interface PrivateZonesClient
    extends InnerSupportsGet<PrivateZoneInner>, InnerSupportsListing<PrivateZoneInner>, InnerSupportsDelete<Void> {
    /**
     * Creates or updates a Private DNS zone. Does not modify Links to virtual networks or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always overwrite the current zone. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new Private DNS zone to be created, but to prevent updating an existing
     *     zone. Other values will be ignored.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String privateZoneName,
        PrivateZoneInner parameters,
        String ifMatch,
        String ifNoneMatch);

    /**
     * Creates or updates a Private DNS zone. Does not modify Links to virtual networks or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always overwrite the current zone. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new Private DNS zone to be created, but to prevent updating an existing
     *     zone. Other values will be ignored.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<PrivateZoneInner>, PrivateZoneInner> beginCreateOrUpdateAsync(
        String resourceGroupName,
        String privateZoneName,
        PrivateZoneInner parameters,
        String ifMatch,
        String ifNoneMatch);

    /**
     * Creates or updates a Private DNS zone. Does not modify Links to virtual networks or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always overwrite the current zone. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new Private DNS zone to be created, but to prevent updating an existing
     *     zone. Other values will be ignored.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<PrivateZoneInner>, PrivateZoneInner> beginCreateOrUpdate(
        String resourceGroupName,
        String privateZoneName,
        PrivateZoneInner parameters,
        String ifMatch,
        String ifNoneMatch);

    /**
     * Creates or updates a Private DNS zone. Does not modify Links to virtual networks or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always overwrite the current zone. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new Private DNS zone to be created, but to prevent updating an existing
     *     zone. Other values will be ignored.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<PrivateZoneInner>, PrivateZoneInner> beginCreateOrUpdate(
        String resourceGroupName,
        String privateZoneName,
        PrivateZoneInner parameters,
        String ifMatch,
        String ifNoneMatch,
        Context context);

    /**
     * Creates or updates a Private DNS zone. Does not modify Links to virtual networks or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always overwrite the current zone. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new Private DNS zone to be created, but to prevent updating an existing
     *     zone. Other values will be ignored.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PrivateZoneInner> createOrUpdateAsync(
        String resourceGroupName,
        String privateZoneName,
        PrivateZoneInner parameters,
        String ifMatch,
        String ifNoneMatch);

    /**
     * Creates or updates a Private DNS zone. Does not modify Links to virtual networks or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PrivateZoneInner> createOrUpdateAsync(
        String resourceGroupName, String privateZoneName, PrivateZoneInner parameters);

    /**
     * Creates or updates a Private DNS zone. Does not modify Links to virtual networks or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always overwrite the current zone. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new Private DNS zone to be created, but to prevent updating an existing
     *     zone. Other values will be ignored.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PrivateZoneInner createOrUpdate(
        String resourceGroupName,
        String privateZoneName,
        PrivateZoneInner parameters,
        String ifMatch,
        String ifNoneMatch);

    /**
     * Creates or updates a Private DNS zone. Does not modify Links to virtual networks or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PrivateZoneInner createOrUpdate(String resourceGroupName, String privateZoneName, PrivateZoneInner parameters);

    /**
     * Creates or updates a Private DNS zone. Does not modify Links to virtual networks or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always overwrite the current zone. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new Private DNS zone to be created, but to prevent updating an existing
     *     zone. Other values will be ignored.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PrivateZoneInner createOrUpdate(
        String resourceGroupName,
        String privateZoneName,
        PrivateZoneInner parameters,
        String ifMatch,
        String ifNoneMatch,
        Context context);

    /**
     * Updates a Private DNS zone. Does not modify virtual network links or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the Update operation.
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always overwrite the current zone. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(
        String resourceGroupName, String privateZoneName, PrivateZoneInner parameters, String ifMatch);

    /**
     * Updates a Private DNS zone. Does not modify virtual network links or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the Update operation.
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always overwrite the current zone. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<PrivateZoneInner>, PrivateZoneInner> beginUpdateAsync(
        String resourceGroupName, String privateZoneName, PrivateZoneInner parameters, String ifMatch);

    /**
     * Updates a Private DNS zone. Does not modify virtual network links or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the Update operation.
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always overwrite the current zone. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<PrivateZoneInner>, PrivateZoneInner> beginUpdate(
        String resourceGroupName, String privateZoneName, PrivateZoneInner parameters, String ifMatch);

    /**
     * Updates a Private DNS zone. Does not modify virtual network links or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the Update operation.
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always overwrite the current zone. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<PrivateZoneInner>, PrivateZoneInner> beginUpdate(
        String resourceGroupName, String privateZoneName, PrivateZoneInner parameters, String ifMatch, Context context);

    /**
     * Updates a Private DNS zone. Does not modify virtual network links or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the Update operation.
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always overwrite the current zone. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PrivateZoneInner> updateAsync(
        String resourceGroupName, String privateZoneName, PrivateZoneInner parameters, String ifMatch);

    /**
     * Updates a Private DNS zone. Does not modify virtual network links or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the Update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PrivateZoneInner> updateAsync(String resourceGroupName, String privateZoneName, PrivateZoneInner parameters);

    /**
     * Updates a Private DNS zone. Does not modify virtual network links or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the Update operation.
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always overwrite the current zone. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PrivateZoneInner update(
        String resourceGroupName, String privateZoneName, PrivateZoneInner parameters, String ifMatch);

    /**
     * Updates a Private DNS zone. Does not modify virtual network links or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the Update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PrivateZoneInner update(String resourceGroupName, String privateZoneName, PrivateZoneInner parameters);

    /**
     * Updates a Private DNS zone. Does not modify virtual network links or DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the Update operation.
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always overwrite the current zone. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PrivateZoneInner update(
        String resourceGroupName, String privateZoneName, PrivateZoneInner parameters, String ifMatch, Context context);

    /**
     * Deletes a Private DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be
     * undone. Private DNS zone cannot be deleted unless all virtual network links to it are removed.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always delete the current zone. Specify the
     *     last-seen ETag value to prevent accidentally deleting any concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String privateZoneName, String ifMatch);

    /**
     * Deletes a Private DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be
     * undone. Private DNS zone cannot be deleted unless all virtual network links to it are removed.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always delete the current zone. Specify the
     *     last-seen ETag value to prevent accidentally deleting any concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName, String privateZoneName, String ifMatch);

    /**
     * Deletes a Private DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be
     * undone. Private DNS zone cannot be deleted unless all virtual network links to it are removed.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always delete the current zone. Specify the
     *     last-seen ETag value to prevent accidentally deleting any concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String privateZoneName, String ifMatch);

    /**
     * Deletes a Private DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be
     * undone. Private DNS zone cannot be deleted unless all virtual network links to it are removed.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always delete the current zone. Specify the
     *     last-seen ETag value to prevent accidentally deleting any concurrent changes.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String privateZoneName, String ifMatch, Context context);

    /**
     * Deletes a Private DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be
     * undone. Private DNS zone cannot be deleted unless all virtual network links to it are removed.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always delete the current zone. Specify the
     *     last-seen ETag value to prevent accidentally deleting any concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String privateZoneName, String ifMatch);

    /**
     * Deletes a Private DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be
     * undone. Private DNS zone cannot be deleted unless all virtual network links to it are removed.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String privateZoneName);

    /**
     * Deletes a Private DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be
     * undone. Private DNS zone cannot be deleted unless all virtual network links to it are removed.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always delete the current zone. Specify the
     *     last-seen ETag value to prevent accidentally deleting any concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String privateZoneName, String ifMatch);

    /**
     * Deletes a Private DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be
     * undone. Private DNS zone cannot be deleted unless all virtual network links to it are removed.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String privateZoneName);

    /**
     * Deletes a Private DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be
     * undone. Private DNS zone cannot be deleted unless all virtual network links to it are removed.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param ifMatch The ETag of the Private DNS zone. Omit this value to always delete the current zone. Specify the
     *     last-seen ETag value to prevent accidentally deleting any concurrent changes.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String privateZoneName, String ifMatch, Context context);

    /**
     * Gets a Private DNS zone. Retrieves the zone properties, but not the virtual networks links or the record sets
     * within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Private DNS zone along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PrivateZoneInner>> getByResourceGroupWithResponseAsync(
        String resourceGroupName, String privateZoneName);

    /**
     * Gets a Private DNS zone. Retrieves the zone properties, but not the virtual networks links or the record sets
     * within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Private DNS zone on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PrivateZoneInner> getByResourceGroupAsync(String resourceGroupName, String privateZoneName);

    /**
     * Gets a Private DNS zone. Retrieves the zone properties, but not the virtual networks links or the record sets
     * within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Private DNS zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PrivateZoneInner getByResourceGroup(String resourceGroupName, String privateZoneName);

    /**
     * Gets a Private DNS zone. Retrieves the zone properties, but not the virtual networks links or the record sets
     * within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Private DNS zone along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PrivateZoneInner> getByResourceGroupWithResponse(
        String resourceGroupName, String privateZoneName, Context context);

    /**
     * Lists the Private DNS zones in all resource groups in a subscription.
     *
     * @param top The maximum number of Private DNS zones to return. If not specified, returns up to 100 zones.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a Private DNS zone list operation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<PrivateZoneInner> listAsync(Integer top);

    /**
     * Lists the Private DNS zones in all resource groups in a subscription.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a Private DNS zone list operation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<PrivateZoneInner> listAsync();

    /**
     * Lists the Private DNS zones in all resource groups in a subscription.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a Private DNS zone list operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PrivateZoneInner> list();

    /**
     * Lists the Private DNS zones in all resource groups in a subscription.
     *
     * @param top The maximum number of Private DNS zones to return. If not specified, returns up to 100 zones.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a Private DNS zone list operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PrivateZoneInner> list(Integer top, Context context);

    /**
     * Lists the Private DNS zones within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a Private DNS zone list operation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<PrivateZoneInner> listByResourceGroupAsync(String resourceGroupName, Integer top);

    /**
     * Lists the Private DNS zones within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a Private DNS zone list operation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<PrivateZoneInner> listByResourceGroupAsync(String resourceGroupName);

    /**
     * Lists the Private DNS zones within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a Private DNS zone list operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PrivateZoneInner> listByResourceGroup(String resourceGroupName);

    /**
     * Lists the Private DNS zones within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a Private DNS zone list operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PrivateZoneInner> listByResourceGroup(String resourceGroupName, Integer top, Context context);
}
