// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.privatedns.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.privatedns.fluent.RecordSetsClient;
import com.azure.resourcemanager.privatedns.fluent.models.RecordSetInner;
import com.azure.resourcemanager.privatedns.models.RecordSetListResult;
import com.azure.resourcemanager.privatedns.models.RecordType;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in RecordSetsClient. */
public final class RecordSetsClientImpl implements RecordSetsClient {
    private final ClientLogger logger = new ClientLogger(RecordSetsClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final RecordSetsService service;

    /** The service client containing this operation class. */
    private final PrivateDnsManagementClientImpl client;

    /**
     * Initializes an instance of RecordSetsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    RecordSetsClientImpl(PrivateDnsManagementClientImpl client) {
        this.service =
            RestProxy.create(RecordSetsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for PrivateDnsManagementClientRecordSets to be used by the proxy service
     * to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "PrivateDnsManagement")
    private interface RecordSetsService {
        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/privateDnsZones/{privateZoneName}/{recordType}/{relativeRecordSetName}")
        @ExpectedResponses({200, 201})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RecordSetInner>> createOrUpdate(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("privateZoneName") String privateZoneName,
            @PathParam("recordType") RecordType recordType,
            @PathParam(value = "relativeRecordSetName", encoded = true) String relativeRecordSetName,
            @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("If-None-Match") String ifNoneMatch,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") RecordSetInner parameters,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Patch(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/privateDnsZones/{privateZoneName}/{recordType}/{relativeRecordSetName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RecordSetInner>> update(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("privateZoneName") String privateZoneName,
            @PathParam("recordType") RecordType recordType,
            @PathParam(value = "relativeRecordSetName", encoded = true) String relativeRecordSetName,
            @HeaderParam("If-Match") String ifMatch,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") RecordSetInner parameters,
            Context context);

        @Headers({"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/privateDnsZones/{privateZoneName}/{recordType}/{relativeRecordSetName}")
        @ExpectedResponses({200, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> delete(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("privateZoneName") String privateZoneName,
            @PathParam("recordType") RecordType recordType,
            @PathParam(value = "relativeRecordSetName", encoded = true) String relativeRecordSetName,
            @HeaderParam("If-Match") String ifMatch,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/privateDnsZones/{privateZoneName}/{recordType}/{relativeRecordSetName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RecordSetInner>> get(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("privateZoneName") String privateZoneName,
            @PathParam("recordType") RecordType recordType,
            @PathParam(value = "relativeRecordSetName", encoded = true) String relativeRecordSetName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/privateDnsZones/{privateZoneName}/{recordType}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RecordSetListResult>> listByType(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("privateZoneName") String privateZoneName,
            @PathParam("recordType") RecordType recordType,
            @QueryParam("$top") Integer top,
            @QueryParam("$recordsetnamesuffix") String recordsetnamesuffix,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/privateDnsZones/{privateZoneName}/ALL")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RecordSetListResult>> list(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("privateZoneName") String privateZoneName,
            @QueryParam("$top") Integer top,
            @QueryParam("$recordsetnamesuffix") String recordsetnamesuffix,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RecordSetListResult>> listByTypeNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RecordSetListResult>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);
    }

    /**
     * Creates or updates a record set within a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set. Record sets of type SOA can be updated but not
     *     created (they are created when the Private DNS zone is created).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param parameters Describes a DNS record set (a collection of DNS records with the same name and type) in a
     *     Private DNS zone.
     * @param ifMatch The ETag of the record set. Omit this value to always overwrite the current record set. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new record set to be created, but to prevent updating an existing record
     *     set. Other values will be ignored.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a DNS record set (a collection of DNS records with the same name and type) in a Private DNS
     *     zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RecordSetInner>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        String relativeRecordSetName,
        RecordSetInner parameters,
        String ifMatch,
        String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error(new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (relativeRecordSetName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createOrUpdate(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            privateZoneName,
                            recordType,
                            relativeRecordSetName,
                            ifMatch,
                            ifNoneMatch,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            parameters,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Creates or updates a record set within a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set. Record sets of type SOA can be updated but not
     *     created (they are created when the Private DNS zone is created).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param parameters Describes a DNS record set (a collection of DNS records with the same name and type) in a
     *     Private DNS zone.
     * @param ifMatch The ETag of the record set. Omit this value to always overwrite the current record set. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new record set to be created, but to prevent updating an existing record
     *     set. Other values will be ignored.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a DNS record set (a collection of DNS records with the same name and type) in a Private DNS
     *     zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<RecordSetInner>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        String relativeRecordSetName,
        RecordSetInner parameters,
        String ifMatch,
        String ifNoneMatch,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error(new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (relativeRecordSetName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        context = this.client.mergeContext(context);
        return service
            .createOrUpdate(
                this.client.getEndpoint(),
                resourceGroupName,
                privateZoneName,
                recordType,
                relativeRecordSetName,
                ifMatch,
                ifNoneMatch,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                parameters,
                context);
    }

    /**
     * Creates or updates a record set within a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set. Record sets of type SOA can be updated but not
     *     created (they are created when the Private DNS zone is created).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param parameters Describes a DNS record set (a collection of DNS records with the same name and type) in a
     *     Private DNS zone.
     * @param ifMatch The ETag of the record set. Omit this value to always overwrite the current record set. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new record set to be created, but to prevent updating an existing record
     *     set. Other values will be ignored.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a DNS record set (a collection of DNS records with the same name and type) in a Private DNS
     *     zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RecordSetInner> createOrUpdateAsync(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        String relativeRecordSetName,
        RecordSetInner parameters,
        String ifMatch,
        String ifNoneMatch) {
        return createOrUpdateWithResponseAsync(
                resourceGroupName, privateZoneName, recordType, relativeRecordSetName, parameters, ifMatch, ifNoneMatch)
            .flatMap(
                (Response<RecordSetInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Creates or updates a record set within a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set. Record sets of type SOA can be updated but not
     *     created (they are created when the Private DNS zone is created).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param parameters Describes a DNS record set (a collection of DNS records with the same name and type) in a
     *     Private DNS zone.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a DNS record set (a collection of DNS records with the same name and type) in a Private DNS
     *     zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RecordSetInner> createOrUpdateAsync(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        String relativeRecordSetName,
        RecordSetInner parameters) {
        final String ifMatch = null;
        final String ifNoneMatch = null;
        return createOrUpdateWithResponseAsync(
                resourceGroupName, privateZoneName, recordType, relativeRecordSetName, parameters, ifMatch, ifNoneMatch)
            .flatMap(
                (Response<RecordSetInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Creates or updates a record set within a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set. Record sets of type SOA can be updated but not
     *     created (they are created when the Private DNS zone is created).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param parameters Describes a DNS record set (a collection of DNS records with the same name and type) in a
     *     Private DNS zone.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a DNS record set (a collection of DNS records with the same name and type) in a Private DNS
     *     zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RecordSetInner createOrUpdate(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        String relativeRecordSetName,
        RecordSetInner parameters) {
        final String ifMatch = null;
        final String ifNoneMatch = null;
        return createOrUpdateAsync(
                resourceGroupName, privateZoneName, recordType, relativeRecordSetName, parameters, ifMatch, ifNoneMatch)
            .block();
    }

    /**
     * Creates or updates a record set within a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set. Record sets of type SOA can be updated but not
     *     created (they are created when the Private DNS zone is created).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param parameters Describes a DNS record set (a collection of DNS records with the same name and type) in a
     *     Private DNS zone.
     * @param ifMatch The ETag of the record set. Omit this value to always overwrite the current record set. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new record set to be created, but to prevent updating an existing record
     *     set. Other values will be ignored.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a DNS record set (a collection of DNS records with the same name and type) in a Private DNS
     *     zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RecordSetInner> createOrUpdateWithResponse(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        String relativeRecordSetName,
        RecordSetInner parameters,
        String ifMatch,
        String ifNoneMatch,
        Context context) {
        return createOrUpdateWithResponseAsync(
                resourceGroupName,
                privateZoneName,
                recordType,
                relativeRecordSetName,
                parameters,
                ifMatch,
                ifNoneMatch,
                context)
            .block();
    }

    /**
     * Updates a record set within a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set.
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param parameters Describes a DNS record set (a collection of DNS records with the same name and type) in a
     *     Private DNS zone.
     * @param ifMatch The ETag of the record set. Omit this value to always overwrite the current record set. Specify
     *     the last-seen ETag value to prevent accidentally overwriting concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a DNS record set (a collection of DNS records with the same name and type) in a Private DNS
     *     zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RecordSetInner>> updateWithResponseAsync(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        String relativeRecordSetName,
        RecordSetInner parameters,
        String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error(new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (relativeRecordSetName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .update(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            privateZoneName,
                            recordType,
                            relativeRecordSetName,
                            ifMatch,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            parameters,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Updates a record set within a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set.
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param parameters Describes a DNS record set (a collection of DNS records with the same name and type) in a
     *     Private DNS zone.
     * @param ifMatch The ETag of the record set. Omit this value to always overwrite the current record set. Specify
     *     the last-seen ETag value to prevent accidentally overwriting concurrent changes.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a DNS record set (a collection of DNS records with the same name and type) in a Private DNS
     *     zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<RecordSetInner>> updateWithResponseAsync(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        String relativeRecordSetName,
        RecordSetInner parameters,
        String ifMatch,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error(new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (relativeRecordSetName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        context = this.client.mergeContext(context);
        return service
            .update(
                this.client.getEndpoint(),
                resourceGroupName,
                privateZoneName,
                recordType,
                relativeRecordSetName,
                ifMatch,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                parameters,
                context);
    }

    /**
     * Updates a record set within a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set.
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param parameters Describes a DNS record set (a collection of DNS records with the same name and type) in a
     *     Private DNS zone.
     * @param ifMatch The ETag of the record set. Omit this value to always overwrite the current record set. Specify
     *     the last-seen ETag value to prevent accidentally overwriting concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a DNS record set (a collection of DNS records with the same name and type) in a Private DNS
     *     zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RecordSetInner> updateAsync(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        String relativeRecordSetName,
        RecordSetInner parameters,
        String ifMatch) {
        return updateWithResponseAsync(
                resourceGroupName, privateZoneName, recordType, relativeRecordSetName, parameters, ifMatch)
            .flatMap(
                (Response<RecordSetInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Updates a record set within a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set.
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param parameters Describes a DNS record set (a collection of DNS records with the same name and type) in a
     *     Private DNS zone.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a DNS record set (a collection of DNS records with the same name and type) in a Private DNS
     *     zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RecordSetInner> updateAsync(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        String relativeRecordSetName,
        RecordSetInner parameters) {
        final String ifMatch = null;
        return updateWithResponseAsync(
                resourceGroupName, privateZoneName, recordType, relativeRecordSetName, parameters, ifMatch)
            .flatMap(
                (Response<RecordSetInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Updates a record set within a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set.
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param parameters Describes a DNS record set (a collection of DNS records with the same name and type) in a
     *     Private DNS zone.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a DNS record set (a collection of DNS records with the same name and type) in a Private DNS
     *     zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RecordSetInner update(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        String relativeRecordSetName,
        RecordSetInner parameters) {
        final String ifMatch = null;
        return updateAsync(resourceGroupName, privateZoneName, recordType, relativeRecordSetName, parameters, ifMatch)
            .block();
    }

    /**
     * Updates a record set within a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set.
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param parameters Describes a DNS record set (a collection of DNS records with the same name and type) in a
     *     Private DNS zone.
     * @param ifMatch The ETag of the record set. Omit this value to always overwrite the current record set. Specify
     *     the last-seen ETag value to prevent accidentally overwriting concurrent changes.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a DNS record set (a collection of DNS records with the same name and type) in a Private DNS
     *     zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RecordSetInner> updateWithResponse(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        String relativeRecordSetName,
        RecordSetInner parameters,
        String ifMatch,
        Context context) {
        return updateWithResponseAsync(
                resourceGroupName, privateZoneName, recordType, relativeRecordSetName, parameters, ifMatch, context)
            .block();
    }

    /**
     * Deletes a record set from a Private DNS zone. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set. Record sets of type SOA cannot be deleted (they are
     *     deleted when the Private DNS zone is deleted).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param ifMatch The ETag of the record set. Omit this value to always delete the current record set. Specify the
     *     last-seen ETag value to prevent accidentally deleting any concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        String relativeRecordSetName,
        String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error(new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (relativeRecordSetName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            privateZoneName,
                            recordType,
                            relativeRecordSetName,
                            ifMatch,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Deletes a record set from a Private DNS zone. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set. Record sets of type SOA cannot be deleted (they are
     *     deleted when the Private DNS zone is deleted).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param ifMatch The ETag of the record set. Omit this value to always delete the current record set. Specify the
     *     last-seen ETag value to prevent accidentally deleting any concurrent changes.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        String relativeRecordSetName,
        String ifMatch,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error(new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (relativeRecordSetName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .delete(
                this.client.getEndpoint(),
                resourceGroupName,
                privateZoneName,
                recordType,
                relativeRecordSetName,
                ifMatch,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                context);
    }

    /**
     * Deletes a record set from a Private DNS zone. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set. Record sets of type SOA cannot be deleted (they are
     *     deleted when the Private DNS zone is deleted).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param ifMatch The ETag of the record set. Omit this value to always delete the current record set. Specify the
     *     last-seen ETag value to prevent accidentally deleting any concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        String relativeRecordSetName,
        String ifMatch) {
        return deleteWithResponseAsync(resourceGroupName, privateZoneName, recordType, relativeRecordSetName, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Deletes a record set from a Private DNS zone. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set. Record sets of type SOA cannot be deleted (they are
     *     deleted when the Private DNS zone is deleted).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(
        String resourceGroupName, String privateZoneName, RecordType recordType, String relativeRecordSetName) {
        final String ifMatch = null;
        return deleteWithResponseAsync(resourceGroupName, privateZoneName, recordType, relativeRecordSetName, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Deletes a record set from a Private DNS zone. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set. Record sets of type SOA cannot be deleted (they are
     *     deleted when the Private DNS zone is deleted).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(
        String resourceGroupName, String privateZoneName, RecordType recordType, String relativeRecordSetName) {
        final String ifMatch = null;
        deleteAsync(resourceGroupName, privateZoneName, recordType, relativeRecordSetName, ifMatch).block();
    }

    /**
     * Deletes a record set from a Private DNS zone. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set. Record sets of type SOA cannot be deleted (they are
     *     deleted when the Private DNS zone is deleted).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param ifMatch The ETag of the record set. Omit this value to always delete the current record set. Specify the
     *     last-seen ETag value to prevent accidentally deleting any concurrent changes.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        String relativeRecordSetName,
        String ifMatch,
        Context context) {
        return deleteWithResponseAsync(
                resourceGroupName, privateZoneName, recordType, relativeRecordSetName, ifMatch, context)
            .block();
    }

    /**
     * Gets a record set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set.
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a record set.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RecordSetInner>> getWithResponseAsync(
        String resourceGroupName, String privateZoneName, RecordType recordType, String relativeRecordSetName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error(new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (relativeRecordSetName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .get(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            privateZoneName,
                            recordType,
                            relativeRecordSetName,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Gets a record set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set.
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a record set.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<RecordSetInner>> getWithResponseAsync(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        String relativeRecordSetName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error(new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (relativeRecordSetName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .get(
                this.client.getEndpoint(),
                resourceGroupName,
                privateZoneName,
                recordType,
                relativeRecordSetName,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                context);
    }

    /**
     * Gets a record set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set.
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a record set.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RecordSetInner> getAsync(
        String resourceGroupName, String privateZoneName, RecordType recordType, String relativeRecordSetName) {
        return getWithResponseAsync(resourceGroupName, privateZoneName, recordType, relativeRecordSetName)
            .flatMap(
                (Response<RecordSetInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets a record set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set.
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a record set.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RecordSetInner get(
        String resourceGroupName, String privateZoneName, RecordType recordType, String relativeRecordSetName) {
        return getAsync(resourceGroupName, privateZoneName, recordType, relativeRecordSetName).block();
    }

    /**
     * Gets a record set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set.
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a record set.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RecordSetInner> getWithResponse(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        String relativeRecordSetName,
        Context context) {
        return getWithResponseAsync(resourceGroupName, privateZoneName, recordType, relativeRecordSetName, context)
            .block();
    }

    /**
     * Lists the record sets of a specified type in a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of record sets to enumerate.
     * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
     * @param recordsetnamesuffix The suffix label of the record set name to be used to filter the record set
     *     enumeration. If this parameter is specified, the returned enumeration will only contain records that end with
     *     ".&lt;recordsetnamesuffix&gt;".
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a record set list operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listByTypeSinglePageAsync(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        Integer top,
        String recordsetnamesuffix) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error(new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listByType(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            privateZoneName,
                            recordType,
                            top,
                            recordsetnamesuffix,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            context))
            .<PagedResponse<RecordSetInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Lists the record sets of a specified type in a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of record sets to enumerate.
     * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
     * @param recordsetnamesuffix The suffix label of the record set name to be used to filter the record set
     *     enumeration. If this parameter is specified, the returned enumeration will only contain records that end with
     *     ".&lt;recordsetnamesuffix&gt;".
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a record set list operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listByTypeSinglePageAsync(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        Integer top,
        String recordsetnamesuffix,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error(new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listByType(
                this.client.getEndpoint(),
                resourceGroupName,
                privateZoneName,
                recordType,
                top,
                recordsetnamesuffix,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Lists the record sets of a specified type in a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of record sets to enumerate.
     * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
     * @param recordsetnamesuffix The suffix label of the record set name to be used to filter the record set
     *     enumeration. If this parameter is specified, the returned enumeration will only contain records that end with
     *     ".&lt;recordsetnamesuffix&gt;".
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a record set list operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RecordSetInner> listByTypeAsync(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        Integer top,
        String recordsetnamesuffix) {
        return new PagedFlux<>(
            () -> listByTypeSinglePageAsync(resourceGroupName, privateZoneName, recordType, top, recordsetnamesuffix),
            nextLink -> listByTypeNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the record sets of a specified type in a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of record sets to enumerate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a record set list operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RecordSetInner> listByTypeAsync(
        String resourceGroupName, String privateZoneName, RecordType recordType) {
        final Integer top = null;
        final String recordsetnamesuffix = null;
        return new PagedFlux<>(
            () -> listByTypeSinglePageAsync(resourceGroupName, privateZoneName, recordType, top, recordsetnamesuffix),
            nextLink -> listByTypeNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the record sets of a specified type in a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of record sets to enumerate.
     * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
     * @param recordsetnamesuffix The suffix label of the record set name to be used to filter the record set
     *     enumeration. If this parameter is specified, the returned enumeration will only contain records that end with
     *     ".&lt;recordsetnamesuffix&gt;".
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a record set list operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<RecordSetInner> listByTypeAsync(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        Integer top,
        String recordsetnamesuffix,
        Context context) {
        return new PagedFlux<>(
            () ->
                listByTypeSinglePageAsync(
                    resourceGroupName, privateZoneName, recordType, top, recordsetnamesuffix, context),
            nextLink -> listByTypeNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists the record sets of a specified type in a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of record sets to enumerate.
     * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
     * @param recordsetnamesuffix The suffix label of the record set name to be used to filter the record set
     *     enumeration. If this parameter is specified, the returned enumeration will only contain records that end with
     *     ".&lt;recordsetnamesuffix&gt;".
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a record set list operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RecordSetInner> listByType(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        Integer top,
        String recordsetnamesuffix,
        Context context) {
        return new PagedIterable<>(
            listByTypeAsync(resourceGroupName, privateZoneName, recordType, top, recordsetnamesuffix, context));
    }

    /**
     * Lists the record sets of a specified type in a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of record sets to enumerate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a record set list operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RecordSetInner> listByType(
        String resourceGroupName, String privateZoneName, RecordType recordType) {
        final Integer top = null;
        final String recordsetnamesuffix = null;
        return new PagedIterable<>(
            listByTypeAsync(resourceGroupName, privateZoneName, recordType, top, recordsetnamesuffix));
    }

    /**
     * Lists all record sets in a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
     * @param recordsetnamesuffix The suffix label of the record set name to be used to filter the record set
     *     enumeration. If this parameter is specified, the returned enumeration will only contain records that end with
     *     ".&lt;recordsetnamesuffix&gt;".
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a record set list operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listSinglePageAsync(
        String resourceGroupName, String privateZoneName, Integer top, String recordsetnamesuffix) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .list(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            privateZoneName,
                            top,
                            recordsetnamesuffix,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            context))
            .<PagedResponse<RecordSetInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Lists all record sets in a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
     * @param recordsetnamesuffix The suffix label of the record set name to be used to filter the record set
     *     enumeration. If this parameter is specified, the returned enumeration will only contain records that end with
     *     ".&lt;recordsetnamesuffix&gt;".
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a record set list operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listSinglePageAsync(
        String resourceGroupName, String privateZoneName, Integer top, String recordsetnamesuffix, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .list(
                this.client.getEndpoint(),
                resourceGroupName,
                privateZoneName,
                top,
                recordsetnamesuffix,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Lists all record sets in a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
     * @param recordsetnamesuffix The suffix label of the record set name to be used to filter the record set
     *     enumeration. If this parameter is specified, the returned enumeration will only contain records that end with
     *     ".&lt;recordsetnamesuffix&gt;".
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a record set list operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RecordSetInner> listAsync(
        String resourceGroupName, String privateZoneName, Integer top, String recordsetnamesuffix) {
        return new PagedFlux<>(
            () -> listSinglePageAsync(resourceGroupName, privateZoneName, top, recordsetnamesuffix),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all record sets in a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a record set list operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RecordSetInner> listAsync(String resourceGroupName, String privateZoneName) {
        final Integer top = null;
        final String recordsetnamesuffix = null;
        return new PagedFlux<>(
            () -> listSinglePageAsync(resourceGroupName, privateZoneName, top, recordsetnamesuffix),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all record sets in a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
     * @param recordsetnamesuffix The suffix label of the record set name to be used to filter the record set
     *     enumeration. If this parameter is specified, the returned enumeration will only contain records that end with
     *     ".&lt;recordsetnamesuffix&gt;".
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a record set list operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<RecordSetInner> listAsync(
        String resourceGroupName, String privateZoneName, Integer top, String recordsetnamesuffix, Context context) {
        return new PagedFlux<>(
            () -> listSinglePageAsync(resourceGroupName, privateZoneName, top, recordsetnamesuffix, context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists all record sets in a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
     * @param recordsetnamesuffix The suffix label of the record set name to be used to filter the record set
     *     enumeration. If this parameter is specified, the returned enumeration will only contain records that end with
     *     ".&lt;recordsetnamesuffix&gt;".
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a record set list operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RecordSetInner> list(
        String resourceGroupName, String privateZoneName, Integer top, String recordsetnamesuffix, Context context) {
        return new PagedIterable<>(listAsync(resourceGroupName, privateZoneName, top, recordsetnamesuffix, context));
    }

    /**
     * Lists all record sets in a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a record set list operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RecordSetInner> list(String resourceGroupName, String privateZoneName) {
        final Integer top = null;
        final String recordsetnamesuffix = null;
        return new PagedIterable<>(listAsync(resourceGroupName, privateZoneName, top, recordsetnamesuffix));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a record set list operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listByTypeNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listByTypeNext(nextLink, context))
            .<PagedResponse<RecordSetInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a record set list operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listByTypeNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listByTypeNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a record set list operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listNext(nextLink, context))
            .<PagedResponse<RecordSetInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a record set list operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
