// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.privatedns.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.privatedns.fluent.models.RecordSetInner;
import com.azure.resourcemanager.privatedns.models.RecordType;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in RecordSetsClient. */
public interface RecordSetsClient {
    /**
     * Creates or updates a record set within a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set. Record sets of type SOA can be updated but not
     *     created (they are created when the Private DNS zone is created).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param parameters Describes a DNS record set (a collection of DNS records with the same name and type) in a
     *     Private DNS zone.
     * @param ifMatch The ETag of the record set. Omit this value to always overwrite the current record set. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new record set to be created, but to prevent updating an existing record
     *     set. Other values will be ignored.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a DNS record set (a collection of DNS records with the same name and type) in a Private DNS
     *     zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RecordSetInner>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        String relativeRecordSetName,
        RecordSetInner parameters,
        String ifMatch,
        String ifNoneMatch);

    /**
     * Creates or updates a record set within a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set. Record sets of type SOA can be updated but not
     *     created (they are created when the Private DNS zone is created).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param parameters Describes a DNS record set (a collection of DNS records with the same name and type) in a
     *     Private DNS zone.
     * @param ifMatch The ETag of the record set. Omit this value to always overwrite the current record set. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new record set to be created, but to prevent updating an existing record
     *     set. Other values will be ignored.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a DNS record set (a collection of DNS records with the same name and type) in a Private DNS
     *     zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RecordSetInner> createOrUpdateAsync(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        String relativeRecordSetName,
        RecordSetInner parameters,
        String ifMatch,
        String ifNoneMatch);

    /**
     * Creates or updates a record set within a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set. Record sets of type SOA can be updated but not
     *     created (they are created when the Private DNS zone is created).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param parameters Describes a DNS record set (a collection of DNS records with the same name and type) in a
     *     Private DNS zone.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a DNS record set (a collection of DNS records with the same name and type) in a Private DNS
     *     zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RecordSetInner> createOrUpdateAsync(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        String relativeRecordSetName,
        RecordSetInner parameters);

    /**
     * Creates or updates a record set within a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set. Record sets of type SOA can be updated but not
     *     created (they are created when the Private DNS zone is created).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param parameters Describes a DNS record set (a collection of DNS records with the same name and type) in a
     *     Private DNS zone.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a DNS record set (a collection of DNS records with the same name and type) in a Private DNS
     *     zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RecordSetInner createOrUpdate(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        String relativeRecordSetName,
        RecordSetInner parameters);

    /**
     * Creates or updates a record set within a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set. Record sets of type SOA can be updated but not
     *     created (they are created when the Private DNS zone is created).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param parameters Describes a DNS record set (a collection of DNS records with the same name and type) in a
     *     Private DNS zone.
     * @param ifMatch The ETag of the record set. Omit this value to always overwrite the current record set. Specify
     *     the last-seen ETag value to prevent accidentally overwriting any concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new record set to be created, but to prevent updating an existing record
     *     set. Other values will be ignored.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a DNS record set (a collection of DNS records with the same name and type) in a Private DNS
     *     zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RecordSetInner> createOrUpdateWithResponse(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        String relativeRecordSetName,
        RecordSetInner parameters,
        String ifMatch,
        String ifNoneMatch,
        Context context);

    /**
     * Updates a record set within a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set.
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param parameters Describes a DNS record set (a collection of DNS records with the same name and type) in a
     *     Private DNS zone.
     * @param ifMatch The ETag of the record set. Omit this value to always overwrite the current record set. Specify
     *     the last-seen ETag value to prevent accidentally overwriting concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a DNS record set (a collection of DNS records with the same name and type) in a Private DNS
     *     zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RecordSetInner>> updateWithResponseAsync(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        String relativeRecordSetName,
        RecordSetInner parameters,
        String ifMatch);

    /**
     * Updates a record set within a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set.
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param parameters Describes a DNS record set (a collection of DNS records with the same name and type) in a
     *     Private DNS zone.
     * @param ifMatch The ETag of the record set. Omit this value to always overwrite the current record set. Specify
     *     the last-seen ETag value to prevent accidentally overwriting concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a DNS record set (a collection of DNS records with the same name and type) in a Private DNS
     *     zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RecordSetInner> updateAsync(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        String relativeRecordSetName,
        RecordSetInner parameters,
        String ifMatch);

    /**
     * Updates a record set within a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set.
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param parameters Describes a DNS record set (a collection of DNS records with the same name and type) in a
     *     Private DNS zone.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a DNS record set (a collection of DNS records with the same name and type) in a Private DNS
     *     zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RecordSetInner> updateAsync(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        String relativeRecordSetName,
        RecordSetInner parameters);

    /**
     * Updates a record set within a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set.
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param parameters Describes a DNS record set (a collection of DNS records with the same name and type) in a
     *     Private DNS zone.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a DNS record set (a collection of DNS records with the same name and type) in a Private DNS
     *     zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RecordSetInner update(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        String relativeRecordSetName,
        RecordSetInner parameters);

    /**
     * Updates a record set within a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set.
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param parameters Describes a DNS record set (a collection of DNS records with the same name and type) in a
     *     Private DNS zone.
     * @param ifMatch The ETag of the record set. Omit this value to always overwrite the current record set. Specify
     *     the last-seen ETag value to prevent accidentally overwriting concurrent changes.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a DNS record set (a collection of DNS records with the same name and type) in a Private DNS
     *     zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RecordSetInner> updateWithResponse(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        String relativeRecordSetName,
        RecordSetInner parameters,
        String ifMatch,
        Context context);

    /**
     * Deletes a record set from a Private DNS zone. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set. Record sets of type SOA cannot be deleted (they are
     *     deleted when the Private DNS zone is deleted).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param ifMatch The ETag of the record set. Omit this value to always delete the current record set. Specify the
     *     last-seen ETag value to prevent accidentally deleting any concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteWithResponseAsync(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        String relativeRecordSetName,
        String ifMatch);

    /**
     * Deletes a record set from a Private DNS zone. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set. Record sets of type SOA cannot be deleted (they are
     *     deleted when the Private DNS zone is deleted).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param ifMatch The ETag of the record set. Omit this value to always delete the current record set. Specify the
     *     last-seen ETag value to prevent accidentally deleting any concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        String relativeRecordSetName,
        String ifMatch);

    /**
     * Deletes a record set from a Private DNS zone. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set. Record sets of type SOA cannot be deleted (they are
     *     deleted when the Private DNS zone is deleted).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(
        String resourceGroupName, String privateZoneName, RecordType recordType, String relativeRecordSetName);

    /**
     * Deletes a record set from a Private DNS zone. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set. Record sets of type SOA cannot be deleted (they are
     *     deleted when the Private DNS zone is deleted).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String privateZoneName, RecordType recordType, String relativeRecordSetName);

    /**
     * Deletes a record set from a Private DNS zone. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set. Record sets of type SOA cannot be deleted (they are
     *     deleted when the Private DNS zone is deleted).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param ifMatch The ETag of the record set. Omit this value to always delete the current record set. Specify the
     *     last-seen ETag value to prevent accidentally deleting any concurrent changes.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        String relativeRecordSetName,
        String ifMatch,
        Context context);

    /**
     * Gets a record set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set.
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a record set.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RecordSetInner>> getWithResponseAsync(
        String resourceGroupName, String privateZoneName, RecordType recordType, String relativeRecordSetName);

    /**
     * Gets a record set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set.
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a record set.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RecordSetInner> getAsync(
        String resourceGroupName, String privateZoneName, RecordType recordType, String relativeRecordSetName);

    /**
     * Gets a record set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set.
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a record set.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RecordSetInner get(
        String resourceGroupName, String privateZoneName, RecordType recordType, String relativeRecordSetName);

    /**
     * Gets a record set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of DNS record in this record set.
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a record set.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RecordSetInner> getWithResponse(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        String relativeRecordSetName,
        Context context);

    /**
     * Lists the record sets of a specified type in a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of record sets to enumerate.
     * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
     * @param recordsetnamesuffix The suffix label of the record set name to be used to filter the record set
     *     enumeration. If this parameter is specified, the returned enumeration will only contain records that end with
     *     ".&lt;recordsetnamesuffix&gt;".
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a record set list operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<RecordSetInner> listByTypeAsync(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        Integer top,
        String recordsetnamesuffix);

    /**
     * Lists the record sets of a specified type in a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of record sets to enumerate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a record set list operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<RecordSetInner> listByTypeAsync(String resourceGroupName, String privateZoneName, RecordType recordType);

    /**
     * Lists the record sets of a specified type in a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of record sets to enumerate.
     * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
     * @param recordsetnamesuffix The suffix label of the record set name to be used to filter the record set
     *     enumeration. If this parameter is specified, the returned enumeration will only contain records that end with
     *     ".&lt;recordsetnamesuffix&gt;".
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a record set list operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RecordSetInner> listByType(
        String resourceGroupName,
        String privateZoneName,
        RecordType recordType,
        Integer top,
        String recordsetnamesuffix,
        Context context);

    /**
     * Lists the record sets of a specified type in a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param recordType The type of record sets to enumerate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a record set list operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RecordSetInner> listByType(String resourceGroupName, String privateZoneName, RecordType recordType);

    /**
     * Lists all record sets in a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
     * @param recordsetnamesuffix The suffix label of the record set name to be used to filter the record set
     *     enumeration. If this parameter is specified, the returned enumeration will only contain records that end with
     *     ".&lt;recordsetnamesuffix&gt;".
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a record set list operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<RecordSetInner> listAsync(
        String resourceGroupName, String privateZoneName, Integer top, String recordsetnamesuffix);

    /**
     * Lists all record sets in a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a record set list operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<RecordSetInner> listAsync(String resourceGroupName, String privateZoneName);

    /**
     * Lists all record sets in a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
     * @param recordsetnamesuffix The suffix label of the record set name to be used to filter the record set
     *     enumeration. If this parameter is specified, the returned enumeration will only contain records that end with
     *     ".&lt;recordsetnamesuffix&gt;".
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a record set list operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RecordSetInner> list(
        String resourceGroupName, String privateZoneName, Integer top, String recordsetnamesuffix, Context context);

    /**
     * Lists all record sets in a Private DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param privateZoneName The name of the Private DNS zone (without a terminating dot).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response to a record set list operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RecordSetInner> list(String resourceGroupName, String privateZoneName);
}
