/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.recoveryservices;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.http.policy.ArmChallengeAuthenticationPolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.recoveryservices.fluent.RecoveryServicesManagementClient;
import com.azure.resourcemanager.recoveryservices.implementation.OperationsImpl;
import com.azure.resourcemanager.recoveryservices.implementation.PrivateLinkResourcesOperationsImpl;
import com.azure.resourcemanager.recoveryservices.implementation.RecoveryServicesImpl;
import com.azure.resourcemanager.recoveryservices.implementation.RecoveryServicesManagementClientBuilder;
import com.azure.resourcemanager.recoveryservices.implementation.RegisteredIdentitiesImpl;
import com.azure.resourcemanager.recoveryservices.implementation.ReplicationUsagesImpl;
import com.azure.resourcemanager.recoveryservices.implementation.ResourceProvidersImpl;
import com.azure.resourcemanager.recoveryservices.implementation.UsagesImpl;
import com.azure.resourcemanager.recoveryservices.implementation.VaultCertificatesImpl;
import com.azure.resourcemanager.recoveryservices.implementation.VaultExtendedInfoesImpl;
import com.azure.resourcemanager.recoveryservices.implementation.VaultsImpl;
import com.azure.resourcemanager.recoveryservices.models.Operations;
import com.azure.resourcemanager.recoveryservices.models.PrivateLinkResourcesOperations;
import com.azure.resourcemanager.recoveryservices.models.RecoveryServices;
import com.azure.resourcemanager.recoveryservices.models.RegisteredIdentities;
import com.azure.resourcemanager.recoveryservices.models.ReplicationUsages;
import com.azure.resourcemanager.recoveryservices.models.ResourceProviders;
import com.azure.resourcemanager.recoveryservices.models.Usages;
import com.azure.resourcemanager.recoveryservices.models.VaultCertificates;
import com.azure.resourcemanager.recoveryservices.models.VaultExtendedInfoes;
import com.azure.resourcemanager.recoveryservices.models.Vaults;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class RecoveryServicesManager {
    private VaultCertificates vaultCertificates;
    private RegisteredIdentities registeredIdentities;
    private ReplicationUsages replicationUsages;
    private PrivateLinkResourcesOperations privateLinkResourcesOperations;
    private RecoveryServices recoveryServices;
    private Vaults vaults;
    private Operations operations;
    private VaultExtendedInfoes vaultExtendedInfoes;
    private ResourceProviders resourceProviders;
    private Usages usages;
    private final RecoveryServicesManagementClient clientObject;

    private RecoveryServicesManager(HttpPipeline httpPipeline, AzureProfile profile, Duration defaultPollInterval) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        this.clientObject = new RecoveryServicesManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).defaultPollInterval(defaultPollInterval).buildClient();
    }

    public static RecoveryServicesManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return RecoveryServicesManager.configure().authenticate(credential, profile);
    }

    public static RecoveryServicesManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new RecoveryServicesManager(httpPipeline, profile, null);
    }

    public static Configurable configure() {
        return new Configurable();
    }

    public VaultCertificates vaultCertificates() {
        if (this.vaultCertificates == null) {
            this.vaultCertificates = new VaultCertificatesImpl(this.clientObject.getVaultCertificates(), this);
        }
        return this.vaultCertificates;
    }

    public RegisteredIdentities registeredIdentities() {
        if (this.registeredIdentities == null) {
            this.registeredIdentities = new RegisteredIdentitiesImpl(this.clientObject.getRegisteredIdentities(), this);
        }
        return this.registeredIdentities;
    }

    public ReplicationUsages replicationUsages() {
        if (this.replicationUsages == null) {
            this.replicationUsages = new ReplicationUsagesImpl(this.clientObject.getReplicationUsages(), this);
        }
        return this.replicationUsages;
    }

    public PrivateLinkResourcesOperations privateLinkResourcesOperations() {
        if (this.privateLinkResourcesOperations == null) {
            this.privateLinkResourcesOperations = new PrivateLinkResourcesOperationsImpl(this.clientObject.getPrivateLinkResourcesOperations(), this);
        }
        return this.privateLinkResourcesOperations;
    }

    public RecoveryServices recoveryServices() {
        if (this.recoveryServices == null) {
            this.recoveryServices = new RecoveryServicesImpl(this.clientObject.getRecoveryServices(), this);
        }
        return this.recoveryServices;
    }

    public Vaults vaults() {
        if (this.vaults == null) {
            this.vaults = new VaultsImpl(this.clientObject.getVaults(), this);
        }
        return this.vaults;
    }

    public Operations operations() {
        if (this.operations == null) {
            this.operations = new OperationsImpl(this.clientObject.getOperations(), this);
        }
        return this.operations;
    }

    public VaultExtendedInfoes vaultExtendedInfoes() {
        if (this.vaultExtendedInfoes == null) {
            this.vaultExtendedInfoes = new VaultExtendedInfoesImpl(this.clientObject.getVaultExtendedInfoes(), this);
        }
        return this.vaultExtendedInfoes;
    }

    public ResourceProviders resourceProviders() {
        if (this.resourceProviders == null) {
            this.resourceProviders = new ResourceProvidersImpl(this.clientObject.getResourceProviders(), this);
        }
        return this.resourceProviders;
    }

    public Usages usages() {
        if (this.usages == null) {
            this.usages = new UsagesImpl(this.clientObject.getUsages(), this);
        }
        return this.usages;
    }

    public RecoveryServicesManagementClient serviceClient() {
        return this.clientObject;
    }

    public static final class Configurable {
        private static final ClientLogger LOGGER = new ClientLogger(Configurable.class);
        private HttpClient httpClient;
        private HttpLogOptions httpLogOptions;
        private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        private final List<String> scopes = new ArrayList<String>();
        private RetryPolicy retryPolicy;
        private RetryOptions retryOptions;
        private Duration defaultPollInterval;

        private Configurable() {
        }

        public Configurable withHttpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
            return this;
        }

        public Configurable withLogOptions(HttpLogOptions httpLogOptions) {
            this.httpLogOptions = Objects.requireNonNull(httpLogOptions, "'httpLogOptions' cannot be null.");
            return this;
        }

        public Configurable withPolicy(HttpPipelinePolicy policy) {
            this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
            return this;
        }

        public Configurable withScope(String scope) {
            this.scopes.add(Objects.requireNonNull(scope, "'scope' cannot be null."));
            return this;
        }

        public Configurable withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
            return this;
        }

        public Configurable withRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
            return this;
        }

        public Configurable withDefaultPollInterval(Duration defaultPollInterval) {
            this.defaultPollInterval = Objects.requireNonNull(defaultPollInterval, "'defaultPollInterval' cannot be null.");
            if (this.defaultPollInterval.isNegative()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'defaultPollInterval' cannot be negative"));
            }
            return this;
        }

        public RecoveryServicesManager authenticate(TokenCredential credential, AzureProfile profile) {
            Objects.requireNonNull(credential, "'credential' cannot be null.");
            Objects.requireNonNull(profile, "'profile' cannot be null.");
            StringBuilder userAgentBuilder = new StringBuilder();
            userAgentBuilder.append("azsdk-java").append("-").append("com.azure.resourcemanager.recoveryservices").append("/").append("1.3.0");
            if (!((Boolean)Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", (Object)false)).booleanValue()) {
                userAgentBuilder.append(" (").append(Configuration.getGlobalConfiguration().get("java.version")).append("; ").append(Configuration.getGlobalConfiguration().get("os.name")).append("; ").append(Configuration.getGlobalConfiguration().get("os.version")).append("; auto-generated)");
            } else {
                userAgentBuilder.append(" (auto-generated)");
            }
            if (this.scopes.isEmpty()) {
                this.scopes.add(profile.getEnvironment().getManagementEndpoint() + "/.default");
            }
            if (this.retryPolicy == null) {
                this.retryPolicy = this.retryOptions != null ? new RetryPolicy(this.retryOptions) : new RetryPolicy("Retry-After", ChronoUnit.SECONDS);
            }
            ArrayList<Object> policies = new ArrayList<Object>();
            policies.add(new UserAgentPolicy(userAgentBuilder.toString()));
            policies.add(new AddHeadersFromContextPolicy());
            policies.add(new RequestIdPolicy());
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).collect(Collectors.toList()));
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(this.retryPolicy);
            policies.add(new AddDatePolicy());
            policies.add(new ArmChallengeAuthenticationPolicy(credential, this.scopes.toArray(new String[0])));
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).collect(Collectors.toList()));
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(this.httpLogOptions));
            HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(this.httpClient).policies(policies.toArray(new HttpPipelinePolicy[0])).build();
            return new RecoveryServicesManager(httpPipeline, profile, this.defaultPollInterval);
        }
    }
}

