/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.recoveryservices.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.resourcemanager.recoveryservices.models.IdentityData;
import com.azure.resourcemanager.recoveryservices.models.Sku;
import com.azure.resourcemanager.recoveryservices.models.VaultProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class VaultInner
extends Resource {
    @JsonProperty(value="identity")
    private IdentityData identity;
    @JsonProperty(value="properties")
    private VaultProperties properties;
    @JsonProperty(value="sku")
    private Sku sku;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;
    @JsonProperty(value="etag")
    private String etag;

    public IdentityData identity() {
        return this.identity;
    }

    public VaultInner withIdentity(IdentityData identity) {
        this.identity = identity;
        return this;
    }

    public VaultProperties properties() {
        return this.properties;
    }

    public VaultInner withProperties(VaultProperties properties) {
        this.properties = properties;
        return this;
    }

    public Sku sku() {
        return this.sku;
    }

    public VaultInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String etag() {
        return this.etag;
    }

    public VaultInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public VaultInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VaultInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.properties() != null) {
            this.properties().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
    }
}

