/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.recoveryservices.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.recoveryservices.RecoveryServicesManager;
import com.azure.resourcemanager.recoveryservices.fluent.OperationsClient;
import com.azure.resourcemanager.recoveryservices.fluent.models.ClientDiscoveryValueForSingleApiInner;
import com.azure.resourcemanager.recoveryservices.implementation.ClientDiscoveryValueForSingleApiImpl;
import com.azure.resourcemanager.recoveryservices.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.recoveryservices.models.ClientDiscoveryValueForSingleApi;
import com.azure.resourcemanager.recoveryservices.models.Operations;

public final class OperationsImpl
implements Operations {
    private static final ClientLogger LOGGER = new ClientLogger(OperationsImpl.class);
    private final OperationsClient innerClient;
    private final RecoveryServicesManager serviceManager;

    public OperationsImpl(OperationsClient innerClient, RecoveryServicesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ClientDiscoveryValueForSingleApi> list() {
        PagedIterable<ClientDiscoveryValueForSingleApiInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ClientDiscoveryValueForSingleApiImpl((ClientDiscoveryValueForSingleApiInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<ClientDiscoveryValueForSingleApi> list(Context context) {
        PagedIterable<ClientDiscoveryValueForSingleApiInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ClientDiscoveryValueForSingleApiImpl((ClientDiscoveryValueForSingleApiInner)inner1, this.manager()));
    }

    private OperationsClient serviceClient() {
        return this.innerClient;
    }

    private RecoveryServicesManager manager() {
        return this.serviceManager;
    }
}

