/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.recoveryservices.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.recoveryservices.RecoveryServicesManager;
import com.azure.resourcemanager.recoveryservices.fluent.PrivateLinkResourcesOperationsClient;
import com.azure.resourcemanager.recoveryservices.fluent.models.PrivateLinkResourceInner;
import com.azure.resourcemanager.recoveryservices.implementation.PrivateLinkResourceImpl;
import com.azure.resourcemanager.recoveryservices.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.recoveryservices.models.PrivateLinkResource;
import com.azure.resourcemanager.recoveryservices.models.PrivateLinkResourcesOperations;

public final class PrivateLinkResourcesOperationsImpl
implements PrivateLinkResourcesOperations {
    private static final ClientLogger LOGGER = new ClientLogger(PrivateLinkResourcesOperationsImpl.class);
    private final PrivateLinkResourcesOperationsClient innerClient;
    private final RecoveryServicesManager serviceManager;

    public PrivateLinkResourcesOperationsImpl(PrivateLinkResourcesOperationsClient innerClient, RecoveryServicesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<PrivateLinkResource> list(String resourceGroupName, String vaultName) {
        PagedIterable<PrivateLinkResourceInner> inner = this.serviceClient().list(resourceGroupName, vaultName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PrivateLinkResourceImpl((PrivateLinkResourceInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PrivateLinkResource> list(String resourceGroupName, String vaultName, Context context) {
        PagedIterable<PrivateLinkResourceInner> inner = this.serviceClient().list(resourceGroupName, vaultName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PrivateLinkResourceImpl((PrivateLinkResourceInner)inner1, this.manager()));
    }

    @Override
    public Response<PrivateLinkResource> getWithResponse(String resourceGroupName, String vaultName, String privateLinkResourceName, Context context) {
        Response<PrivateLinkResourceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, vaultName, privateLinkResourceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PrivateLinkResourceImpl((PrivateLinkResourceInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PrivateLinkResource get(String resourceGroupName, String vaultName, String privateLinkResourceName) {
        PrivateLinkResourceInner inner = this.serviceClient().get(resourceGroupName, vaultName, privateLinkResourceName);
        if (inner != null) {
            return new PrivateLinkResourceImpl(inner, this.manager());
        }
        return null;
    }

    private PrivateLinkResourcesOperationsClient serviceClient() {
        return this.innerClient;
    }

    private RecoveryServicesManager manager() {
        return this.serviceManager;
    }
}

