/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.recoveryservices.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.recoveryservices.RecoveryServicesManager;
import com.azure.resourcemanager.recoveryservices.fluent.ResourceProvidersClient;
import com.azure.resourcemanager.recoveryservices.fluent.models.OperationResourceInner;
import com.azure.resourcemanager.recoveryservices.fluent.models.VaultInner;
import com.azure.resourcemanager.recoveryservices.implementation.OperationResourceImpl;
import com.azure.resourcemanager.recoveryservices.implementation.VaultImpl;
import com.azure.resourcemanager.recoveryservices.models.OperationResource;
import com.azure.resourcemanager.recoveryservices.models.ResourceProviders;
import com.azure.resourcemanager.recoveryservices.models.Vault;

public final class ResourceProvidersImpl
implements ResourceProviders {
    private static final ClientLogger LOGGER = new ClientLogger(ResourceProvidersImpl.class);
    private final ResourceProvidersClient innerClient;
    private final RecoveryServicesManager serviceManager;

    public ResourceProvidersImpl(ResourceProvidersClient innerClient, RecoveryServicesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<OperationResource> getOperationStatusWithResponse(String resourceGroupName, String vaultName, String operationId, Context context) {
        Response<OperationResourceInner> inner = this.serviceClient().getOperationStatusWithResponse(resourceGroupName, vaultName, operationId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new OperationResourceImpl((OperationResourceInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public OperationResource getOperationStatus(String resourceGroupName, String vaultName, String operationId) {
        OperationResourceInner inner = this.serviceClient().getOperationStatus(resourceGroupName, vaultName, operationId);
        if (inner != null) {
            return new OperationResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Vault> getOperationResultWithResponse(String resourceGroupName, String vaultName, String operationId, Context context) {
        Response<VaultInner> inner = this.serviceClient().getOperationResultWithResponse(resourceGroupName, vaultName, operationId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new VaultImpl((VaultInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Vault getOperationResult(String resourceGroupName, String vaultName, String operationId) {
        VaultInner inner = this.serviceClient().getOperationResult(resourceGroupName, vaultName, operationId);
        if (inner != null) {
            return new VaultImpl(inner, this.manager());
        }
        return null;
    }

    private ResourceProvidersClient serviceClient() {
        return this.innerClient;
    }

    private RecoveryServicesManager manager() {
        return this.serviceManager;
    }
}

