/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.recoveryservices.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.recoveryservices.RecoveryServicesManager;
import com.azure.resourcemanager.recoveryservices.fluent.UsagesClient;
import com.azure.resourcemanager.recoveryservices.fluent.models.VaultUsageInner;
import com.azure.resourcemanager.recoveryservices.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.recoveryservices.implementation.VaultUsageImpl;
import com.azure.resourcemanager.recoveryservices.models.Usages;
import com.azure.resourcemanager.recoveryservices.models.VaultUsage;

public final class UsagesImpl
implements Usages {
    private static final ClientLogger LOGGER = new ClientLogger(UsagesImpl.class);
    private final UsagesClient innerClient;
    private final RecoveryServicesManager serviceManager;

    public UsagesImpl(UsagesClient innerClient, RecoveryServicesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<VaultUsage> listByVaults(String resourceGroupName, String vaultName) {
        PagedIterable<VaultUsageInner> inner = this.serviceClient().listByVaults(resourceGroupName, vaultName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VaultUsageImpl((VaultUsageInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<VaultUsage> listByVaults(String resourceGroupName, String vaultName, Context context) {
        PagedIterable<VaultUsageInner> inner = this.serviceClient().listByVaults(resourceGroupName, vaultName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VaultUsageImpl((VaultUsageInner)inner1, this.manager()));
    }

    private UsagesClient serviceClient() {
        return this.innerClient;
    }

    private RecoveryServicesManager manager() {
        return this.serviceManager;
    }
}

