/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.recoveryservices.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.recoveryservices.fluent.VaultExtendedInfoesClient;
import com.azure.resourcemanager.recoveryservices.fluent.models.VaultExtendedInfoResourceInner;
import com.azure.resourcemanager.recoveryservices.implementation.RecoveryServicesManagementClientImpl;
import reactor.core.publisher.Mono;

public final class VaultExtendedInfoesClientImpl
implements VaultExtendedInfoesClient {
    private final VaultExtendedInfoesService service;
    private final RecoveryServicesManagementClientImpl client;

    VaultExtendedInfoesClientImpl(RecoveryServicesManagementClientImpl client) {
        this.service = (VaultExtendedInfoesService)RestProxy.create(VaultExtendedInfoesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<VaultExtendedInfoResourceInner>> getWithResponseAsync(String resourceGroupName, String vaultName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), resourceGroupName, vaultName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<VaultExtendedInfoResourceInner>> getWithResponseAsync(String resourceGroupName, String vaultName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), resourceGroupName, vaultName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VaultExtendedInfoResourceInner> getAsync(String resourceGroupName, String vaultName) {
        return this.getWithResponseAsync(resourceGroupName, vaultName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((VaultExtendedInfoResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<VaultExtendedInfoResourceInner> getWithResponse(String resourceGroupName, String vaultName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, vaultName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VaultExtendedInfoResourceInner get(String resourceGroupName, String vaultName) {
        return (VaultExtendedInfoResourceInner)((Object)this.getWithResponse(resourceGroupName, vaultName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<VaultExtendedInfoResourceInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String vaultName, VaultExtendedInfoResourceInner resourceExtendedInfoDetails) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (resourceExtendedInfoDetails == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceExtendedInfoDetails is required and cannot be null."));
        }
        resourceExtendedInfoDetails.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, vaultName, this.client.getApiVersion(), resourceExtendedInfoDetails, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<VaultExtendedInfoResourceInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String vaultName, VaultExtendedInfoResourceInner resourceExtendedInfoDetails, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (resourceExtendedInfoDetails == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceExtendedInfoDetails is required and cannot be null."));
        }
        resourceExtendedInfoDetails.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, vaultName, this.client.getApiVersion(), resourceExtendedInfoDetails, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VaultExtendedInfoResourceInner> createOrUpdateAsync(String resourceGroupName, String vaultName, VaultExtendedInfoResourceInner resourceExtendedInfoDetails) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, vaultName, resourceExtendedInfoDetails).flatMap(res -> Mono.justOrEmpty((Object)((Object)((VaultExtendedInfoResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<VaultExtendedInfoResourceInner> createOrUpdateWithResponse(String resourceGroupName, String vaultName, VaultExtendedInfoResourceInner resourceExtendedInfoDetails, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, vaultName, resourceExtendedInfoDetails, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VaultExtendedInfoResourceInner createOrUpdate(String resourceGroupName, String vaultName, VaultExtendedInfoResourceInner resourceExtendedInfoDetails) {
        return (VaultExtendedInfoResourceInner)((Object)this.createOrUpdateWithResponse(resourceGroupName, vaultName, resourceExtendedInfoDetails, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<VaultExtendedInfoResourceInner>> updateWithResponseAsync(String resourceGroupName, String vaultName, VaultExtendedInfoResourceInner resourceExtendedInfoDetails) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (resourceExtendedInfoDetails == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceExtendedInfoDetails is required and cannot be null."));
        }
        resourceExtendedInfoDetails.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, vaultName, this.client.getApiVersion(), resourceExtendedInfoDetails, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<VaultExtendedInfoResourceInner>> updateWithResponseAsync(String resourceGroupName, String vaultName, VaultExtendedInfoResourceInner resourceExtendedInfoDetails, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (resourceExtendedInfoDetails == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceExtendedInfoDetails is required and cannot be null."));
        }
        resourceExtendedInfoDetails.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, vaultName, this.client.getApiVersion(), resourceExtendedInfoDetails, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VaultExtendedInfoResourceInner> updateAsync(String resourceGroupName, String vaultName, VaultExtendedInfoResourceInner resourceExtendedInfoDetails) {
        return this.updateWithResponseAsync(resourceGroupName, vaultName, resourceExtendedInfoDetails).flatMap(res -> Mono.justOrEmpty((Object)((Object)((VaultExtendedInfoResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<VaultExtendedInfoResourceInner> updateWithResponse(String resourceGroupName, String vaultName, VaultExtendedInfoResourceInner resourceExtendedInfoDetails, Context context) {
        return (Response)this.updateWithResponseAsync(resourceGroupName, vaultName, resourceExtendedInfoDetails, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VaultExtendedInfoResourceInner update(String resourceGroupName, String vaultName, VaultExtendedInfoResourceInner resourceExtendedInfoDetails) {
        return (VaultExtendedInfoResourceInner)((Object)this.updateWithResponse(resourceGroupName, vaultName, resourceExtendedInfoDetails, Context.NONE).getValue());
    }

    @Host(value="{$host}")
    @ServiceInterface(name="RecoveryServicesMana")
    public static interface VaultExtendedInfoesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/extendedInformation/vaultExtendedInfo")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VaultExtendedInfoResourceInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="vaultName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/extendedInformation/vaultExtendedInfo")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VaultExtendedInfoResourceInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="vaultName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") VaultExtendedInfoResourceInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/extendedInformation/vaultExtendedInfo")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VaultExtendedInfoResourceInner>> update(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="vaultName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") VaultExtendedInfoResourceInner var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

