/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.recoveryservices.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.recoveryservices.RecoveryServicesManager;
import com.azure.resourcemanager.recoveryservices.fluent.models.VaultInner;
import com.azure.resourcemanager.recoveryservices.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.recoveryservices.models.IdentityData;
import com.azure.resourcemanager.recoveryservices.models.PatchVault;
import com.azure.resourcemanager.recoveryservices.models.Sku;
import com.azure.resourcemanager.recoveryservices.models.Vault;
import com.azure.resourcemanager.recoveryservices.models.VaultProperties;
import java.util.Collections;
import java.util.Map;

public final class VaultImpl
implements Vault,
Vault.Definition,
Vault.Update {
    private VaultInner innerObject;
    private final RecoveryServicesManager serviceManager;
    private String resourceGroupName;
    private String vaultName;
    private String createXMsAuthorizationAuxiliary;
    private String updateXMsAuthorizationAuxiliary;
    private PatchVault updateVault;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public IdentityData identity() {
        return this.innerModel().identity();
    }

    @Override
    public VaultProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public Sku sku() {
        return this.innerModel().sku();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public VaultInner innerModel() {
        return this.innerObject;
    }

    private RecoveryServicesManager manager() {
        return this.serviceManager;
    }

    @Override
    public VaultImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Vault create() {
        this.innerObject = this.serviceManager.serviceClient().getVaults().createOrUpdate(this.resourceGroupName, this.vaultName, this.innerModel(), this.createXMsAuthorizationAuxiliary, Context.NONE);
        return this;
    }

    @Override
    public Vault create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getVaults().createOrUpdate(this.resourceGroupName, this.vaultName, this.innerModel(), this.createXMsAuthorizationAuxiliary, context);
        return this;
    }

    VaultImpl(String name, RecoveryServicesManager serviceManager) {
        this.innerObject = new VaultInner();
        this.serviceManager = serviceManager;
        this.vaultName = name;
        this.createXMsAuthorizationAuxiliary = null;
    }

    @Override
    public VaultImpl update() {
        this.updateXMsAuthorizationAuxiliary = null;
        this.updateVault = new PatchVault();
        return this;
    }

    @Override
    public Vault apply() {
        this.innerObject = this.serviceManager.serviceClient().getVaults().update(this.resourceGroupName, this.vaultName, this.updateVault, this.updateXMsAuthorizationAuxiliary, Context.NONE);
        return this;
    }

    @Override
    public Vault apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getVaults().update(this.resourceGroupName, this.vaultName, this.updateVault, this.updateXMsAuthorizationAuxiliary, context);
        return this;
    }

    VaultImpl(VaultInner innerObject, RecoveryServicesManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.vaultName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "vaults");
    }

    @Override
    public Vault refresh() {
        this.innerObject = (VaultInner)((Object)this.serviceManager.serviceClient().getVaults().getByResourceGroupWithResponse(this.resourceGroupName, this.vaultName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Vault refresh(Context context) {
        this.innerObject = (VaultInner)((Object)this.serviceManager.serviceClient().getVaults().getByResourceGroupWithResponse(this.resourceGroupName, this.vaultName, context).getValue());
        return this;
    }

    @Override
    public VaultImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public VaultImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public VaultImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateVault.withTags((Map)tags);
        return this;
    }

    @Override
    public VaultImpl withIdentity(IdentityData identity) {
        if (this.isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        }
        this.updateVault.withIdentity(identity);
        return this;
    }

    @Override
    public VaultImpl withProperties(VaultProperties properties) {
        if (this.isInCreateMode()) {
            this.innerModel().withProperties(properties);
            return this;
        }
        this.updateVault.withProperties(properties);
        return this;
    }

    @Override
    public VaultImpl withSku(Sku sku) {
        if (this.isInCreateMode()) {
            this.innerModel().withSku(sku);
            return this;
        }
        this.updateVault.withSku(sku);
        return this;
    }

    @Override
    public VaultImpl withEtag(String etag) {
        if (this.isInCreateMode()) {
            this.innerModel().withEtag(etag);
            return this;
        }
        this.updateVault.withEtag(etag);
        return this;
    }

    @Override
    public VaultImpl withXMsAuthorizationAuxiliary(String xMsAuthorizationAuxiliary) {
        if (this.isInCreateMode()) {
            this.createXMsAuthorizationAuxiliary = xMsAuthorizationAuxiliary;
            return this;
        }
        this.updateXMsAuthorizationAuxiliary = xMsAuthorizationAuxiliary;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

