/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.recoveryservices.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.recoveryservices.RecoveryServicesManager;
import com.azure.resourcemanager.recoveryservices.fluent.VaultsClient;
import com.azure.resourcemanager.recoveryservices.fluent.models.VaultInner;
import com.azure.resourcemanager.recoveryservices.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.recoveryservices.implementation.VaultImpl;
import com.azure.resourcemanager.recoveryservices.models.Vault;
import com.azure.resourcemanager.recoveryservices.models.Vaults;

public final class VaultsImpl
implements Vaults {
    private static final ClientLogger LOGGER = new ClientLogger(VaultsImpl.class);
    private final VaultsClient innerClient;
    private final RecoveryServicesManager serviceManager;

    public VaultsImpl(VaultsClient innerClient, RecoveryServicesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Vault> list() {
        PagedIterable<VaultInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VaultImpl((VaultInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Vault> list(Context context) {
        PagedIterable<VaultInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VaultImpl((VaultInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Vault> listByResourceGroup(String resourceGroupName) {
        PagedIterable<VaultInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VaultImpl((VaultInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Vault> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<VaultInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VaultImpl((VaultInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Vault> getByResourceGroupWithResponse(String resourceGroupName, String vaultName, Context context) {
        Response<VaultInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, vaultName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new VaultImpl((VaultInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Vault getByResourceGroup(String resourceGroupName, String vaultName) {
        VaultInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, vaultName);
        if (inner != null) {
            return new VaultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String vaultName) {
        this.serviceClient().delete(resourceGroupName, vaultName);
    }

    @Override
    public void delete(String resourceGroupName, String vaultName, Context context) {
        this.serviceClient().delete(resourceGroupName, vaultName, context);
    }

    @Override
    public Vault getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String vaultName = ResourceManagerUtils.getValueFromIdByName(id, "vaults");
        if (vaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'vaults'.", id)));
        }
        return (Vault)this.getByResourceGroupWithResponse(resourceGroupName, vaultName, Context.NONE).getValue();
    }

    @Override
    public Response<Vault> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String vaultName = ResourceManagerUtils.getValueFromIdByName(id, "vaults");
        if (vaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'vaults'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, vaultName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String vaultName = ResourceManagerUtils.getValueFromIdByName(id, "vaults");
        if (vaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'vaults'.", id)));
        }
        this.delete(resourceGroupName, vaultName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String vaultName = ResourceManagerUtils.getValueFromIdByName(id, "vaults");
        if (vaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'vaults'.", id)));
        }
        this.delete(resourceGroupName, vaultName, context);
    }

    private VaultsClient serviceClient() {
        return this.innerClient;
    }

    private RecoveryServicesManager manager() {
        return this.serviceManager;
    }

    @Override
    public VaultImpl define(String name) {
        return new VaultImpl(name, this.manager());
    }
}

