/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redis.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.redis.fluent.LinkedServersClient;
import com.azure.resourcemanager.redis.fluent.models.RedisLinkedServerWithPropertiesInner;
import com.azure.resourcemanager.redis.implementation.RedisManagementClientImpl;
import com.azure.resourcemanager.redis.models.RedisLinkedServerCreateParameters;
import com.azure.resourcemanager.redis.models.RedisLinkedServerWithPropertiesList;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class LinkedServersClientImpl
implements LinkedServersClient {
    private final ClientLogger logger = new ClientLogger(LinkedServersClientImpl.class);
    private final LinkedServersService service;
    private final RedisManagementClientImpl client;

    LinkedServersClientImpl(RedisManagementClientImpl client) {
        this.service = (LinkedServersService)RestProxy.create(LinkedServersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String name, String linkedServerName, RedisLinkedServerCreateParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (linkedServerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter linkedServerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), resourceGroupName, name, linkedServerName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String name, String linkedServerName, RedisLinkedServerCreateParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (linkedServerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter linkedServerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), resourceGroupName, name, linkedServerName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, context);
    }

    @Override
    public PollerFlux<PollResult<RedisLinkedServerWithPropertiesInner>, RedisLinkedServerWithPropertiesInner> beginCreateAsync(String resourceGroupName, String name, String linkedServerName, RedisLinkedServerCreateParameters parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, name, linkedServerName, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)RedisLinkedServerWithPropertiesInner.class), (Type)((Object)RedisLinkedServerWithPropertiesInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<RedisLinkedServerWithPropertiesInner>, RedisLinkedServerWithPropertiesInner> beginCreateAsync(String resourceGroupName, String name, String linkedServerName, RedisLinkedServerCreateParameters parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, name, linkedServerName, parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)RedisLinkedServerWithPropertiesInner.class), (Type)((Object)RedisLinkedServerWithPropertiesInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<RedisLinkedServerWithPropertiesInner>, RedisLinkedServerWithPropertiesInner> beginCreate(String resourceGroupName, String name, String linkedServerName, RedisLinkedServerCreateParameters parameters) {
        return this.beginCreateAsync(resourceGroupName, name, linkedServerName, parameters).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<RedisLinkedServerWithPropertiesInner>, RedisLinkedServerWithPropertiesInner> beginCreate(String resourceGroupName, String name, String linkedServerName, RedisLinkedServerCreateParameters parameters, Context context) {
        return this.beginCreateAsync(resourceGroupName, name, linkedServerName, parameters, context).getSyncPoller();
    }

    @Override
    public Mono<RedisLinkedServerWithPropertiesInner> createAsync(String resourceGroupName, String name, String linkedServerName, RedisLinkedServerCreateParameters parameters) {
        return this.beginCreateAsync(resourceGroupName, name, linkedServerName, parameters).last().flatMap(arg_0 -> ((RedisManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<RedisLinkedServerWithPropertiesInner> createAsync(String resourceGroupName, String name, String linkedServerName, RedisLinkedServerCreateParameters parameters, Context context) {
        return this.beginCreateAsync(resourceGroupName, name, linkedServerName, parameters, context).last().flatMap(arg_0 -> ((RedisManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public RedisLinkedServerWithPropertiesInner create(String resourceGroupName, String name, String linkedServerName, RedisLinkedServerCreateParameters parameters) {
        return (RedisLinkedServerWithPropertiesInner)((Object)this.createAsync(resourceGroupName, name, linkedServerName, parameters).block());
    }

    @Override
    public RedisLinkedServerWithPropertiesInner create(String resourceGroupName, String name, String linkedServerName, RedisLinkedServerCreateParameters parameters, Context context) {
        return (RedisLinkedServerWithPropertiesInner)((Object)this.createAsync(resourceGroupName, name, linkedServerName, parameters, context).block());
    }

    @Override
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String name, String linkedServerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (linkedServerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter linkedServerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, name, linkedServerName, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String name, String linkedServerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (linkedServerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter linkedServerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, name, linkedServerName, this.client.getApiVersion(), this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<Void> deleteAsync(String resourceGroupName, String name, String linkedServerName) {
        return this.deleteWithResponseAsync(resourceGroupName, name, linkedServerName).flatMap(res -> Mono.empty());
    }

    @Override
    public void delete(String resourceGroupName, String name, String linkedServerName) {
        this.deleteAsync(resourceGroupName, name, linkedServerName).block();
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String name, String linkedServerName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, name, linkedServerName, context).block();
    }

    @Override
    public Mono<Response<RedisLinkedServerWithPropertiesInner>> getWithResponseAsync(String resourceGroupName, String name, String linkedServerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (linkedServerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter linkedServerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, name, linkedServerName, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<RedisLinkedServerWithPropertiesInner>> getWithResponseAsync(String resourceGroupName, String name, String linkedServerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (linkedServerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter linkedServerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, name, linkedServerName, this.client.getApiVersion(), this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<RedisLinkedServerWithPropertiesInner> getAsync(String resourceGroupName, String name, String linkedServerName) {
        return this.getWithResponseAsync(resourceGroupName, name, linkedServerName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((RedisLinkedServerWithPropertiesInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public RedisLinkedServerWithPropertiesInner get(String resourceGroupName, String name, String linkedServerName) {
        return (RedisLinkedServerWithPropertiesInner)((Object)this.getAsync(resourceGroupName, name, linkedServerName).block());
    }

    @Override
    public Response<RedisLinkedServerWithPropertiesInner> getWithResponse(String resourceGroupName, String name, String linkedServerName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, name, linkedServerName, context).block();
    }

    private Mono<PagedResponse<RedisLinkedServerWithPropertiesInner>> listSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceGroupName, name, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RedisLinkedServerWithPropertiesList)res.getValue()).value(), ((RedisLinkedServerWithPropertiesList)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<RedisLinkedServerWithPropertiesInner>> listSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceGroupName, name, this.client.getApiVersion(), this.client.getSubscriptionId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RedisLinkedServerWithPropertiesList)res.getValue()).value(), ((RedisLinkedServerWithPropertiesList)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<RedisLinkedServerWithPropertiesInner> listAsync(String resourceGroupName, String name) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, name), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<RedisLinkedServerWithPropertiesInner> listAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, name, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<RedisLinkedServerWithPropertiesInner> list(String resourceGroupName, String name) {
        return new PagedIterable(this.listAsync(resourceGroupName, name));
    }

    @Override
    public PagedIterable<RedisLinkedServerWithPropertiesInner> list(String resourceGroupName, String name, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, name, context));
    }

    private Mono<PagedResponse<RedisLinkedServerWithPropertiesInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RedisLinkedServerWithPropertiesList)res.getValue()).value(), ((RedisLinkedServerWithPropertiesList)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<RedisLinkedServerWithPropertiesInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RedisLinkedServerWithPropertiesList)res.getValue()).value(), ((RedisLinkedServerWithPropertiesList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="RedisManagementClien")
    private static interface LinkedServersService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/linkedServers/{linkedServerName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="linkedServerName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") RedisLinkedServerCreateParameters var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/linkedServers/{linkedServerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="linkedServerName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/linkedServers/{linkedServerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RedisLinkedServerWithPropertiesInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="linkedServerName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/linkedServers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RedisLinkedServerWithPropertiesList>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RedisLinkedServerWithPropertiesList>> listNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

