/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redis.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.redis.models.Sku;
import com.azure.resourcemanager.redis.models.TlsVersion;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class RedisCreateParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(RedisCreateParameters.class);
    @JsonProperty(value="zones")
    private List<String> zones;
    @JsonProperty(value="location", required=true)
    private String location;
    @JsonProperty(value="tags")
    private Map<String, String> tags;
    @JsonProperty(value="properties.redisConfiguration")
    private Map<String, String> redisConfiguration;
    @JsonProperty(value="properties.enableNonSslPort")
    private Boolean enableNonSslPort;
    @JsonProperty(value="properties.tenantSettings")
    private Map<String, String> tenantSettings;
    @JsonProperty(value="properties.shardCount")
    private Integer shardCount;
    @JsonProperty(value="properties.minimumTlsVersion")
    private TlsVersion minimumTlsVersion;
    @JsonProperty(value="properties.sku", required=true)
    private Sku sku;
    @JsonProperty(value="properties.subnetId")
    private String subnetId;
    @JsonProperty(value="properties.staticIP")
    private String staticIp;

    public List<String> zones() {
        return this.zones;
    }

    public RedisCreateParameters withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public String location() {
        return this.location;
    }

    public RedisCreateParameters withLocation(String location) {
        this.location = location;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public RedisCreateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Map<String, String> redisConfiguration() {
        return this.redisConfiguration;
    }

    public RedisCreateParameters withRedisConfiguration(Map<String, String> redisConfiguration) {
        this.redisConfiguration = redisConfiguration;
        return this;
    }

    public Boolean enableNonSslPort() {
        return this.enableNonSslPort;
    }

    public RedisCreateParameters withEnableNonSslPort(Boolean enableNonSslPort) {
        this.enableNonSslPort = enableNonSslPort;
        return this;
    }

    public Map<String, String> tenantSettings() {
        return this.tenantSettings;
    }

    public RedisCreateParameters withTenantSettings(Map<String, String> tenantSettings) {
        this.tenantSettings = tenantSettings;
        return this;
    }

    public Integer shardCount() {
        return this.shardCount;
    }

    public RedisCreateParameters withShardCount(Integer shardCount) {
        this.shardCount = shardCount;
        return this;
    }

    public TlsVersion minimumTlsVersion() {
        return this.minimumTlsVersion;
    }

    public RedisCreateParameters withMinimumTlsVersion(TlsVersion minimumTlsVersion) {
        this.minimumTlsVersion = minimumTlsVersion;
        return this;
    }

    public Sku sku() {
        return this.sku;
    }

    public RedisCreateParameters withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public RedisCreateParameters withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public String staticIp() {
        return this.staticIp;
    }

    public RedisCreateParameters withStaticIp(String staticIp) {
        this.staticIp = staticIp;
        return this;
    }

    public void validate() {
        if (this.location() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property location in model RedisCreateParameters"));
        }
        if (this.sku() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property sku in model RedisCreateParameters"));
        }
        this.sku().validate();
    }
}

