/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redis.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.redis.models.Sku;
import com.azure.resourcemanager.redis.models.TlsVersion;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

@JsonFlatten
public class RedisUpdateParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(RedisUpdateParameters.class);
    @JsonProperty(value="tags")
    private Map<String, String> tags;
    @JsonProperty(value="properties.redisConfiguration")
    private Map<String, String> redisConfiguration;
    @JsonProperty(value="properties.enableNonSslPort")
    private Boolean enableNonSslPort;
    @JsonProperty(value="properties.tenantSettings")
    private Map<String, String> tenantSettings;
    @JsonProperty(value="properties.shardCount")
    private Integer shardCount;
    @JsonProperty(value="properties.minimumTlsVersion")
    private TlsVersion minimumTlsVersion;
    @JsonProperty(value="properties.sku")
    private Sku sku;

    public Map<String, String> tags() {
        return this.tags;
    }

    public RedisUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Map<String, String> redisConfiguration() {
        return this.redisConfiguration;
    }

    public RedisUpdateParameters withRedisConfiguration(Map<String, String> redisConfiguration) {
        this.redisConfiguration = redisConfiguration;
        return this;
    }

    public Boolean enableNonSslPort() {
        return this.enableNonSslPort;
    }

    public RedisUpdateParameters withEnableNonSslPort(Boolean enableNonSslPort) {
        this.enableNonSslPort = enableNonSslPort;
        return this;
    }

    public Map<String, String> tenantSettings() {
        return this.tenantSettings;
    }

    public RedisUpdateParameters withTenantSettings(Map<String, String> tenantSettings) {
        this.tenantSettings = tenantSettings;
        return this;
    }

    public Integer shardCount() {
        return this.shardCount;
    }

    public RedisUpdateParameters withShardCount(Integer shardCount) {
        this.shardCount = shardCount;
        return this;
    }

    public TlsVersion minimumTlsVersion() {
        return this.minimumTlsVersion;
    }

    public RedisUpdateParameters withMinimumTlsVersion(TlsVersion minimumTlsVersion) {
        this.minimumTlsVersion = minimumTlsVersion;
        return this;
    }

    public Sku sku() {
        return this.sku;
    }

    public RedisUpdateParameters withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
    }
}

