// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.fluent.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Map;

/** Properties of upgrade notification. */
@Immutable
public final class UpgradeNotificationInner {
    /*
     * Name of upgrade notification.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * Timestamp when upgrade notification occurred.
     */
    @JsonProperty(value = "timestamp", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime timestamp;

    /*
     * Details about this upgrade notification
     */
    @JsonProperty(value = "upsellNotification", access = JsonProperty.Access.WRITE_ONLY)
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, String> upsellNotification;

    /**
     * Get the name property: Name of upgrade notification.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the timestamp property: Timestamp when upgrade notification occurred.
     *
     * @return the timestamp value.
     */
    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    /**
     * Get the upsellNotification property: Details about this upgrade notification.
     *
     * @return the upsellNotification value.
     */
    public Map<String, String> upsellNotification() {
        return this.upsellNotification;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
