// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Details of single instance of redis. */
@Immutable
public final class RedisInstanceDetails {
    /*
     * Redis instance SSL port.
     */
    @JsonProperty(value = "sslPort", access = JsonProperty.Access.WRITE_ONLY)
    private Integer sslPort;

    /*
     * If enableNonSslPort is true, provides Redis instance Non-SSL port.
     */
    @JsonProperty(value = "nonSslPort", access = JsonProperty.Access.WRITE_ONLY)
    private Integer nonSslPort;

    /*
     * If the Cache uses availability zones, specifies availability zone where
     * this instance is located.
     */
    @JsonProperty(value = "zone", access = JsonProperty.Access.WRITE_ONLY)
    private String zone;

    /*
     * If clustering is enabled, the Shard ID of Redis Instance
     */
    @JsonProperty(value = "shardId", access = JsonProperty.Access.WRITE_ONLY)
    private Integer shardId;

    /*
     * Specifies whether the instance is a primary node.
     */
    @JsonProperty(value = "isMaster", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean isMaster;

    /*
     * Specifies whether the instance is a primary node.
     */
    @JsonProperty(value = "isPrimary", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean isPrimary;

    /**
     * Get the sslPort property: Redis instance SSL port.
     *
     * @return the sslPort value.
     */
    public Integer sslPort() {
        return this.sslPort;
    }

    /**
     * Get the nonSslPort property: If enableNonSslPort is true, provides Redis instance Non-SSL port.
     *
     * @return the nonSslPort value.
     */
    public Integer nonSslPort() {
        return this.nonSslPort;
    }

    /**
     * Get the zone property: If the Cache uses availability zones, specifies availability zone where this instance is
     * located.
     *
     * @return the zone value.
     */
    public String zone() {
        return this.zone;
    }

    /**
     * Get the shardId property: If clustering is enabled, the Shard ID of Redis Instance.
     *
     * @return the shardId value.
     */
    public Integer shardId() {
        return this.shardId;
    }

    /**
     * Get the isMaster property: Specifies whether the instance is a primary node.
     *
     * @return the isMaster value.
     */
    public Boolean isMaster() {
        return this.isMaster;
    }

    /**
     * Get the isPrimary property: Specifies whether the instance is a primary node.
     *
     * @return the isPrimary value.
     */
    public Boolean isPrimary() {
        return this.isPrimary;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
