// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.redis.models.ErrorDetail;
import com.azure.resourcemanager.redis.models.OperationStatusResult;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

/** Asynchronous operation status. */
@Fluent
public final class OperationStatusInner extends OperationStatusResult {
    /*
     * Additional properties from RP, only when operation is successful
     */
    @JsonProperty(value = "properties")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, Object> properties;

    /** Creates an instance of OperationStatusInner class. */
    public OperationStatusInner() {
    }

    /**
     * Get the properties property: Additional properties from RP, only when operation is successful.
     *
     * @return the properties value.
     */
    public Map<String, Object> properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Additional properties from RP, only when operation is successful.
     *
     * @param properties the properties value to set.
     * @return the OperationStatusInner object itself.
     */
    public OperationStatusInner withProperties(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public OperationStatusInner withId(String id) {
        super.withId(id);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public OperationStatusInner withName(String name) {
        super.withName(name);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public OperationStatusInner withStatus(String status) {
        super.withStatus(status);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public OperationStatusInner withPercentComplete(Float percentComplete) {
        super.withPercentComplete(percentComplete);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public OperationStatusInner withStartTime(OffsetDateTime startTime) {
        super.withStartTime(startTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public OperationStatusInner withEndTime(OffsetDateTime endTime) {
        super.withEndTime(endTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public OperationStatusInner withOperations(List<OperationStatusResult> operations) {
        super.withOperations(operations);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public OperationStatusInner withError(ErrorDetail error) {
        super.withError(error);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
