// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/**
 * All Redis Settings. Few possible keys:
 * rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value
 * etc.
 */
@Fluent
public final class RedisConfiguration {
    /*
     * Specifies whether the rdb backup is enabled
     */
    @JsonProperty(value = "rdb-backup-enabled")
    private String rdbBackupEnabled;

    /*
     * Specifies the frequency for creating rdb backup in minutes. Valid values: (15, 30, 60, 360, 720, 1440)
     */
    @JsonProperty(value = "rdb-backup-frequency")
    private String rdbBackupFrequency;

    /*
     * Specifies the maximum number of snapshots for rdb backup
     */
    @JsonProperty(value = "rdb-backup-max-snapshot-count")
    private String rdbBackupMaxSnapshotCount;

    /*
     * The storage account connection string for storing rdb file
     */
    @JsonProperty(value = "rdb-storage-connection-string")
    private String rdbStorageConnectionString;

    /*
     * Specifies whether the aof backup is enabled
     */
    @JsonProperty(value = "aof-backup-enabled")
    private String aofBackupEnabled;

    /*
     * First storage account connection string
     */
    @JsonProperty(value = "aof-storage-connection-string-0")
    private String aofStorageConnectionString0;

    /*
     * Second storage account connection string
     */
    @JsonProperty(value = "aof-storage-connection-string-1")
    private String aofStorageConnectionString1;

    /*
     * Value in megabytes reserved for fragmentation per shard
     */
    @JsonProperty(value = "maxfragmentationmemory-reserved")
    private String maxfragmentationmemoryReserved;

    /*
     * The eviction strategy used when your data won't fit within its memory limit.
     */
    @JsonProperty(value = "maxmemory-policy")
    private String maxmemoryPolicy;

    /*
     * Value in megabytes reserved for non-cache usage per shard e.g. failover.
     */
    @JsonProperty(value = "maxmemory-reserved")
    private String maxmemoryReserved;

    /*
     * Value in megabytes reserved for non-cache usage per shard e.g. failover.
     */
    @JsonProperty(value = "maxmemory-delta")
    private String maxmemoryDelta;

    /*
     * The max clients config
     */
    @JsonProperty(value = "maxclients", access = JsonProperty.Access.WRITE_ONLY)
    private String maxclients;

    /*
     * Preferred auth method to communicate to storage account used for data archive, specify SAS or ManagedIdentity,
     * default value is SAS
     */
    @JsonProperty(value = "preferred-data-archive-auth-method", access = JsonProperty.Access.WRITE_ONLY)
    private String preferredDataArchiveAuthMethod;

    /*
     * Preferred auth method to communicate to storage account used for data persistence, specify SAS or
     * ManagedIdentity, default value is SAS
     */
    @JsonProperty(value = "preferred-data-persistence-auth-method")
    private String preferredDataPersistenceAuthMethod;

    /*
     * Zonal Configuration
     */
    @JsonProperty(value = "zonal-configuration", access = JsonProperty.Access.WRITE_ONLY)
    private String zonalConfiguration;

    /*
     * Specifies whether the authentication is disabled. Setting this property is highly discouraged from security
     * point of view.
     */
    @JsonProperty(value = "authnotrequired")
    private String authnotrequired;

    /*
     * SubscriptionId of the storage account for persistence (aof/rdb) using ManagedIdentity.
     */
    @JsonProperty(value = "storage-subscription-id")
    private String storageSubscriptionId;

    /*
     * All Redis Settings. Few possible keys:
     * rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value
     * etc.
     */
    @JsonIgnore private Map<String, String> additionalProperties;

    /** Creates an instance of RedisConfiguration class. */
    public RedisConfiguration() {
    }

    /**
     * Get the rdbBackupEnabled property: Specifies whether the rdb backup is enabled.
     *
     * @return the rdbBackupEnabled value.
     */
    public String rdbBackupEnabled() {
        return this.rdbBackupEnabled;
    }

    /**
     * Set the rdbBackupEnabled property: Specifies whether the rdb backup is enabled.
     *
     * @param rdbBackupEnabled the rdbBackupEnabled value to set.
     * @return the RedisConfiguration object itself.
     */
    public RedisConfiguration withRdbBackupEnabled(String rdbBackupEnabled) {
        this.rdbBackupEnabled = rdbBackupEnabled;
        return this;
    }

    /**
     * Get the rdbBackupFrequency property: Specifies the frequency for creating rdb backup in minutes. Valid values:
     * (15, 30, 60, 360, 720, 1440).
     *
     * @return the rdbBackupFrequency value.
     */
    public String rdbBackupFrequency() {
        return this.rdbBackupFrequency;
    }

    /**
     * Set the rdbBackupFrequency property: Specifies the frequency for creating rdb backup in minutes. Valid values:
     * (15, 30, 60, 360, 720, 1440).
     *
     * @param rdbBackupFrequency the rdbBackupFrequency value to set.
     * @return the RedisConfiguration object itself.
     */
    public RedisConfiguration withRdbBackupFrequency(String rdbBackupFrequency) {
        this.rdbBackupFrequency = rdbBackupFrequency;
        return this;
    }

    /**
     * Get the rdbBackupMaxSnapshotCount property: Specifies the maximum number of snapshots for rdb backup.
     *
     * @return the rdbBackupMaxSnapshotCount value.
     */
    public String rdbBackupMaxSnapshotCount() {
        return this.rdbBackupMaxSnapshotCount;
    }

    /**
     * Set the rdbBackupMaxSnapshotCount property: Specifies the maximum number of snapshots for rdb backup.
     *
     * @param rdbBackupMaxSnapshotCount the rdbBackupMaxSnapshotCount value to set.
     * @return the RedisConfiguration object itself.
     */
    public RedisConfiguration withRdbBackupMaxSnapshotCount(String rdbBackupMaxSnapshotCount) {
        this.rdbBackupMaxSnapshotCount = rdbBackupMaxSnapshotCount;
        return this;
    }

    /**
     * Get the rdbStorageConnectionString property: The storage account connection string for storing rdb file.
     *
     * @return the rdbStorageConnectionString value.
     */
    public String rdbStorageConnectionString() {
        return this.rdbStorageConnectionString;
    }

    /**
     * Set the rdbStorageConnectionString property: The storage account connection string for storing rdb file.
     *
     * @param rdbStorageConnectionString the rdbStorageConnectionString value to set.
     * @return the RedisConfiguration object itself.
     */
    public RedisConfiguration withRdbStorageConnectionString(String rdbStorageConnectionString) {
        this.rdbStorageConnectionString = rdbStorageConnectionString;
        return this;
    }

    /**
     * Get the aofBackupEnabled property: Specifies whether the aof backup is enabled.
     *
     * @return the aofBackupEnabled value.
     */
    public String aofBackupEnabled() {
        return this.aofBackupEnabled;
    }

    /**
     * Set the aofBackupEnabled property: Specifies whether the aof backup is enabled.
     *
     * @param aofBackupEnabled the aofBackupEnabled value to set.
     * @return the RedisConfiguration object itself.
     */
    public RedisConfiguration withAofBackupEnabled(String aofBackupEnabled) {
        this.aofBackupEnabled = aofBackupEnabled;
        return this;
    }

    /**
     * Get the aofStorageConnectionString0 property: First storage account connection string.
     *
     * @return the aofStorageConnectionString0 value.
     */
    public String aofStorageConnectionString0() {
        return this.aofStorageConnectionString0;
    }

    /**
     * Set the aofStorageConnectionString0 property: First storage account connection string.
     *
     * @param aofStorageConnectionString0 the aofStorageConnectionString0 value to set.
     * @return the RedisConfiguration object itself.
     */
    public RedisConfiguration withAofStorageConnectionString0(String aofStorageConnectionString0) {
        this.aofStorageConnectionString0 = aofStorageConnectionString0;
        return this;
    }

    /**
     * Get the aofStorageConnectionString1 property: Second storage account connection string.
     *
     * @return the aofStorageConnectionString1 value.
     */
    public String aofStorageConnectionString1() {
        return this.aofStorageConnectionString1;
    }

    /**
     * Set the aofStorageConnectionString1 property: Second storage account connection string.
     *
     * @param aofStorageConnectionString1 the aofStorageConnectionString1 value to set.
     * @return the RedisConfiguration object itself.
     */
    public RedisConfiguration withAofStorageConnectionString1(String aofStorageConnectionString1) {
        this.aofStorageConnectionString1 = aofStorageConnectionString1;
        return this;
    }

    /**
     * Get the maxfragmentationmemoryReserved property: Value in megabytes reserved for fragmentation per shard.
     *
     * @return the maxfragmentationmemoryReserved value.
     */
    public String maxfragmentationmemoryReserved() {
        return this.maxfragmentationmemoryReserved;
    }

    /**
     * Set the maxfragmentationmemoryReserved property: Value in megabytes reserved for fragmentation per shard.
     *
     * @param maxfragmentationmemoryReserved the maxfragmentationmemoryReserved value to set.
     * @return the RedisConfiguration object itself.
     */
    public RedisConfiguration withMaxfragmentationmemoryReserved(String maxfragmentationmemoryReserved) {
        this.maxfragmentationmemoryReserved = maxfragmentationmemoryReserved;
        return this;
    }

    /**
     * Get the maxmemoryPolicy property: The eviction strategy used when your data won't fit within its memory limit.
     *
     * @return the maxmemoryPolicy value.
     */
    public String maxmemoryPolicy() {
        return this.maxmemoryPolicy;
    }

    /**
     * Set the maxmemoryPolicy property: The eviction strategy used when your data won't fit within its memory limit.
     *
     * @param maxmemoryPolicy the maxmemoryPolicy value to set.
     * @return the RedisConfiguration object itself.
     */
    public RedisConfiguration withMaxmemoryPolicy(String maxmemoryPolicy) {
        this.maxmemoryPolicy = maxmemoryPolicy;
        return this;
    }

    /**
     * Get the maxmemoryReserved property: Value in megabytes reserved for non-cache usage per shard e.g. failover.
     *
     * @return the maxmemoryReserved value.
     */
    public String maxmemoryReserved() {
        return this.maxmemoryReserved;
    }

    /**
     * Set the maxmemoryReserved property: Value in megabytes reserved for non-cache usage per shard e.g. failover.
     *
     * @param maxmemoryReserved the maxmemoryReserved value to set.
     * @return the RedisConfiguration object itself.
     */
    public RedisConfiguration withMaxmemoryReserved(String maxmemoryReserved) {
        this.maxmemoryReserved = maxmemoryReserved;
        return this;
    }

    /**
     * Get the maxmemoryDelta property: Value in megabytes reserved for non-cache usage per shard e.g. failover.
     *
     * @return the maxmemoryDelta value.
     */
    public String maxmemoryDelta() {
        return this.maxmemoryDelta;
    }

    /**
     * Set the maxmemoryDelta property: Value in megabytes reserved for non-cache usage per shard e.g. failover.
     *
     * @param maxmemoryDelta the maxmemoryDelta value to set.
     * @return the RedisConfiguration object itself.
     */
    public RedisConfiguration withMaxmemoryDelta(String maxmemoryDelta) {
        this.maxmemoryDelta = maxmemoryDelta;
        return this;
    }

    /**
     * Get the maxclients property: The max clients config.
     *
     * @return the maxclients value.
     */
    public String maxclients() {
        return this.maxclients;
    }

    /**
     * Get the preferredDataArchiveAuthMethod property: Preferred auth method to communicate to storage account used for
     * data archive, specify SAS or ManagedIdentity, default value is SAS.
     *
     * @return the preferredDataArchiveAuthMethod value.
     */
    public String preferredDataArchiveAuthMethod() {
        return this.preferredDataArchiveAuthMethod;
    }

    /**
     * Get the preferredDataPersistenceAuthMethod property: Preferred auth method to communicate to storage account used
     * for data persistence, specify SAS or ManagedIdentity, default value is SAS.
     *
     * @return the preferredDataPersistenceAuthMethod value.
     */
    public String preferredDataPersistenceAuthMethod() {
        return this.preferredDataPersistenceAuthMethod;
    }

    /**
     * Set the preferredDataPersistenceAuthMethod property: Preferred auth method to communicate to storage account used
     * for data persistence, specify SAS or ManagedIdentity, default value is SAS.
     *
     * @param preferredDataPersistenceAuthMethod the preferredDataPersistenceAuthMethod value to set.
     * @return the RedisConfiguration object itself.
     */
    public RedisConfiguration withPreferredDataPersistenceAuthMethod(String preferredDataPersistenceAuthMethod) {
        this.preferredDataPersistenceAuthMethod = preferredDataPersistenceAuthMethod;
        return this;
    }

    /**
     * Get the zonalConfiguration property: Zonal Configuration.
     *
     * @return the zonalConfiguration value.
     */
    public String zonalConfiguration() {
        return this.zonalConfiguration;
    }

    /**
     * Get the authnotrequired property: Specifies whether the authentication is disabled. Setting this property is
     * highly discouraged from security point of view.
     *
     * @return the authnotrequired value.
     */
    public String authnotrequired() {
        return this.authnotrequired;
    }

    /**
     * Set the authnotrequired property: Specifies whether the authentication is disabled. Setting this property is
     * highly discouraged from security point of view.
     *
     * @param authnotrequired the authnotrequired value to set.
     * @return the RedisConfiguration object itself.
     */
    public RedisConfiguration withAuthnotrequired(String authnotrequired) {
        this.authnotrequired = authnotrequired;
        return this;
    }

    /**
     * Get the storageSubscriptionId property: SubscriptionId of the storage account for persistence (aof/rdb) using
     * ManagedIdentity.
     *
     * @return the storageSubscriptionId value.
     */
    public String storageSubscriptionId() {
        return this.storageSubscriptionId;
    }

    /**
     * Set the storageSubscriptionId property: SubscriptionId of the storage account for persistence (aof/rdb) using
     * ManagedIdentity.
     *
     * @param storageSubscriptionId the storageSubscriptionId value to set.
     * @return the RedisConfiguration object itself.
     */
    public RedisConfiguration withStorageSubscriptionId(String storageSubscriptionId) {
        this.storageSubscriptionId = storageSubscriptionId;
        return this;
    }

    /**
     * Get the additionalProperties property: All Redis Settings. Few possible keys:
     * rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value
     * etc.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, String> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: All Redis Settings. Few possible keys:
     * rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value
     * etc.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the RedisConfiguration object itself.
     */
    public RedisConfiguration withAdditionalProperties(Map<String, String> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, String value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
