/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redis.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.redis.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.redis.fluent.models.RedisAccessKeysInner;
import com.azure.resourcemanager.redis.models.ProvisioningState;
import com.azure.resourcemanager.redis.models.PublicNetworkAccess;
import com.azure.resourcemanager.redis.models.RedisInstanceDetails;
import com.azure.resourcemanager.redis.models.RedisLinkedServer;
import com.azure.resourcemanager.redis.models.Sku;
import com.azure.resourcemanager.redis.models.TlsVersion;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class RedisResourceInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(RedisResourceInner.class);
    @JsonProperty(value="zones")
    private List<String> zones;
    @JsonProperty(value="properties.redisConfiguration")
    private Map<String, String> redisConfiguration;
    @JsonProperty(value="properties.enableNonSslPort")
    private Boolean enableNonSslPort;
    @JsonProperty(value="properties.replicasPerMaster")
    private Integer replicasPerMaster;
    @JsonProperty(value="properties.tenantSettings")
    private Map<String, String> tenantSettings;
    @JsonProperty(value="properties.shardCount")
    private Integer shardCount;
    @JsonProperty(value="properties.minimumTlsVersion")
    private TlsVersion minimumTlsVersion;
    @JsonProperty(value="properties.publicNetworkAccess")
    private PublicNetworkAccess publicNetworkAccess;
    @JsonProperty(value="properties.sku", required=true)
    private Sku sku;
    @JsonProperty(value="properties.subnetId")
    private String subnetId;
    @JsonProperty(value="properties.staticIP")
    private String staticIp;
    @JsonProperty(value="properties.redisVersion", access=JsonProperty.Access.WRITE_ONLY)
    private String redisVersion;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.hostName", access=JsonProperty.Access.WRITE_ONLY)
    private String hostname;
    @JsonProperty(value="properties.port", access=JsonProperty.Access.WRITE_ONLY)
    private Integer port;
    @JsonProperty(value="properties.sslPort", access=JsonProperty.Access.WRITE_ONLY)
    private Integer sslPort;
    @JsonProperty(value="properties.accessKeys", access=JsonProperty.Access.WRITE_ONLY)
    private RedisAccessKeysInner accessKeys;
    @JsonProperty(value="properties.linkedServers", access=JsonProperty.Access.WRITE_ONLY)
    private List<RedisLinkedServer> linkedServers;
    @JsonProperty(value="properties.instances", access=JsonProperty.Access.WRITE_ONLY)
    private List<RedisInstanceDetails> instances;
    @JsonProperty(value="properties.privateEndpointConnections", access=JsonProperty.Access.WRITE_ONLY)
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;

    public List<String> zones() {
        return this.zones;
    }

    public RedisResourceInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public Map<String, String> redisConfiguration() {
        return this.redisConfiguration;
    }

    public RedisResourceInner withRedisConfiguration(Map<String, String> redisConfiguration) {
        this.redisConfiguration = redisConfiguration;
        return this;
    }

    public Boolean enableNonSslPort() {
        return this.enableNonSslPort;
    }

    public RedisResourceInner withEnableNonSslPort(Boolean enableNonSslPort) {
        this.enableNonSslPort = enableNonSslPort;
        return this;
    }

    public Integer replicasPerMaster() {
        return this.replicasPerMaster;
    }

    public RedisResourceInner withReplicasPerMaster(Integer replicasPerMaster) {
        this.replicasPerMaster = replicasPerMaster;
        return this;
    }

    public Map<String, String> tenantSettings() {
        return this.tenantSettings;
    }

    public RedisResourceInner withTenantSettings(Map<String, String> tenantSettings) {
        this.tenantSettings = tenantSettings;
        return this;
    }

    public Integer shardCount() {
        return this.shardCount;
    }

    public RedisResourceInner withShardCount(Integer shardCount) {
        this.shardCount = shardCount;
        return this;
    }

    public TlsVersion minimumTlsVersion() {
        return this.minimumTlsVersion;
    }

    public RedisResourceInner withMinimumTlsVersion(TlsVersion minimumTlsVersion) {
        this.minimumTlsVersion = minimumTlsVersion;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public RedisResourceInner withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public Sku sku() {
        return this.sku;
    }

    public RedisResourceInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public RedisResourceInner withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public String staticIp() {
        return this.staticIp;
    }

    public RedisResourceInner withStaticIp(String staticIp) {
        this.staticIp = staticIp;
        return this;
    }

    public String redisVersion() {
        return this.redisVersion;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String hostname() {
        return this.hostname;
    }

    public Integer port() {
        return this.port;
    }

    public Integer sslPort() {
        return this.sslPort;
    }

    public RedisAccessKeysInner accessKeys() {
        return this.accessKeys;
    }

    public List<RedisLinkedServer> linkedServers() {
        return this.linkedServers;
    }

    public List<RedisInstanceDetails> instances() {
        return this.instances;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public RedisResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public RedisResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.sku() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property sku in model RedisResourceInner"));
        }
        this.sku().validate();
        if (this.accessKeys() != null) {
            this.accessKeys().validate();
        }
        if (this.linkedServers() != null) {
            this.linkedServers().forEach(e -> e.validate());
        }
        if (this.instances() != null) {
            this.instances().forEach(e -> e.validate());
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
    }
}

