/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redis.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.redis.models.PublicNetworkAccess;
import com.azure.resourcemanager.redis.models.RedisCommonProperties;
import com.azure.resourcemanager.redis.models.RedisConfiguration;
import com.azure.resourcemanager.redis.models.Sku;
import com.azure.resourcemanager.redis.models.TlsVersion;
import com.azure.resourcemanager.redis.models.UpdateChannel;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public class RedisCreateProperties
extends RedisCommonProperties {
    @JsonProperty(value="sku", required=true)
    private Sku sku;
    @JsonProperty(value="subnetId")
    private String subnetId;
    @JsonProperty(value="staticIP")
    private String staticIp;
    private static final ClientLogger LOGGER = new ClientLogger(RedisCreateProperties.class);

    public Sku sku() {
        return this.sku;
    }

    public RedisCreateProperties withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public RedisCreateProperties withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public String staticIp() {
        return this.staticIp;
    }

    public RedisCreateProperties withStaticIp(String staticIp) {
        this.staticIp = staticIp;
        return this;
    }

    @Override
    public RedisCreateProperties withRedisConfiguration(RedisConfiguration redisConfiguration) {
        super.withRedisConfiguration(redisConfiguration);
        return this;
    }

    @Override
    public RedisCreateProperties withRedisVersion(String redisVersion) {
        super.withRedisVersion(redisVersion);
        return this;
    }

    @Override
    public RedisCreateProperties withEnableNonSslPort(Boolean enableNonSslPort) {
        super.withEnableNonSslPort(enableNonSslPort);
        return this;
    }

    @Override
    public RedisCreateProperties withReplicasPerMaster(Integer replicasPerMaster) {
        super.withReplicasPerMaster(replicasPerMaster);
        return this;
    }

    @Override
    public RedisCreateProperties withReplicasPerPrimary(Integer replicasPerPrimary) {
        super.withReplicasPerPrimary(replicasPerPrimary);
        return this;
    }

    @Override
    public RedisCreateProperties withTenantSettings(Map<String, String> tenantSettings) {
        super.withTenantSettings(tenantSettings);
        return this;
    }

    @Override
    public RedisCreateProperties withShardCount(Integer shardCount) {
        super.withShardCount(shardCount);
        return this;
    }

    @Override
    public RedisCreateProperties withMinimumTlsVersion(TlsVersion minimumTlsVersion) {
        super.withMinimumTlsVersion(minimumTlsVersion);
        return this;
    }

    @Override
    public RedisCreateProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        super.withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    @Override
    public RedisCreateProperties withUpdateChannel(UpdateChannel updateChannel) {
        super.withUpdateChannel(updateChannel);
        return this;
    }

    @Override
    public RedisCreateProperties withDisableAccessKeyAuthentication(Boolean disableAccessKeyAuthentication) {
        super.withDisableAccessKeyAuthentication(disableAccessKeyAuthentication);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.sku() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sku in model RedisCreateProperties"));
        }
        this.sku().validate();
    }
}

