/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redis.fluent.models;

import com.azure.resourcemanager.redis.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.redis.fluent.models.RedisAccessKeysInner;
import com.azure.resourcemanager.redis.fluent.models.RedisCreateProperties;
import com.azure.resourcemanager.redis.models.ProvisioningState;
import com.azure.resourcemanager.redis.models.PublicNetworkAccess;
import com.azure.resourcemanager.redis.models.RedisConfiguration;
import com.azure.resourcemanager.redis.models.RedisInstanceDetails;
import com.azure.resourcemanager.redis.models.RedisLinkedServer;
import com.azure.resourcemanager.redis.models.Sku;
import com.azure.resourcemanager.redis.models.TlsVersion;
import com.azure.resourcemanager.redis.models.UpdateChannel;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class RedisPropertiesInner
extends RedisCreateProperties {
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="hostName", access=JsonProperty.Access.WRITE_ONLY)
    private String hostname;
    @JsonProperty(value="port", access=JsonProperty.Access.WRITE_ONLY)
    private Integer port;
    @JsonProperty(value="sslPort", access=JsonProperty.Access.WRITE_ONLY)
    private Integer sslPort;
    @JsonProperty(value="accessKeys", access=JsonProperty.Access.WRITE_ONLY)
    private RedisAccessKeysInner accessKeys;
    @JsonProperty(value="linkedServers", access=JsonProperty.Access.WRITE_ONLY)
    private List<RedisLinkedServer> linkedServers;
    @JsonProperty(value="instances", access=JsonProperty.Access.WRITE_ONLY)
    private List<RedisInstanceDetails> instances;
    @JsonProperty(value="privateEndpointConnections", access=JsonProperty.Access.WRITE_ONLY)
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String hostname() {
        return this.hostname;
    }

    public Integer port() {
        return this.port;
    }

    public Integer sslPort() {
        return this.sslPort;
    }

    public RedisAccessKeysInner accessKeys() {
        return this.accessKeys;
    }

    public List<RedisLinkedServer> linkedServers() {
        return this.linkedServers;
    }

    public List<RedisInstanceDetails> instances() {
        return this.instances;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    @Override
    public RedisPropertiesInner withSku(Sku sku) {
        super.withSku(sku);
        return this;
    }

    @Override
    public RedisPropertiesInner withSubnetId(String subnetId) {
        super.withSubnetId(subnetId);
        return this;
    }

    @Override
    public RedisPropertiesInner withStaticIp(String staticIp) {
        super.withStaticIp(staticIp);
        return this;
    }

    @Override
    public RedisPropertiesInner withRedisConfiguration(RedisConfiguration redisConfiguration) {
        super.withRedisConfiguration(redisConfiguration);
        return this;
    }

    @Override
    public RedisPropertiesInner withRedisVersion(String redisVersion) {
        super.withRedisVersion(redisVersion);
        return this;
    }

    @Override
    public RedisPropertiesInner withEnableNonSslPort(Boolean enableNonSslPort) {
        super.withEnableNonSslPort(enableNonSslPort);
        return this;
    }

    @Override
    public RedisPropertiesInner withReplicasPerMaster(Integer replicasPerMaster) {
        super.withReplicasPerMaster(replicasPerMaster);
        return this;
    }

    @Override
    public RedisPropertiesInner withReplicasPerPrimary(Integer replicasPerPrimary) {
        super.withReplicasPerPrimary(replicasPerPrimary);
        return this;
    }

    @Override
    public RedisPropertiesInner withTenantSettings(Map<String, String> tenantSettings) {
        super.withTenantSettings((Map)tenantSettings);
        return this;
    }

    @Override
    public RedisPropertiesInner withShardCount(Integer shardCount) {
        super.withShardCount(shardCount);
        return this;
    }

    @Override
    public RedisPropertiesInner withMinimumTlsVersion(TlsVersion minimumTlsVersion) {
        super.withMinimumTlsVersion(minimumTlsVersion);
        return this;
    }

    @Override
    public RedisPropertiesInner withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        super.withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    @Override
    public RedisPropertiesInner withUpdateChannel(UpdateChannel updateChannel) {
        super.withUpdateChannel(updateChannel);
        return this;
    }

    @Override
    public RedisPropertiesInner withDisableAccessKeyAuthentication(Boolean disableAccessKeyAuthentication) {
        super.withDisableAccessKeyAuthentication(disableAccessKeyAuthentication);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.accessKeys() != null) {
            this.accessKeys().validate();
        }
        if (this.linkedServers() != null) {
            this.linkedServers().forEach(e -> e.validate());
        }
        if (this.instances() != null) {
            this.instances().forEach(e -> e.validate());
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
    }
}

