// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.redis.models.ManagedServiceIdentity;
import com.azure.resourcemanager.redis.models.ProvisioningState;
import com.azure.resourcemanager.redis.models.PublicNetworkAccess;
import com.azure.resourcemanager.redis.models.RedisConfiguration;
import com.azure.resourcemanager.redis.models.RedisInstanceDetails;
import com.azure.resourcemanager.redis.models.RedisLinkedServer;
import com.azure.resourcemanager.redis.models.Sku;
import com.azure.resourcemanager.redis.models.TlsVersion;
import com.azure.resourcemanager.redis.models.UpdateChannel;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * A single Redis item in List or Get Operation.
 */
@Fluent
public final class RedisResourceInner extends Resource {
    /*
     * Redis cache properties.
     */
    private RedisPropertiesInner innerProperties = new RedisPropertiesInner();

    /*
     * A list of availability zones denoting where the resource needs to come from.
     */
    private List<String> zones;

    /*
     * The identity of the resource.
     */
    private ManagedServiceIdentity identity;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of RedisResourceInner class.
     */
    public RedisResourceInner() {
    }

    /**
     * Get the innerProperties property: Redis cache properties.
     * 
     * @return the innerProperties value.
     */
    private RedisPropertiesInner innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the zones property: A list of availability zones denoting where the resource needs to come from.
     * 
     * @return the zones value.
     */
    public List<String> zones() {
        return this.zones;
    }

    /**
     * Set the zones property: A list of availability zones denoting where the resource needs to come from.
     * 
     * @param zones the zones value to set.
     * @return the RedisResourceInner object itself.
     */
    public RedisResourceInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    /**
     * Get the identity property: The identity of the resource.
     * 
     * @return the identity value.
     */
    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    /**
     * Set the identity property: The identity of the resource.
     * 
     * @param identity the identity value to set.
     * @return the RedisResourceInner object itself.
     */
    public RedisResourceInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RedisResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RedisResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the provisioningState property: Redis instance provisioning status.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the hostname property: Redis host name.
     * 
     * @return the hostname value.
     */
    public String hostname() {
        return this.innerProperties() == null ? null : this.innerProperties().hostname();
    }

    /**
     * Get the port property: Redis non-SSL port.
     * 
     * @return the port value.
     */
    public Integer port() {
        return this.innerProperties() == null ? null : this.innerProperties().port();
    }

    /**
     * Get the sslPort property: Redis SSL port.
     * 
     * @return the sslPort value.
     */
    public Integer sslPort() {
        return this.innerProperties() == null ? null : this.innerProperties().sslPort();
    }

    /**
     * Get the accessKeys property: The keys of the Redis cache - not set if this object is not the response to Create
     * or Update redis cache.
     * 
     * @return the accessKeys value.
     */
    public RedisAccessKeysInner accessKeys() {
        return this.innerProperties() == null ? null : this.innerProperties().accessKeys();
    }

    /**
     * Get the linkedServers property: List of the linked servers associated with the cache.
     * 
     * @return the linkedServers value.
     */
    public List<RedisLinkedServer> linkedServers() {
        return this.innerProperties() == null ? null : this.innerProperties().linkedServers();
    }

    /**
     * Get the instances property: List of the Redis instances associated with the cache.
     * 
     * @return the instances value.
     */
    public List<RedisInstanceDetails> instances() {
        return this.innerProperties() == null ? null : this.innerProperties().instances();
    }

    /**
     * Get the privateEndpointConnections property: List of private endpoint connection associated with the specified
     * redis cache.
     * 
     * @return the privateEndpointConnections value.
     */
    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    /**
     * Get the sku property: The SKU of the Redis cache to deploy.
     * 
     * @return the sku value.
     */
    public Sku sku() {
        return this.innerProperties() == null ? null : this.innerProperties().sku();
    }

    /**
     * Set the sku property: The SKU of the Redis cache to deploy.
     * 
     * @param sku the sku value to set.
     * @return the RedisResourceInner object itself.
     */
    public RedisResourceInner withSku(Sku sku) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withSku(sku);
        return this;
    }

    /**
     * Get the subnetId property: The full resource ID of a subnet in a virtual network to deploy the Redis cache in.
     * Example format:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1.
     * 
     * @return the subnetId value.
     */
    public String subnetId() {
        return this.innerProperties() == null ? null : this.innerProperties().subnetId();
    }

    /**
     * Set the subnetId property: The full resource ID of a subnet in a virtual network to deploy the Redis cache in.
     * Example format:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1.
     * 
     * @param subnetId the subnetId value to set.
     * @return the RedisResourceInner object itself.
     */
    public RedisResourceInner withSubnetId(String subnetId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withSubnetId(subnetId);
        return this;
    }

    /**
     * Get the staticIp property: Static IP address. Optionally, may be specified when deploying a Redis cache inside an
     * existing Azure Virtual Network; auto assigned by default.
     * 
     * @return the staticIp value.
     */
    public String staticIp() {
        return this.innerProperties() == null ? null : this.innerProperties().staticIp();
    }

    /**
     * Set the staticIp property: Static IP address. Optionally, may be specified when deploying a Redis cache inside an
     * existing Azure Virtual Network; auto assigned by default.
     * 
     * @param staticIp the staticIp value to set.
     * @return the RedisResourceInner object itself.
     */
    public RedisResourceInner withStaticIp(String staticIp) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withStaticIp(staticIp);
        return this;
    }

    /**
     * Get the redisConfiguration property: All Redis Settings. Few possible keys:
     * rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,
     * maxmemory-policy,notify-keyspace-events, aof-backup-enabled, aof-storage-connection-string-0,
     * aof-storage-connection-string-1 etc.
     * 
     * @return the redisConfiguration value.
     */
    public RedisConfiguration redisConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().redisConfiguration();
    }

    /**
     * Set the redisConfiguration property: All Redis Settings. Few possible keys:
     * rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,
     * maxmemory-policy,notify-keyspace-events, aof-backup-enabled, aof-storage-connection-string-0,
     * aof-storage-connection-string-1 etc.
     * 
     * @param redisConfiguration the redisConfiguration value to set.
     * @return the RedisResourceInner object itself.
     */
    public RedisResourceInner withRedisConfiguration(RedisConfiguration redisConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withRedisConfiguration(redisConfiguration);
        return this;
    }

    /**
     * Get the redisVersion property: Redis version. This should be in the form 'major[.minor]' (only 'major' is
     * required) or the value 'latest' which refers to the latest stable Redis version that is available. Supported
     * versions: 4.0, 6.0 (latest). Default value is 'latest'.
     * 
     * @return the redisVersion value.
     */
    public String redisVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().redisVersion();
    }

    /**
     * Set the redisVersion property: Redis version. This should be in the form 'major[.minor]' (only 'major' is
     * required) or the value 'latest' which refers to the latest stable Redis version that is available. Supported
     * versions: 4.0, 6.0 (latest). Default value is 'latest'.
     * 
     * @param redisVersion the redisVersion value to set.
     * @return the RedisResourceInner object itself.
     */
    public RedisResourceInner withRedisVersion(String redisVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withRedisVersion(redisVersion);
        return this;
    }

    /**
     * Get the enableNonSslPort property: Specifies whether the non-ssl Redis server port (6379) is enabled.
     * 
     * @return the enableNonSslPort value.
     */
    public Boolean enableNonSslPort() {
        return this.innerProperties() == null ? null : this.innerProperties().enableNonSslPort();
    }

    /**
     * Set the enableNonSslPort property: Specifies whether the non-ssl Redis server port (6379) is enabled.
     * 
     * @param enableNonSslPort the enableNonSslPort value to set.
     * @return the RedisResourceInner object itself.
     */
    public RedisResourceInner withEnableNonSslPort(Boolean enableNonSslPort) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withEnableNonSslPort(enableNonSslPort);
        return this;
    }

    /**
     * Get the replicasPerMaster property: The number of replicas to be created per primary.
     * 
     * @return the replicasPerMaster value.
     */
    public Integer replicasPerMaster() {
        return this.innerProperties() == null ? null : this.innerProperties().replicasPerMaster();
    }

    /**
     * Set the replicasPerMaster property: The number of replicas to be created per primary.
     * 
     * @param replicasPerMaster the replicasPerMaster value to set.
     * @return the RedisResourceInner object itself.
     */
    public RedisResourceInner withReplicasPerMaster(Integer replicasPerMaster) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withReplicasPerMaster(replicasPerMaster);
        return this;
    }

    /**
     * Get the replicasPerPrimary property: The number of replicas to be created per primary.
     * 
     * @return the replicasPerPrimary value.
     */
    public Integer replicasPerPrimary() {
        return this.innerProperties() == null ? null : this.innerProperties().replicasPerPrimary();
    }

    /**
     * Set the replicasPerPrimary property: The number of replicas to be created per primary.
     * 
     * @param replicasPerPrimary the replicasPerPrimary value to set.
     * @return the RedisResourceInner object itself.
     */
    public RedisResourceInner withReplicasPerPrimary(Integer replicasPerPrimary) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withReplicasPerPrimary(replicasPerPrimary);
        return this;
    }

    /**
     * Get the tenantSettings property: A dictionary of tenant settings.
     * 
     * @return the tenantSettings value.
     */
    public Map<String, String> tenantSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().tenantSettings();
    }

    /**
     * Set the tenantSettings property: A dictionary of tenant settings.
     * 
     * @param tenantSettings the tenantSettings value to set.
     * @return the RedisResourceInner object itself.
     */
    public RedisResourceInner withTenantSettings(Map<String, String> tenantSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withTenantSettings(tenantSettings);
        return this;
    }

    /**
     * Get the shardCount property: The number of shards to be created on a Premium Cluster Cache.
     * 
     * @return the shardCount value.
     */
    public Integer shardCount() {
        return this.innerProperties() == null ? null : this.innerProperties().shardCount();
    }

    /**
     * Set the shardCount property: The number of shards to be created on a Premium Cluster Cache.
     * 
     * @param shardCount the shardCount value to set.
     * @return the RedisResourceInner object itself.
     */
    public RedisResourceInner withShardCount(Integer shardCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withShardCount(shardCount);
        return this;
    }

    /**
     * Get the minimumTlsVersion property: Optional: requires clients to use a specified TLS version (or higher) to
     * connect (e,g, '1.0', '1.1', '1.2').
     * 
     * @return the minimumTlsVersion value.
     */
    public TlsVersion minimumTlsVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().minimumTlsVersion();
    }

    /**
     * Set the minimumTlsVersion property: Optional: requires clients to use a specified TLS version (or higher) to
     * connect (e,g, '1.0', '1.1', '1.2').
     * 
     * @param minimumTlsVersion the minimumTlsVersion value to set.
     * @return the RedisResourceInner object itself.
     */
    public RedisResourceInner withMinimumTlsVersion(TlsVersion minimumTlsVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withMinimumTlsVersion(minimumTlsVersion);
        return this;
    }

    /**
     * Get the publicNetworkAccess property: Whether or not public endpoint access is allowed for this cache. Value is
     * optional but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the exclusive
     * access method. Default value is 'Enabled'.
     * 
     * @return the publicNetworkAccess value.
     */
    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    /**
     * Set the publicNetworkAccess property: Whether or not public endpoint access is allowed for this cache. Value is
     * optional but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the exclusive
     * access method. Default value is 'Enabled'.
     * 
     * @param publicNetworkAccess the publicNetworkAccess value to set.
     * @return the RedisResourceInner object itself.
     */
    public RedisResourceInner withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    /**
     * Get the updateChannel property: Optional: Specifies the update channel for the monthly Redis updates your Redis
     * Cache will receive. Caches using 'Preview' update channel get latest Redis updates at least 4 weeks ahead of
     * 'Stable' channel caches. Default value is 'Stable'.
     * 
     * @return the updateChannel value.
     */
    public UpdateChannel updateChannel() {
        return this.innerProperties() == null ? null : this.innerProperties().updateChannel();
    }

    /**
     * Set the updateChannel property: Optional: Specifies the update channel for the monthly Redis updates your Redis
     * Cache will receive. Caches using 'Preview' update channel get latest Redis updates at least 4 weeks ahead of
     * 'Stable' channel caches. Default value is 'Stable'.
     * 
     * @param updateChannel the updateChannel value to set.
     * @return the RedisResourceInner object itself.
     */
    public RedisResourceInner withUpdateChannel(UpdateChannel updateChannel) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withUpdateChannel(updateChannel);
        return this;
    }

    /**
     * Get the disableAccessKeyAuthentication property: Authentication to Redis through access keys is disabled when set
     * as true. Default value is false.
     * 
     * @return the disableAccessKeyAuthentication value.
     */
    public Boolean disableAccessKeyAuthentication() {
        return this.innerProperties() == null ? null : this.innerProperties().disableAccessKeyAuthentication();
    }

    /**
     * Set the disableAccessKeyAuthentication property: Authentication to Redis through access keys is disabled when set
     * as true. Default value is false.
     * 
     * @param disableAccessKeyAuthentication the disableAccessKeyAuthentication value to set.
     * @return the RedisResourceInner object itself.
     */
    public RedisResourceInner withDisableAccessKeyAuthentication(Boolean disableAccessKeyAuthentication) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withDisableAccessKeyAuthentication(disableAccessKeyAuthentication);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerProperties in model RedisResourceInner"));
        } else {
            innerProperties().validate();
        }
        if (identity() != null) {
            identity().validate();
        }
        if (location() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property location in model RedisResourceInner"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RedisResourceInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", this.identity);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RedisResourceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RedisResourceInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RedisResourceInner.
     */
    public static RedisResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RedisResourceInner deserializedRedisResourceInner = new RedisResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedRedisResourceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedRedisResourceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedRedisResourceInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedRedisResourceInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedRedisResourceInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedRedisResourceInner.innerProperties = RedisPropertiesInner.fromJson(reader);
                } else if ("zones".equals(fieldName)) {
                    List<String> zones = reader.readArray(reader1 -> reader1.getString());
                    deserializedRedisResourceInner.zones = zones;
                } else if ("identity".equals(fieldName)) {
                    deserializedRedisResourceInner.identity = ManagedServiceIdentity.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRedisResourceInner;
        });
    }
}
