// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Parameters for Redis import operation.
 */
@Fluent
public final class ImportRdbParameters implements JsonSerializable<ImportRdbParameters> {
    /*
     * File format.
     */
    private String format;

    /*
     * files to import.
     */
    private List<String> files;

    /*
     * Preferred auth method to communicate to storage account used for data archive, specify SAS or ManagedIdentity,
     * default value is SAS
     */
    private String preferredDataArchiveAuthMethod;

    /*
     * Subscription id of the storage container containing files to import using Managed Identity.
     */
    private String storageSubscriptionId;

    /**
     * Creates an instance of ImportRdbParameters class.
     */
    public ImportRdbParameters() {
    }

    /**
     * Get the format property: File format.
     * 
     * @return the format value.
     */
    public String format() {
        return this.format;
    }

    /**
     * Set the format property: File format.
     * 
     * @param format the format value to set.
     * @return the ImportRdbParameters object itself.
     */
    public ImportRdbParameters withFormat(String format) {
        this.format = format;
        return this;
    }

    /**
     * Get the files property: files to import.
     * 
     * @return the files value.
     */
    public List<String> files() {
        return this.files;
    }

    /**
     * Set the files property: files to import.
     * 
     * @param files the files value to set.
     * @return the ImportRdbParameters object itself.
     */
    public ImportRdbParameters withFiles(List<String> files) {
        this.files = files;
        return this;
    }

    /**
     * Get the preferredDataArchiveAuthMethod property: Preferred auth method to communicate to storage account used for
     * data archive, specify SAS or ManagedIdentity, default value is SAS.
     * 
     * @return the preferredDataArchiveAuthMethod value.
     */
    public String preferredDataArchiveAuthMethod() {
        return this.preferredDataArchiveAuthMethod;
    }

    /**
     * Set the preferredDataArchiveAuthMethod property: Preferred auth method to communicate to storage account used for
     * data archive, specify SAS or ManagedIdentity, default value is SAS.
     * 
     * @param preferredDataArchiveAuthMethod the preferredDataArchiveAuthMethod value to set.
     * @return the ImportRdbParameters object itself.
     */
    public ImportRdbParameters withPreferredDataArchiveAuthMethod(String preferredDataArchiveAuthMethod) {
        this.preferredDataArchiveAuthMethod = preferredDataArchiveAuthMethod;
        return this;
    }

    /**
     * Get the storageSubscriptionId property: Subscription id of the storage container containing files to import using
     * Managed Identity.
     * 
     * @return the storageSubscriptionId value.
     */
    public String storageSubscriptionId() {
        return this.storageSubscriptionId;
    }

    /**
     * Set the storageSubscriptionId property: Subscription id of the storage container containing files to import using
     * Managed Identity.
     * 
     * @param storageSubscriptionId the storageSubscriptionId value to set.
     * @return the ImportRdbParameters object itself.
     */
    public ImportRdbParameters withStorageSubscriptionId(String storageSubscriptionId) {
        this.storageSubscriptionId = storageSubscriptionId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (files() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property files in model ImportRdbParameters"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ImportRdbParameters.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("files", this.files, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("format", this.format);
        jsonWriter.writeStringField("preferred-data-archive-auth-method", this.preferredDataArchiveAuthMethod);
        jsonWriter.writeStringField("storage-subscription-id", this.storageSubscriptionId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ImportRdbParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ImportRdbParameters if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ImportRdbParameters.
     */
    public static ImportRdbParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ImportRdbParameters deserializedImportRdbParameters = new ImportRdbParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("files".equals(fieldName)) {
                    List<String> files = reader.readArray(reader1 -> reader1.getString());
                    deserializedImportRdbParameters.files = files;
                } else if ("format".equals(fieldName)) {
                    deserializedImportRdbParameters.format = reader.getString();
                } else if ("preferred-data-archive-auth-method".equals(fieldName)) {
                    deserializedImportRdbParameters.preferredDataArchiveAuthMethod = reader.getString();
                } else if ("storage-subscription-id".equals(fieldName)) {
                    deserializedImportRdbParameters.storageSubscriptionId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedImportRdbParameters;
        });
    }
}
