// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.models;

/**
 * The Redis access key to regenerate.
 */
public enum RedisKeyType {
    /**
     * Enum value Primary.
     */
    PRIMARY("Primary"),

    /**
     * Enum value Secondary.
     */
    SECONDARY("Secondary");

    /**
     * The actual serialized value for a RedisKeyType instance.
     */
    private final String value;

    RedisKeyType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a RedisKeyType instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed RedisKeyType object, or null if unable to parse.
     */
    public static RedisKeyType fromString(String value) {
        if (value == null) {
            return null;
        }
        RedisKeyType[] items = RedisKeyType.values();
        for (RedisKeyType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
