// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.redis.fluent.models.RedisCacheAccessPolicyAssignmentInner;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in AccessPolicyAssignmentsClient.
 */
public interface AccessPolicyAssignmentsClient {
    /**
     * Adds the access policy assignment to the specified users.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @param parameters Parameters supplied to the Create Update Access Policy Assignment operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response to an operation on access policy assignment along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createUpdateWithResponseAsync(String resourceGroupName, String cacheName,
        String accessPolicyAssignmentName, RedisCacheAccessPolicyAssignmentInner parameters);

    /**
     * Adds the access policy assignment to the specified users.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @param parameters Parameters supplied to the Create Update Access Policy Assignment operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of response to an operation on access policy assignment.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<RedisCacheAccessPolicyAssignmentInner>, RedisCacheAccessPolicyAssignmentInner>
        beginCreateUpdateAsync(String resourceGroupName, String cacheName, String accessPolicyAssignmentName,
            RedisCacheAccessPolicyAssignmentInner parameters);

    /**
     * Adds the access policy assignment to the specified users.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @param parameters Parameters supplied to the Create Update Access Policy Assignment operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of response to an operation on access policy assignment.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<RedisCacheAccessPolicyAssignmentInner>, RedisCacheAccessPolicyAssignmentInner>
        beginCreateUpdate(String resourceGroupName, String cacheName, String accessPolicyAssignmentName,
            RedisCacheAccessPolicyAssignmentInner parameters);

    /**
     * Adds the access policy assignment to the specified users.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @param parameters Parameters supplied to the Create Update Access Policy Assignment operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of response to an operation on access policy assignment.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<RedisCacheAccessPolicyAssignmentInner>, RedisCacheAccessPolicyAssignmentInner>
        beginCreateUpdate(String resourceGroupName, String cacheName, String accessPolicyAssignmentName,
            RedisCacheAccessPolicyAssignmentInner parameters, Context context);

    /**
     * Adds the access policy assignment to the specified users.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @param parameters Parameters supplied to the Create Update Access Policy Assignment operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response to an operation on access policy assignment on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RedisCacheAccessPolicyAssignmentInner> createUpdateAsync(String resourceGroupName, String cacheName,
        String accessPolicyAssignmentName, RedisCacheAccessPolicyAssignmentInner parameters);

    /**
     * Adds the access policy assignment to the specified users.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @param parameters Parameters supplied to the Create Update Access Policy Assignment operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response to an operation on access policy assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RedisCacheAccessPolicyAssignmentInner createUpdate(String resourceGroupName, String cacheName,
        String accessPolicyAssignmentName, RedisCacheAccessPolicyAssignmentInner parameters);

    /**
     * Adds the access policy assignment to the specified users.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @param parameters Parameters supplied to the Create Update Access Policy Assignment operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response to an operation on access policy assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RedisCacheAccessPolicyAssignmentInner createUpdate(String resourceGroupName, String cacheName,
        String accessPolicyAssignmentName, RedisCacheAccessPolicyAssignmentInner parameters, Context context);

    /**
     * Deletes the access policy assignment from a redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String cacheName,
        String accessPolicyAssignmentName);

    /**
     * Deletes the access policy assignment from a redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String cacheName,
        String accessPolicyAssignmentName);

    /**
     * Deletes the access policy assignment from a redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String cacheName,
        String accessPolicyAssignmentName);

    /**
     * Deletes the access policy assignment from a redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String cacheName,
        String accessPolicyAssignmentName, Context context);

    /**
     * Deletes the access policy assignment from a redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String cacheName, String accessPolicyAssignmentName);

    /**
     * Deletes the access policy assignment from a redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String cacheName, String accessPolicyAssignmentName);

    /**
     * Deletes the access policy assignment from a redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String cacheName, String accessPolicyAssignmentName, Context context);

    /**
     * Gets the list of assignments for an access policy of a redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of assignments for an access policy of a redis cache along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RedisCacheAccessPolicyAssignmentInner>> getWithResponseAsync(String resourceGroupName,
        String cacheName, String accessPolicyAssignmentName);

    /**
     * Gets the list of assignments for an access policy of a redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of assignments for an access policy of a redis cache on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RedisCacheAccessPolicyAssignmentInner> getAsync(String resourceGroupName, String cacheName,
        String accessPolicyAssignmentName);

    /**
     * Gets the list of assignments for an access policy of a redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of assignments for an access policy of a redis cache along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RedisCacheAccessPolicyAssignmentInner> getWithResponse(String resourceGroupName, String cacheName,
        String accessPolicyAssignmentName, Context context);

    /**
     * Gets the list of assignments for an access policy of a redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param accessPolicyAssignmentName The name of the access policy assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of assignments for an access policy of a redis cache.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RedisCacheAccessPolicyAssignmentInner get(String resourceGroupName, String cacheName,
        String accessPolicyAssignmentName);

    /**
     * Gets the list of access policy assignments associated with this redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of access policy assignments associated with this redis cache as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<RedisCacheAccessPolicyAssignmentInner> listAsync(String resourceGroupName, String cacheName);

    /**
     * Gets the list of access policy assignments associated with this redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of access policy assignments associated with this redis cache as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RedisCacheAccessPolicyAssignmentInner> list(String resourceGroupName, String cacheName);

    /**
     * Gets the list of access policy assignments associated with this redis cache.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param cacheName The name of the Redis cache.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of access policy assignments associated with this redis cache as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RedisCacheAccessPolicyAssignmentInner> list(String resourceGroupName, String cacheName,
        Context context);
}
