/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redis.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.redis.models.RedisKeyType;
import java.io.IOException;

public final class RedisRegenerateKeyParameters
implements JsonSerializable<RedisRegenerateKeyParameters> {
    private RedisKeyType keyType;
    private static final ClientLogger LOGGER = new ClientLogger(RedisRegenerateKeyParameters.class);

    public RedisKeyType keyType() {
        return this.keyType;
    }

    public RedisRegenerateKeyParameters withKeyType(RedisKeyType keyType) {
        this.keyType = keyType;
        return this;
    }

    public void validate() {
        if (this.keyType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property keyType in model RedisRegenerateKeyParameters"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyType", this.keyType == null ? null : this.keyType.toString());
        return jsonWriter.writeEndObject();
    }

    public static RedisRegenerateKeyParameters fromJson(JsonReader jsonReader) throws IOException {
        return (RedisRegenerateKeyParameters)jsonReader.readObject(reader -> {
            RedisRegenerateKeyParameters deserializedRedisRegenerateKeyParameters = new RedisRegenerateKeyParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyType".equals(fieldName)) {
                    deserializedRedisRegenerateKeyParameters.keyType = RedisKeyType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRedisRegenerateKeyParameters;
        });
    }
}

