// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.redis.models.AccessPolicyProvisioningState;
import com.azure.resourcemanager.redis.models.AccessPolicyType;
import java.io.IOException;

/**
 * All properties of an access policy.
 */
@Fluent
public final class RedisCacheAccessPolicyProperties implements JsonSerializable<RedisCacheAccessPolicyProperties> {
    /*
     * Provisioning state of access policy
     */
    private AccessPolicyProvisioningState provisioningState;

    /*
     * Built-In or Custom access policy
     */
    private AccessPolicyType type;

    /*
     * Permissions for the access policy. Learn how to configure permissions at https://aka.ms/redis/AADPreRequisites
     */
    private String permissions;

    /**
     * Creates an instance of RedisCacheAccessPolicyProperties class.
     */
    public RedisCacheAccessPolicyProperties() {
    }

    /**
     * Get the provisioningState property: Provisioning state of access policy.
     * 
     * @return the provisioningState value.
     */
    public AccessPolicyProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the type property: Built-In or Custom access policy.
     * 
     * @return the type value.
     */
    public AccessPolicyType type() {
        return this.type;
    }

    /**
     * Get the permissions property: Permissions for the access policy. Learn how to configure permissions at
     * https://aka.ms/redis/AADPreRequisites.
     * 
     * @return the permissions value.
     */
    public String permissions() {
        return this.permissions;
    }

    /**
     * Set the permissions property: Permissions for the access policy. Learn how to configure permissions at
     * https://aka.ms/redis/AADPreRequisites.
     * 
     * @param permissions the permissions value to set.
     * @return the RedisCacheAccessPolicyProperties object itself.
     */
    public RedisCacheAccessPolicyProperties withPermissions(String permissions) {
        this.permissions = permissions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (permissions() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property permissions in model RedisCacheAccessPolicyProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RedisCacheAccessPolicyProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("permissions", this.permissions);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RedisCacheAccessPolicyProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RedisCacheAccessPolicyProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RedisCacheAccessPolicyProperties.
     */
    public static RedisCacheAccessPolicyProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RedisCacheAccessPolicyProperties deserializedRedisCacheAccessPolicyProperties
                = new RedisCacheAccessPolicyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("permissions".equals(fieldName)) {
                    deserializedRedisCacheAccessPolicyProperties.permissions = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedRedisCacheAccessPolicyProperties.provisioningState
                        = AccessPolicyProvisioningState.fromString(reader.getString());
                } else if ("type".equals(fieldName)) {
                    deserializedRedisCacheAccessPolicyProperties.type = AccessPolicyType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRedisCacheAccessPolicyProperties;
        });
    }
}
