// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.redis.models.AccessPolicyProvisioningState;
import com.azure.resourcemanager.redis.models.AccessPolicyType;
import java.io.IOException;

/**
 * Response to get/put access policy.
 */
@Fluent
public final class RedisCacheAccessPolicyInner extends ProxyResource {
    /*
     * Properties of an access policy.
     */
    private RedisCacheAccessPolicyProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of RedisCacheAccessPolicyInner class.
     */
    public RedisCacheAccessPolicyInner() {
    }

    /**
     * Get the innerProperties property: Properties of an access policy.
     * 
     * @return the innerProperties value.
     */
    private RedisCacheAccessPolicyProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the provisioningState property: Provisioning state of access policy.
     * 
     * @return the provisioningState value.
     */
    public AccessPolicyProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the type property: Built-In or Custom access policy.
     * 
     * @return the type value.
     */
    public AccessPolicyType typePropertiesType() {
        return this.innerProperties() == null ? null : this.innerProperties().type();
    }

    /**
     * Get the permissions property: Permissions for the access policy. Learn how to configure permissions at
     * https://aka.ms/redis/AADPreRequisites.
     * 
     * @return the permissions value.
     */
    public String permissions() {
        return this.innerProperties() == null ? null : this.innerProperties().permissions();
    }

    /**
     * Set the permissions property: Permissions for the access policy. Learn how to configure permissions at
     * https://aka.ms/redis/AADPreRequisites.
     * 
     * @param permissions the permissions value to set.
     * @return the RedisCacheAccessPolicyInner object itself.
     */
    public RedisCacheAccessPolicyInner withPermissions(String permissions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisCacheAccessPolicyProperties();
        }
        this.innerProperties().withPermissions(permissions);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RedisCacheAccessPolicyInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RedisCacheAccessPolicyInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RedisCacheAccessPolicyInner.
     */
    public static RedisCacheAccessPolicyInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RedisCacheAccessPolicyInner deserializedRedisCacheAccessPolicyInner = new RedisCacheAccessPolicyInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedRedisCacheAccessPolicyInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedRedisCacheAccessPolicyInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedRedisCacheAccessPolicyInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedRedisCacheAccessPolicyInner.innerProperties
                        = RedisCacheAccessPolicyProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRedisCacheAccessPolicyInner;
        });
    }
}
