// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.redis.models.ReplicationRole;
import java.io.IOException;

/**
 * Response to put/get linked server (with properties) for Redis cache.
 */
@Fluent
public final class RedisLinkedServerWithPropertiesInner extends ProxyResource {
    /*
     * Properties of the linked server.
     */
    private RedisLinkedServerProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of RedisLinkedServerWithPropertiesInner class.
     */
    public RedisLinkedServerWithPropertiesInner() {
    }

    /**
     * Get the innerProperties property: Properties of the linked server.
     * 
     * @return the innerProperties value.
     */
    private RedisLinkedServerProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the provisioningState property: Terminal state of the link between primary and secondary redis cache.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the linkedRedisCacheId property: Fully qualified resourceId of the linked redis cache.
     * 
     * @return the linkedRedisCacheId value.
     */
    public String linkedRedisCacheId() {
        return this.innerProperties() == null ? null : this.innerProperties().linkedRedisCacheId();
    }

    /**
     * Set the linkedRedisCacheId property: Fully qualified resourceId of the linked redis cache.
     * 
     * @param linkedRedisCacheId the linkedRedisCacheId value to set.
     * @return the RedisLinkedServerWithPropertiesInner object itself.
     */
    public RedisLinkedServerWithPropertiesInner withLinkedRedisCacheId(String linkedRedisCacheId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisLinkedServerProperties();
        }
        this.innerProperties().withLinkedRedisCacheId(linkedRedisCacheId);
        return this;
    }

    /**
     * Get the linkedRedisCacheLocation property: Location of the linked redis cache.
     * 
     * @return the linkedRedisCacheLocation value.
     */
    public String linkedRedisCacheLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().linkedRedisCacheLocation();
    }

    /**
     * Set the linkedRedisCacheLocation property: Location of the linked redis cache.
     * 
     * @param linkedRedisCacheLocation the linkedRedisCacheLocation value to set.
     * @return the RedisLinkedServerWithPropertiesInner object itself.
     */
    public RedisLinkedServerWithPropertiesInner withLinkedRedisCacheLocation(String linkedRedisCacheLocation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisLinkedServerProperties();
        }
        this.innerProperties().withLinkedRedisCacheLocation(linkedRedisCacheLocation);
        return this;
    }

    /**
     * Get the serverRole property: Role of the linked server.
     * 
     * @return the serverRole value.
     */
    public ReplicationRole serverRole() {
        return this.innerProperties() == null ? null : this.innerProperties().serverRole();
    }

    /**
     * Set the serverRole property: Role of the linked server.
     * 
     * @param serverRole the serverRole value to set.
     * @return the RedisLinkedServerWithPropertiesInner object itself.
     */
    public RedisLinkedServerWithPropertiesInner withServerRole(ReplicationRole serverRole) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisLinkedServerProperties();
        }
        this.innerProperties().withServerRole(serverRole);
        return this;
    }

    /**
     * Get the geoReplicatedPrimaryHostname property: The unchanging DNS name which will always point to current
     * geo-primary cache among the linked redis caches for seamless Geo Failover experience.
     * 
     * @return the geoReplicatedPrimaryHostname value.
     */
    public String geoReplicatedPrimaryHostname() {
        return this.innerProperties() == null ? null : this.innerProperties().geoReplicatedPrimaryHostname();
    }

    /**
     * Get the primaryHostname property: The changing DNS name that resolves to the current geo-primary cache among the
     * linked redis caches before or after the Geo Failover.
     * 
     * @return the primaryHostname value.
     */
    public String primaryHostname() {
        return this.innerProperties() == null ? null : this.innerProperties().primaryHostname();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RedisLinkedServerWithPropertiesInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RedisLinkedServerWithPropertiesInner if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RedisLinkedServerWithPropertiesInner.
     */
    public static RedisLinkedServerWithPropertiesInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RedisLinkedServerWithPropertiesInner deserializedRedisLinkedServerWithPropertiesInner
                = new RedisLinkedServerWithPropertiesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedRedisLinkedServerWithPropertiesInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedRedisLinkedServerWithPropertiesInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedRedisLinkedServerWithPropertiesInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedRedisLinkedServerWithPropertiesInner.innerProperties
                        = RedisLinkedServerProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRedisLinkedServerWithPropertiesInner;
        });
    }
}
