// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * The current status of an async operation.
 */
@Fluent
public class OperationStatusResult implements JsonSerializable<OperationStatusResult> {
    /*
     * Fully qualified ID for the async operation.
     */
    private String id;

    /*
     * Name of the async operation.
     */
    private String name;

    /*
     * Operation status.
     */
    private String status;

    /*
     * Percent of the operation that is complete.
     */
    private Float percentComplete;

    /*
     * The start time of the operation.
     */
    private OffsetDateTime startTime;

    /*
     * The end time of the operation.
     */
    private OffsetDateTime endTime;

    /*
     * The operations list.
     */
    private List<OperationStatusResult> operations;

    /*
     * If present, details of the operation error.
     */
    private ManagementError error;

    /**
     * Creates an instance of OperationStatusResult class.
     */
    public OperationStatusResult() {
    }

    /**
     * Get the id property: Fully qualified ID for the async operation.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Fully qualified ID for the async operation.
     * 
     * @param id the id value to set.
     * @return the OperationStatusResult object itself.
     */
    public OperationStatusResult withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name property: Name of the async operation.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the async operation.
     * 
     * @param name the name value to set.
     * @return the OperationStatusResult object itself.
     */
    public OperationStatusResult withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the status property: Operation status.
     * 
     * @return the status value.
     */
    public String status() {
        return this.status;
    }

    /**
     * Set the status property: Operation status.
     * 
     * @param status the status value to set.
     * @return the OperationStatusResult object itself.
     */
    public OperationStatusResult withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
     * Get the percentComplete property: Percent of the operation that is complete.
     * 
     * @return the percentComplete value.
     */
    public Float percentComplete() {
        return this.percentComplete;
    }

    /**
     * Set the percentComplete property: Percent of the operation that is complete.
     * 
     * @param percentComplete the percentComplete value to set.
     * @return the OperationStatusResult object itself.
     */
    public OperationStatusResult withPercentComplete(Float percentComplete) {
        this.percentComplete = percentComplete;
        return this;
    }

    /**
     * Get the startTime property: The start time of the operation.
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Set the startTime property: The start time of the operation.
     * 
     * @param startTime the startTime value to set.
     * @return the OperationStatusResult object itself.
     */
    public OperationStatusResult withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the endTime property: The end time of the operation.
     * 
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.endTime;
    }

    /**
     * Set the endTime property: The end time of the operation.
     * 
     * @param endTime the endTime value to set.
     * @return the OperationStatusResult object itself.
     */
    public OperationStatusResult withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    /**
     * Get the operations property: The operations list.
     * 
     * @return the operations value.
     */
    public List<OperationStatusResult> operations() {
        return this.operations;
    }

    /**
     * Set the operations property: The operations list.
     * 
     * @param operations the operations value to set.
     * @return the OperationStatusResult object itself.
     */
    public OperationStatusResult withOperations(List<OperationStatusResult> operations) {
        this.operations = operations;
        return this;
    }

    /**
     * Get the error property: If present, details of the operation error.
     * 
     * @return the error value.
     */
    public ManagementError error() {
        return this.error;
    }

    /**
     * Set the error property: If present, details of the operation error.
     * 
     * @param error the error value to set.
     * @return the OperationStatusResult object itself.
     */
    public OperationStatusResult withError(ManagementError error) {
        this.error = error;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (status() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property status in model OperationStatusResult"));
        }
        if (operations() != null) {
            operations().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(OperationStatusResult.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeNumberField("percentComplete", this.percentComplete);
        jsonWriter.writeStringField("startTime",
            this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime",
            this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeArrayField("operations", this.operations, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("error", this.error);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OperationStatusResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OperationStatusResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the OperationStatusResult.
     */
    public static OperationStatusResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OperationStatusResult deserializedOperationStatusResult = new OperationStatusResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("status".equals(fieldName)) {
                    deserializedOperationStatusResult.status = reader.getString();
                } else if ("id".equals(fieldName)) {
                    deserializedOperationStatusResult.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedOperationStatusResult.name = reader.getString();
                } else if ("percentComplete".equals(fieldName)) {
                    deserializedOperationStatusResult.percentComplete = reader.getNullable(JsonReader::getFloat);
                } else if ("startTime".equals(fieldName)) {
                    deserializedOperationStatusResult.startTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("endTime".equals(fieldName)) {
                    deserializedOperationStatusResult.endTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("operations".equals(fieldName)) {
                    List<OperationStatusResult> operations
                        = reader.readArray(reader1 -> OperationStatusResult.fromJson(reader1));
                    deserializedOperationStatusResult.operations = operations;
                } else if ("error".equals(fieldName)) {
                    deserializedOperationStatusResult.error = ManagementError.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOperationStatusResult;
        });
    }
}
