// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Create/Update/Get common properties of the redis cache.
 */
@Fluent
public class RedisCommonProperties implements JsonSerializable<RedisCommonProperties> {
    /*
     * All Redis Settings. Few possible keys:
     * rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,
     * maxmemory-policy,notify-keyspace-events, aof-backup-enabled, aof-storage-connection-string-0,
     * aof-storage-connection-string-1 etc.
     */
    private RedisConfiguration redisConfiguration;

    /*
     * Redis version. This should be in the form 'major[.minor]' (only 'major' is required) or the value 'latest' which
     * refers to the latest stable Redis version that is available. Supported versions: 4.0, 6.0 (latest). Default value
     * is 'latest'.
     */
    private String redisVersion;

    /*
     * Specifies whether the non-ssl Redis server port (6379) is enabled.
     */
    private Boolean enableNonSslPort;

    /*
     * The number of replicas to be created per primary.
     */
    private Integer replicasPerMaster;

    /*
     * The number of replicas to be created per primary.
     */
    private Integer replicasPerPrimary;

    /*
     * A dictionary of tenant settings
     */
    private Map<String, String> tenantSettings;

    /*
     * The number of shards to be created on a Premium Cluster Cache.
     */
    private Integer shardCount;

    /*
     * Optional: requires clients to use a specified TLS version (or higher) to connect (e,g, '1.0', '1.1', '1.2')
     */
    private TlsVersion minimumTlsVersion;

    /*
     * Whether or not public endpoint access is allowed for this cache. Value is optional but if passed in, must be
     * 'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the exclusive access method. Default value is
     * 'Enabled'
     */
    private PublicNetworkAccess publicNetworkAccess;

    /*
     * Optional: Specifies the update channel for the monthly Redis updates your Redis Cache will receive. Caches using
     * 'Preview' update channel get latest Redis updates at least 4 weeks ahead of 'Stable' channel caches. Default
     * value is 'Stable'.
     */
    private UpdateChannel updateChannel;

    /*
     * Authentication to Redis through access keys is disabled when set as true. Default value is false.
     */
    private Boolean disableAccessKeyAuthentication;

    /*
     * Optional: Specifies how availability zones are allocated to the Redis cache. 'Automatic' enables zone redundancy
     * and Azure will automatically select zones based on regional availability and capacity. 'UserDefined' will select
     * availability zones passed in by you using the 'zones' parameter. 'NoZones' will produce a non-zonal cache. If
     * 'zonalAllocationPolicy' is not passed, it will be set to 'UserDefined' when zones are passed in, otherwise, it
     * will be set to 'Automatic' in regions where zones are supported and 'NoZones' in regions where zones are not
     * supported.
     */
    private ZonalAllocationPolicy zonalAllocationPolicy;

    /**
     * Creates an instance of RedisCommonProperties class.
     */
    public RedisCommonProperties() {
    }

    /**
     * Get the redisConfiguration property: All Redis Settings. Few possible keys:
     * rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,
     * maxmemory-policy,notify-keyspace-events, aof-backup-enabled, aof-storage-connection-string-0,
     * aof-storage-connection-string-1 etc.
     * 
     * @return the redisConfiguration value.
     */
    public RedisConfiguration redisConfiguration() {
        return this.redisConfiguration;
    }

    /**
     * Set the redisConfiguration property: All Redis Settings. Few possible keys:
     * rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,
     * maxmemory-policy,notify-keyspace-events, aof-backup-enabled, aof-storage-connection-string-0,
     * aof-storage-connection-string-1 etc.
     * 
     * @param redisConfiguration the redisConfiguration value to set.
     * @return the RedisCommonProperties object itself.
     */
    public RedisCommonProperties withRedisConfiguration(RedisConfiguration redisConfiguration) {
        this.redisConfiguration = redisConfiguration;
        return this;
    }

    /**
     * Get the redisVersion property: Redis version. This should be in the form 'major[.minor]' (only 'major' is
     * required) or the value 'latest' which refers to the latest stable Redis version that is available. Supported
     * versions: 4.0, 6.0 (latest). Default value is 'latest'.
     * 
     * @return the redisVersion value.
     */
    public String redisVersion() {
        return this.redisVersion;
    }

    /**
     * Set the redisVersion property: Redis version. This should be in the form 'major[.minor]' (only 'major' is
     * required) or the value 'latest' which refers to the latest stable Redis version that is available. Supported
     * versions: 4.0, 6.0 (latest). Default value is 'latest'.
     * 
     * @param redisVersion the redisVersion value to set.
     * @return the RedisCommonProperties object itself.
     */
    public RedisCommonProperties withRedisVersion(String redisVersion) {
        this.redisVersion = redisVersion;
        return this;
    }

    /**
     * Get the enableNonSslPort property: Specifies whether the non-ssl Redis server port (6379) is enabled.
     * 
     * @return the enableNonSslPort value.
     */
    public Boolean enableNonSslPort() {
        return this.enableNonSslPort;
    }

    /**
     * Set the enableNonSslPort property: Specifies whether the non-ssl Redis server port (6379) is enabled.
     * 
     * @param enableNonSslPort the enableNonSslPort value to set.
     * @return the RedisCommonProperties object itself.
     */
    public RedisCommonProperties withEnableNonSslPort(Boolean enableNonSslPort) {
        this.enableNonSslPort = enableNonSslPort;
        return this;
    }

    /**
     * Get the replicasPerMaster property: The number of replicas to be created per primary.
     * 
     * @return the replicasPerMaster value.
     */
    public Integer replicasPerMaster() {
        return this.replicasPerMaster;
    }

    /**
     * Set the replicasPerMaster property: The number of replicas to be created per primary.
     * 
     * @param replicasPerMaster the replicasPerMaster value to set.
     * @return the RedisCommonProperties object itself.
     */
    public RedisCommonProperties withReplicasPerMaster(Integer replicasPerMaster) {
        this.replicasPerMaster = replicasPerMaster;
        return this;
    }

    /**
     * Get the replicasPerPrimary property: The number of replicas to be created per primary.
     * 
     * @return the replicasPerPrimary value.
     */
    public Integer replicasPerPrimary() {
        return this.replicasPerPrimary;
    }

    /**
     * Set the replicasPerPrimary property: The number of replicas to be created per primary.
     * 
     * @param replicasPerPrimary the replicasPerPrimary value to set.
     * @return the RedisCommonProperties object itself.
     */
    public RedisCommonProperties withReplicasPerPrimary(Integer replicasPerPrimary) {
        this.replicasPerPrimary = replicasPerPrimary;
        return this;
    }

    /**
     * Get the tenantSettings property: A dictionary of tenant settings.
     * 
     * @return the tenantSettings value.
     */
    public Map<String, String> tenantSettings() {
        return this.tenantSettings;
    }

    /**
     * Set the tenantSettings property: A dictionary of tenant settings.
     * 
     * @param tenantSettings the tenantSettings value to set.
     * @return the RedisCommonProperties object itself.
     */
    public RedisCommonProperties withTenantSettings(Map<String, String> tenantSettings) {
        this.tenantSettings = tenantSettings;
        return this;
    }

    /**
     * Get the shardCount property: The number of shards to be created on a Premium Cluster Cache.
     * 
     * @return the shardCount value.
     */
    public Integer shardCount() {
        return this.shardCount;
    }

    /**
     * Set the shardCount property: The number of shards to be created on a Premium Cluster Cache.
     * 
     * @param shardCount the shardCount value to set.
     * @return the RedisCommonProperties object itself.
     */
    public RedisCommonProperties withShardCount(Integer shardCount) {
        this.shardCount = shardCount;
        return this;
    }

    /**
     * Get the minimumTlsVersion property: Optional: requires clients to use a specified TLS version (or higher) to
     * connect (e,g, '1.0', '1.1', '1.2').
     * 
     * @return the minimumTlsVersion value.
     */
    public TlsVersion minimumTlsVersion() {
        return this.minimumTlsVersion;
    }

    /**
     * Set the minimumTlsVersion property: Optional: requires clients to use a specified TLS version (or higher) to
     * connect (e,g, '1.0', '1.1', '1.2').
     * 
     * @param minimumTlsVersion the minimumTlsVersion value to set.
     * @return the RedisCommonProperties object itself.
     */
    public RedisCommonProperties withMinimumTlsVersion(TlsVersion minimumTlsVersion) {
        this.minimumTlsVersion = minimumTlsVersion;
        return this;
    }

    /**
     * Get the publicNetworkAccess property: Whether or not public endpoint access is allowed for this cache. Value is
     * optional but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the exclusive
     * access method. Default value is 'Enabled'.
     * 
     * @return the publicNetworkAccess value.
     */
    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    /**
     * Set the publicNetworkAccess property: Whether or not public endpoint access is allowed for this cache. Value is
     * optional but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the exclusive
     * access method. Default value is 'Enabled'.
     * 
     * @param publicNetworkAccess the publicNetworkAccess value to set.
     * @return the RedisCommonProperties object itself.
     */
    public RedisCommonProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    /**
     * Get the updateChannel property: Optional: Specifies the update channel for the monthly Redis updates your Redis
     * Cache will receive. Caches using 'Preview' update channel get latest Redis updates at least 4 weeks ahead of
     * 'Stable' channel caches. Default value is 'Stable'.
     * 
     * @return the updateChannel value.
     */
    public UpdateChannel updateChannel() {
        return this.updateChannel;
    }

    /**
     * Set the updateChannel property: Optional: Specifies the update channel for the monthly Redis updates your Redis
     * Cache will receive. Caches using 'Preview' update channel get latest Redis updates at least 4 weeks ahead of
     * 'Stable' channel caches. Default value is 'Stable'.
     * 
     * @param updateChannel the updateChannel value to set.
     * @return the RedisCommonProperties object itself.
     */
    public RedisCommonProperties withUpdateChannel(UpdateChannel updateChannel) {
        this.updateChannel = updateChannel;
        return this;
    }

    /**
     * Get the disableAccessKeyAuthentication property: Authentication to Redis through access keys is disabled when set
     * as true. Default value is false.
     * 
     * @return the disableAccessKeyAuthentication value.
     */
    public Boolean disableAccessKeyAuthentication() {
        return this.disableAccessKeyAuthentication;
    }

    /**
     * Set the disableAccessKeyAuthentication property: Authentication to Redis through access keys is disabled when set
     * as true. Default value is false.
     * 
     * @param disableAccessKeyAuthentication the disableAccessKeyAuthentication value to set.
     * @return the RedisCommonProperties object itself.
     */
    public RedisCommonProperties withDisableAccessKeyAuthentication(Boolean disableAccessKeyAuthentication) {
        this.disableAccessKeyAuthentication = disableAccessKeyAuthentication;
        return this;
    }

    /**
     * Get the zonalAllocationPolicy property: Optional: Specifies how availability zones are allocated to the Redis
     * cache. 'Automatic' enables zone redundancy and Azure will automatically select zones based on regional
     * availability and capacity. 'UserDefined' will select availability zones passed in by you using the 'zones'
     * parameter. 'NoZones' will produce a non-zonal cache. If 'zonalAllocationPolicy' is not passed, it will be set to
     * 'UserDefined' when zones are passed in, otherwise, it will be set to 'Automatic' in regions where zones are
     * supported and 'NoZones' in regions where zones are not supported.
     * 
     * @return the zonalAllocationPolicy value.
     */
    public ZonalAllocationPolicy zonalAllocationPolicy() {
        return this.zonalAllocationPolicy;
    }

    /**
     * Set the zonalAllocationPolicy property: Optional: Specifies how availability zones are allocated to the Redis
     * cache. 'Automatic' enables zone redundancy and Azure will automatically select zones based on regional
     * availability and capacity. 'UserDefined' will select availability zones passed in by you using the 'zones'
     * parameter. 'NoZones' will produce a non-zonal cache. If 'zonalAllocationPolicy' is not passed, it will be set to
     * 'UserDefined' when zones are passed in, otherwise, it will be set to 'Automatic' in regions where zones are
     * supported and 'NoZones' in regions where zones are not supported.
     * 
     * @param zonalAllocationPolicy the zonalAllocationPolicy value to set.
     * @return the RedisCommonProperties object itself.
     */
    public RedisCommonProperties withZonalAllocationPolicy(ZonalAllocationPolicy zonalAllocationPolicy) {
        this.zonalAllocationPolicy = zonalAllocationPolicy;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (redisConfiguration() != null) {
            redisConfiguration().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("redisConfiguration", this.redisConfiguration);
        jsonWriter.writeStringField("redisVersion", this.redisVersion);
        jsonWriter.writeBooleanField("enableNonSslPort", this.enableNonSslPort);
        jsonWriter.writeNumberField("replicasPerMaster", this.replicasPerMaster);
        jsonWriter.writeNumberField("replicasPerPrimary", this.replicasPerPrimary);
        jsonWriter.writeMapField("tenantSettings", this.tenantSettings,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("shardCount", this.shardCount);
        jsonWriter.writeStringField("minimumTlsVersion",
            this.minimumTlsVersion == null ? null : this.minimumTlsVersion.toString());
        jsonWriter.writeStringField("publicNetworkAccess",
            this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeStringField("updateChannel", this.updateChannel == null ? null : this.updateChannel.toString());
        jsonWriter.writeBooleanField("disableAccessKeyAuthentication", this.disableAccessKeyAuthentication);
        jsonWriter.writeStringField("zonalAllocationPolicy",
            this.zonalAllocationPolicy == null ? null : this.zonalAllocationPolicy.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RedisCommonProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RedisCommonProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RedisCommonProperties.
     */
    public static RedisCommonProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RedisCommonProperties deserializedRedisCommonProperties = new RedisCommonProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("redisConfiguration".equals(fieldName)) {
                    deserializedRedisCommonProperties.redisConfiguration = RedisConfiguration.fromJson(reader);
                } else if ("redisVersion".equals(fieldName)) {
                    deserializedRedisCommonProperties.redisVersion = reader.getString();
                } else if ("enableNonSslPort".equals(fieldName)) {
                    deserializedRedisCommonProperties.enableNonSslPort = reader.getNullable(JsonReader::getBoolean);
                } else if ("replicasPerMaster".equals(fieldName)) {
                    deserializedRedisCommonProperties.replicasPerMaster = reader.getNullable(JsonReader::getInt);
                } else if ("replicasPerPrimary".equals(fieldName)) {
                    deserializedRedisCommonProperties.replicasPerPrimary = reader.getNullable(JsonReader::getInt);
                } else if ("tenantSettings".equals(fieldName)) {
                    Map<String, String> tenantSettings = reader.readMap(reader1 -> reader1.getString());
                    deserializedRedisCommonProperties.tenantSettings = tenantSettings;
                } else if ("shardCount".equals(fieldName)) {
                    deserializedRedisCommonProperties.shardCount = reader.getNullable(JsonReader::getInt);
                } else if ("minimumTlsVersion".equals(fieldName)) {
                    deserializedRedisCommonProperties.minimumTlsVersion = TlsVersion.fromString(reader.getString());
                } else if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedRedisCommonProperties.publicNetworkAccess
                        = PublicNetworkAccess.fromString(reader.getString());
                } else if ("updateChannel".equals(fieldName)) {
                    deserializedRedisCommonProperties.updateChannel = UpdateChannel.fromString(reader.getString());
                } else if ("disableAccessKeyAuthentication".equals(fieldName)) {
                    deserializedRedisCommonProperties.disableAccessKeyAuthentication
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("zonalAllocationPolicy".equals(fieldName)) {
                    deserializedRedisCommonProperties.zonalAllocationPolicy
                        = ZonalAllocationPolicy.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRedisCommonProperties;
        });
    }
}
