// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.redis.models.ReplicationRole;
import java.io.IOException;

/**
 * Create properties for a linked server.
 */
@Fluent
public class RedisLinkedServerCreateProperties implements JsonSerializable<RedisLinkedServerCreateProperties> {
    /*
     * Fully qualified resourceId of the linked redis cache.
     */
    private String linkedRedisCacheId;

    /*
     * Location of the linked redis cache.
     */
    private String linkedRedisCacheLocation;

    /*
     * Role of the linked server.
     */
    private ReplicationRole serverRole;

    /*
     * The unchanging DNS name which will always point to current geo-primary cache among the linked redis caches for
     * seamless Geo Failover experience.
     */
    private String geoReplicatedPrimaryHostname;

    /*
     * The changing DNS name that resolves to the current geo-primary cache among the linked redis caches before or
     * after the Geo Failover.
     */
    private String primaryHostname;

    /**
     * Creates an instance of RedisLinkedServerCreateProperties class.
     */
    public RedisLinkedServerCreateProperties() {
    }

    /**
     * Get the linkedRedisCacheId property: Fully qualified resourceId of the linked redis cache.
     * 
     * @return the linkedRedisCacheId value.
     */
    public String linkedRedisCacheId() {
        return this.linkedRedisCacheId;
    }

    /**
     * Set the linkedRedisCacheId property: Fully qualified resourceId of the linked redis cache.
     * 
     * @param linkedRedisCacheId the linkedRedisCacheId value to set.
     * @return the RedisLinkedServerCreateProperties object itself.
     */
    public RedisLinkedServerCreateProperties withLinkedRedisCacheId(String linkedRedisCacheId) {
        this.linkedRedisCacheId = linkedRedisCacheId;
        return this;
    }

    /**
     * Get the linkedRedisCacheLocation property: Location of the linked redis cache.
     * 
     * @return the linkedRedisCacheLocation value.
     */
    public String linkedRedisCacheLocation() {
        return this.linkedRedisCacheLocation;
    }

    /**
     * Set the linkedRedisCacheLocation property: Location of the linked redis cache.
     * 
     * @param linkedRedisCacheLocation the linkedRedisCacheLocation value to set.
     * @return the RedisLinkedServerCreateProperties object itself.
     */
    public RedisLinkedServerCreateProperties withLinkedRedisCacheLocation(String linkedRedisCacheLocation) {
        this.linkedRedisCacheLocation = linkedRedisCacheLocation;
        return this;
    }

    /**
     * Get the serverRole property: Role of the linked server.
     * 
     * @return the serverRole value.
     */
    public ReplicationRole serverRole() {
        return this.serverRole;
    }

    /**
     * Set the serverRole property: Role of the linked server.
     * 
     * @param serverRole the serverRole value to set.
     * @return the RedisLinkedServerCreateProperties object itself.
     */
    public RedisLinkedServerCreateProperties withServerRole(ReplicationRole serverRole) {
        this.serverRole = serverRole;
        return this;
    }

    /**
     * Get the geoReplicatedPrimaryHostname property: The unchanging DNS name which will always point to current
     * geo-primary cache among the linked redis caches for seamless Geo Failover experience.
     * 
     * @return the geoReplicatedPrimaryHostname value.
     */
    public String geoReplicatedPrimaryHostname() {
        return this.geoReplicatedPrimaryHostname;
    }

    /**
     * Set the geoReplicatedPrimaryHostname property: The unchanging DNS name which will always point to current
     * geo-primary cache among the linked redis caches for seamless Geo Failover experience.
     * 
     * @param geoReplicatedPrimaryHostname the geoReplicatedPrimaryHostname value to set.
     * @return the RedisLinkedServerCreateProperties object itself.
     */
    RedisLinkedServerCreateProperties withGeoReplicatedPrimaryHostname(String geoReplicatedPrimaryHostname) {
        this.geoReplicatedPrimaryHostname = geoReplicatedPrimaryHostname;
        return this;
    }

    /**
     * Get the primaryHostname property: The changing DNS name that resolves to the current geo-primary cache among the
     * linked redis caches before or after the Geo Failover.
     * 
     * @return the primaryHostname value.
     */
    public String primaryHostname() {
        return this.primaryHostname;
    }

    /**
     * Set the primaryHostname property: The changing DNS name that resolves to the current geo-primary cache among the
     * linked redis caches before or after the Geo Failover.
     * 
     * @param primaryHostname the primaryHostname value to set.
     * @return the RedisLinkedServerCreateProperties object itself.
     */
    RedisLinkedServerCreateProperties withPrimaryHostname(String primaryHostname) {
        this.primaryHostname = primaryHostname;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (linkedRedisCacheId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property linkedRedisCacheId in model RedisLinkedServerCreateProperties"));
        }
        if (linkedRedisCacheLocation() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property linkedRedisCacheLocation in model RedisLinkedServerCreateProperties"));
        }
        if (serverRole() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property serverRole in model RedisLinkedServerCreateProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RedisLinkedServerCreateProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("linkedRedisCacheId", this.linkedRedisCacheId);
        jsonWriter.writeStringField("linkedRedisCacheLocation", this.linkedRedisCacheLocation);
        jsonWriter.writeStringField("serverRole", this.serverRole == null ? null : this.serverRole.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RedisLinkedServerCreateProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RedisLinkedServerCreateProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RedisLinkedServerCreateProperties.
     */
    public static RedisLinkedServerCreateProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RedisLinkedServerCreateProperties deserializedRedisLinkedServerCreateProperties
                = new RedisLinkedServerCreateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("linkedRedisCacheId".equals(fieldName)) {
                    deserializedRedisLinkedServerCreateProperties.linkedRedisCacheId = reader.getString();
                } else if ("linkedRedisCacheLocation".equals(fieldName)) {
                    deserializedRedisLinkedServerCreateProperties.linkedRedisCacheLocation = reader.getString();
                } else if ("serverRole".equals(fieldName)) {
                    deserializedRedisLinkedServerCreateProperties.serverRole
                        = ReplicationRole.fromString(reader.getString());
                } else if ("geoReplicatedPrimaryHostName".equals(fieldName)) {
                    deserializedRedisLinkedServerCreateProperties.geoReplicatedPrimaryHostname = reader.getString();
                } else if ("primaryHostName".equals(fieldName)) {
                    deserializedRedisLinkedServerCreateProperties.primaryHostname = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRedisLinkedServerCreateProperties;
        });
    }
}
