// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** Patchable properties of the redis cache. */
@Fluent
public final class RedisUpdateProperties extends RedisCommonProperties {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(RedisUpdateProperties.class);

    /*
     * The SKU of the Redis cache to deploy.
     */
    @JsonProperty(value = "sku")
    private Sku sku;

    /**
     * Get the sku property: The SKU of the Redis cache to deploy.
     *
     * @return the sku value.
     */
    public Sku sku() {
        return this.sku;
    }

    /**
     * Set the sku property: The SKU of the Redis cache to deploy.
     *
     * @param sku the sku value to set.
     * @return the RedisUpdateProperties object itself.
     */
    public RedisUpdateProperties withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public RedisUpdateProperties withRedisConfiguration(Map<String, String> redisConfiguration) {
        super.withRedisConfiguration(redisConfiguration);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public RedisUpdateProperties withEnableNonSslPort(Boolean enableNonSslPort) {
        super.withEnableNonSslPort(enableNonSslPort);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public RedisUpdateProperties withReplicasPerMaster(Integer replicasPerMaster) {
        super.withReplicasPerMaster(replicasPerMaster);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public RedisUpdateProperties withTenantSettings(Map<String, String> tenantSettings) {
        super.withTenantSettings(tenantSettings);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public RedisUpdateProperties withShardCount(Integer shardCount) {
        super.withShardCount(shardCount);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public RedisUpdateProperties withMinimumTlsVersion(TlsVersion minimumTlsVersion) {
        super.withMinimumTlsVersion(minimumTlsVersion);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public RedisUpdateProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        super.withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (sku() != null) {
            sku().validate();
        }
    }
}
