// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Provisioning state of access policy.
 */
public final class AccessPolicyProvisioningState extends ExpandableStringEnum<AccessPolicyProvisioningState> {
    /**
     * Static value Updating for AccessPolicyProvisioningState.
     */
    public static final AccessPolicyProvisioningState UPDATING = fromString("Updating");

    /**
     * Static value Succeeded for AccessPolicyProvisioningState.
     */
    public static final AccessPolicyProvisioningState SUCCEEDED = fromString("Succeeded");

    /**
     * Static value Deleting for AccessPolicyProvisioningState.
     */
    public static final AccessPolicyProvisioningState DELETING = fromString("Deleting");

    /**
     * Static value Deleted for AccessPolicyProvisioningState.
     */
    public static final AccessPolicyProvisioningState DELETED = fromString("Deleted");

    /**
     * Static value Canceled for AccessPolicyProvisioningState.
     */
    public static final AccessPolicyProvisioningState CANCELED = fromString("Canceled");

    /**
     * Static value Failed for AccessPolicyProvisioningState.
     */
    public static final AccessPolicyProvisioningState FAILED = fromString("Failed");

    /**
     * Creates a new instance of AccessPolicyProvisioningState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public AccessPolicyProvisioningState() {
    }

    /**
     * Creates or finds a AccessPolicyProvisioningState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding AccessPolicyProvisioningState.
     */
    public static AccessPolicyProvisioningState fromString(String name) {
        return fromString(name, AccessPolicyProvisioningState.class);
    }

    /**
     * Gets known AccessPolicyProvisioningState values.
     * 
     * @return known AccessPolicyProvisioningState values.
     */
    public static Collection<AccessPolicyProvisioningState> values() {
        return values(AccessPolicyProvisioningState.class);
    }
}
