// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Optional: Specifies how availability zones are allocated to the Redis cache. 'Automatic' enables zone redundancy and
 * Azure will automatically select zones based on regional availability and capacity. 'UserDefined' will select
 * availability zones passed in by you using the 'zones' parameter. 'NoZones' will produce a non-zonal cache. If
 * 'zonalAllocationPolicy' is not passed, it will be set to 'UserDefined' when zones are passed in, otherwise, it will
 * be set to 'Automatic' in regions where zones are supported and 'NoZones' in regions where zones are not supported.
 */
public final class ZonalAllocationPolicy extends ExpandableStringEnum<ZonalAllocationPolicy> {
    /**
     * Static value Automatic for ZonalAllocationPolicy.
     */
    public static final ZonalAllocationPolicy AUTOMATIC = fromString("Automatic");

    /**
     * Static value UserDefined for ZonalAllocationPolicy.
     */
    public static final ZonalAllocationPolicy USER_DEFINED = fromString("UserDefined");

    /**
     * Static value NoZones for ZonalAllocationPolicy.
     */
    public static final ZonalAllocationPolicy NO_ZONES = fromString("NoZones");

    /**
     * Creates a new instance of ZonalAllocationPolicy value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ZonalAllocationPolicy() {
    }

    /**
     * Creates or finds a ZonalAllocationPolicy from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ZonalAllocationPolicy.
     */
    public static ZonalAllocationPolicy fromString(String name) {
        return fromString(name, ZonalAllocationPolicy.class);
    }

    /**
     * Gets known ZonalAllocationPolicy values.
     * 
     * @return known ZonalAllocationPolicy values.
     */
    public static Collection<ZonalAllocationPolicy> values() {
        return values(ZonalAllocationPolicy.class);
    }
}
