/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redis.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class RedisFirewallRuleProperties
implements JsonSerializable<RedisFirewallRuleProperties> {
    private String startIp;
    private String endIp;
    private static final ClientLogger LOGGER = new ClientLogger(RedisFirewallRuleProperties.class);

    public String startIp() {
        return this.startIp;
    }

    public RedisFirewallRuleProperties withStartIp(String startIp) {
        this.startIp = startIp;
        return this;
    }

    public String endIp() {
        return this.endIp;
    }

    public RedisFirewallRuleProperties withEndIp(String endIp) {
        this.endIp = endIp;
        return this;
    }

    public void validate() {
        if (this.startIp() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property startIp in model RedisFirewallRuleProperties"));
        }
        if (this.endIp() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property endIp in model RedisFirewallRuleProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startIP", this.startIp);
        jsonWriter.writeStringField("endIP", this.endIp);
        return jsonWriter.writeEndObject();
    }

    public static RedisFirewallRuleProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RedisFirewallRuleProperties)jsonReader.readObject(reader -> {
            RedisFirewallRuleProperties deserializedRedisFirewallRuleProperties = new RedisFirewallRuleProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startIP".equals(fieldName)) {
                    deserializedRedisFirewallRuleProperties.startIp = reader.getString();
                    continue;
                }
                if ("endIP".equals(fieldName)) {
                    deserializedRedisFirewallRuleProperties.endIp = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRedisFirewallRuleProperties;
        });
    }
}

