/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redis.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.redis.models.PublicNetworkAccess;
import com.azure.resourcemanager.redis.models.RedisCommonProperties;
import com.azure.resourcemanager.redis.models.Sku;
import com.azure.resourcemanager.redis.models.TlsVersion;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class RedisUpdateProperties
extends RedisCommonProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(RedisUpdateProperties.class);
    @JsonProperty(value="sku")
    private Sku sku;

    public Sku sku() {
        return this.sku;
    }

    public RedisUpdateProperties withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    @Override
    public RedisUpdateProperties withRedisConfiguration(Map<String, String> redisConfiguration) {
        super.withRedisConfiguration(redisConfiguration);
        return this;
    }

    @Override
    public RedisUpdateProperties withEnableNonSslPort(Boolean enableNonSslPort) {
        super.withEnableNonSslPort(enableNonSslPort);
        return this;
    }

    @Override
    public RedisUpdateProperties withReplicasPerMaster(Integer replicasPerMaster) {
        super.withReplicasPerMaster(replicasPerMaster);
        return this;
    }

    @Override
    public RedisUpdateProperties withTenantSettings(Map<String, String> tenantSettings) {
        super.withTenantSettings(tenantSettings);
        return this;
    }

    @Override
    public RedisUpdateProperties withShardCount(Integer shardCount) {
        super.withShardCount(shardCount);
        return this;
    }

    @Override
    public RedisUpdateProperties withMinimumTlsVersion(TlsVersion minimumTlsVersion) {
        super.withMinimumTlsVersion(minimumTlsVersion);
        return this;
    }

    @Override
    public RedisUpdateProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        super.withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.sku() != null) {
            this.sku().validate();
        }
    }
}

