/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redisenterprise;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.redisenterprise.fluent.RedisEnterpriseManagementClient;
import com.azure.resourcemanager.redisenterprise.implementation.DatabasesImpl;
import com.azure.resourcemanager.redisenterprise.implementation.OperationsImpl;
import com.azure.resourcemanager.redisenterprise.implementation.OperationsStatusImpl;
import com.azure.resourcemanager.redisenterprise.implementation.PrivateEndpointConnectionsImpl;
import com.azure.resourcemanager.redisenterprise.implementation.PrivateLinkResourcesImpl;
import com.azure.resourcemanager.redisenterprise.implementation.RedisEnterpriseManagementClientBuilder;
import com.azure.resourcemanager.redisenterprise.implementation.RedisEnterprisesImpl;
import com.azure.resourcemanager.redisenterprise.models.Databases;
import com.azure.resourcemanager.redisenterprise.models.Operations;
import com.azure.resourcemanager.redisenterprise.models.OperationsStatus;
import com.azure.resourcemanager.redisenterprise.models.PrivateEndpointConnections;
import com.azure.resourcemanager.redisenterprise.models.PrivateLinkResources;
import com.azure.resourcemanager.redisenterprise.models.RedisEnterprises;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class RedisEnterpriseManager {
    private Operations operations;
    private OperationsStatus operationsStatus;
    private RedisEnterprises redisEnterprises;
    private Databases databases;
    private PrivateEndpointConnections privateEndpointConnections;
    private PrivateLinkResources privateLinkResources;
    private final RedisEnterpriseManagementClient clientObject;

    private RedisEnterpriseManager(HttpPipeline httpPipeline, AzureProfile profile, Duration defaultPollInterval) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        this.clientObject = new RedisEnterpriseManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).defaultPollInterval(defaultPollInterval).buildClient();
    }

    public static RedisEnterpriseManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return RedisEnterpriseManager.configure().authenticate(credential, profile);
    }

    public static Configurable configure() {
        return new Configurable();
    }

    public Operations operations() {
        if (this.operations == null) {
            this.operations = new OperationsImpl(this.clientObject.getOperations(), this);
        }
        return this.operations;
    }

    public OperationsStatus operationsStatus() {
        if (this.operationsStatus == null) {
            this.operationsStatus = new OperationsStatusImpl(this.clientObject.getOperationsStatus(), this);
        }
        return this.operationsStatus;
    }

    public RedisEnterprises redisEnterprises() {
        if (this.redisEnterprises == null) {
            this.redisEnterprises = new RedisEnterprisesImpl(this.clientObject.getRedisEnterprises(), this);
        }
        return this.redisEnterprises;
    }

    public Databases databases() {
        if (this.databases == null) {
            this.databases = new DatabasesImpl(this.clientObject.getDatabases(), this);
        }
        return this.databases;
    }

    public PrivateEndpointConnections privateEndpointConnections() {
        if (this.privateEndpointConnections == null) {
            this.privateEndpointConnections = new PrivateEndpointConnectionsImpl(this.clientObject.getPrivateEndpointConnections(), this);
        }
        return this.privateEndpointConnections;
    }

    public PrivateLinkResources privateLinkResources() {
        if (this.privateLinkResources == null) {
            this.privateLinkResources = new PrivateLinkResourcesImpl(this.clientObject.getPrivateLinkResources(), this);
        }
        return this.privateLinkResources;
    }

    public RedisEnterpriseManagementClient serviceClient() {
        return this.clientObject;
    }

    public static final class Configurable {
        private final ClientLogger logger = new ClientLogger(Configurable.class);
        private HttpClient httpClient;
        private HttpLogOptions httpLogOptions;
        private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        private RetryPolicy retryPolicy;
        private Duration defaultPollInterval;

        private Configurable() {
        }

        public Configurable withHttpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
            return this;
        }

        public Configurable withLogOptions(HttpLogOptions httpLogOptions) {
            this.httpLogOptions = Objects.requireNonNull(httpLogOptions, "'httpLogOptions' cannot be null.");
            return this;
        }

        public Configurable withPolicy(HttpPipelinePolicy policy) {
            this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
            return this;
        }

        public Configurable withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
            return this;
        }

        public Configurable withDefaultPollInterval(Duration defaultPollInterval) {
            this.defaultPollInterval = Objects.requireNonNull(defaultPollInterval, "'retryPolicy' cannot be null.");
            if (this.defaultPollInterval.isNegative()) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'httpPipeline' cannot be negative"));
            }
            return this;
        }

        public RedisEnterpriseManager authenticate(TokenCredential credential, AzureProfile profile) {
            Objects.requireNonNull(credential, "'credential' cannot be null.");
            Objects.requireNonNull(profile, "'profile' cannot be null.");
            StringBuilder userAgentBuilder = new StringBuilder();
            userAgentBuilder.append("azsdk-java").append("-").append("com.azure.resourcemanager.redisenterprise").append("/").append("1.0.0");
            if (!((Boolean)Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", (Object)false)).booleanValue()) {
                userAgentBuilder.append(" (").append(Configuration.getGlobalConfiguration().get("java.version")).append("; ").append(Configuration.getGlobalConfiguration().get("os.name")).append("; ").append(Configuration.getGlobalConfiguration().get("os.version")).append("; auto-generated)");
            } else {
                userAgentBuilder.append(" (auto-generated)");
            }
            if (this.retryPolicy == null) {
                this.retryPolicy = new RetryPolicy("Retry-After", ChronoUnit.SECONDS);
            }
            ArrayList<Object> policies = new ArrayList<Object>();
            policies.add(new UserAgentPolicy(userAgentBuilder.toString()));
            policies.add(new RequestIdPolicy());
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(this.retryPolicy);
            policies.add(new AddDatePolicy());
            policies.add(new BearerTokenAuthenticationPolicy(credential, new String[]{profile.getEnvironment().getManagementEndpoint() + "/.default"}));
            policies.addAll(this.policies);
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(this.httpLogOptions));
            HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(this.httpClient).policies(policies.toArray(new HttpPipelinePolicy[0])).build();
            return new RedisEnterpriseManager(httpPipeline, profile, this.defaultPollInterval);
        }
    }
}

