/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redisenterprise.implementation;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.redisenterprise.RedisEnterpriseManager;
import com.azure.resourcemanager.redisenterprise.fluent.models.ClusterInner;
import com.azure.resourcemanager.redisenterprise.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.redisenterprise.implementation.PrivateEndpointConnectionImpl;
import com.azure.resourcemanager.redisenterprise.implementation.Utils;
import com.azure.resourcemanager.redisenterprise.models.Cluster;
import com.azure.resourcemanager.redisenterprise.models.ClusterUpdate;
import com.azure.resourcemanager.redisenterprise.models.PrivateEndpointConnection;
import com.azure.resourcemanager.redisenterprise.models.ProvisioningState;
import com.azure.resourcemanager.redisenterprise.models.ResourceState;
import com.azure.resourcemanager.redisenterprise.models.Sku;
import com.azure.resourcemanager.redisenterprise.models.TlsVersion;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class ClusterImpl
implements Cluster,
Cluster.Definition,
Cluster.Update {
    private ClusterInner innerObject;
    private final RedisEnterpriseManager serviceManager;
    private String resourceGroupName;
    private String clusterName;
    private ClusterUpdate updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public Sku sku() {
        return this.innerModel().sku();
    }

    @Override
    public List<String> zones() {
        List<String> inner = this.innerModel().zones();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public TlsVersion minimumTlsVersion() {
        return this.innerModel().minimumTlsVersion();
    }

    @Override
    public String hostname() {
        return this.innerModel().hostname();
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public ResourceState resourceState() {
        return this.innerModel().resourceState();
    }

    @Override
    public String redisVersion() {
        return this.innerModel().redisVersion();
    }

    @Override
    public List<PrivateEndpointConnection> privateEndpointConnections() {
        List<PrivateEndpointConnectionInner> inner = this.innerModel().privateEndpointConnections();
        if (inner != null) {
            return Collections.unmodifiableList(inner.stream().map(inner1 -> new PrivateEndpointConnectionImpl((PrivateEndpointConnectionInner)((Object)inner1), this.manager())).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public ClusterInner innerModel() {
        return this.innerObject;
    }

    private RedisEnterpriseManager manager() {
        return this.serviceManager;
    }

    @Override
    public ClusterImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Cluster create() {
        this.innerObject = this.serviceManager.serviceClient().getRedisEnterprises().create(this.resourceGroupName, this.clusterName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Cluster create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getRedisEnterprises().create(this.resourceGroupName, this.clusterName, this.innerModel(), context);
        return this;
    }

    ClusterImpl(String name, RedisEnterpriseManager serviceManager) {
        this.innerObject = new ClusterInner();
        this.serviceManager = serviceManager;
        this.clusterName = name;
    }

    @Override
    public ClusterImpl update() {
        this.updateParameters = new ClusterUpdate();
        return this;
    }

    @Override
    public Cluster apply() {
        this.innerObject = this.serviceManager.serviceClient().getRedisEnterprises().update(this.resourceGroupName, this.clusterName, this.updateParameters, Context.NONE);
        return this;
    }

    @Override
    public Cluster apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getRedisEnterprises().update(this.resourceGroupName, this.clusterName, this.updateParameters, context);
        return this;
    }

    ClusterImpl(ClusterInner innerObject, RedisEnterpriseManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.clusterName = Utils.getValueFromIdByName(innerObject.id(), "redisEnterprise");
    }

    @Override
    public Cluster refresh() {
        this.innerObject = (ClusterInner)((Object)this.serviceManager.serviceClient().getRedisEnterprises().getByResourceGroupWithResponse(this.resourceGroupName, this.clusterName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Cluster refresh(Context context) {
        this.innerObject = (ClusterInner)((Object)this.serviceManager.serviceClient().getRedisEnterprises().getByResourceGroupWithResponse(this.resourceGroupName, this.clusterName, context).getValue());
        return this;
    }

    @Override
    public ClusterImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ClusterImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ClusterImpl withSku(Sku sku) {
        if (this.isInCreateMode()) {
            this.innerModel().withSku(sku);
            return this;
        }
        this.updateParameters.withSku(sku);
        return this;
    }

    @Override
    public ClusterImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    @Override
    public ClusterImpl withZones(List<String> zones) {
        this.innerModel().withZones(zones);
        return this;
    }

    @Override
    public ClusterImpl withMinimumTlsVersion(TlsVersion minimumTlsVersion) {
        if (this.isInCreateMode()) {
            this.innerModel().withMinimumTlsVersion(minimumTlsVersion);
            return this;
        }
        this.updateParameters.withMinimumTlsVersion(minimumTlsVersion);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

