/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redisenterprise.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.redisenterprise.RedisEnterpriseManager;
import com.azure.resourcemanager.redisenterprise.fluent.models.DatabaseInner;
import com.azure.resourcemanager.redisenterprise.implementation.Utils;
import com.azure.resourcemanager.redisenterprise.models.AccessKeys;
import com.azure.resourcemanager.redisenterprise.models.ClusteringPolicy;
import com.azure.resourcemanager.redisenterprise.models.Database;
import com.azure.resourcemanager.redisenterprise.models.DatabaseUpdate;
import com.azure.resourcemanager.redisenterprise.models.EvictionPolicy;
import com.azure.resourcemanager.redisenterprise.models.ExportClusterParameters;
import com.azure.resourcemanager.redisenterprise.models.ImportClusterParameters;
import com.azure.resourcemanager.redisenterprise.models.Module;
import com.azure.resourcemanager.redisenterprise.models.Persistence;
import com.azure.resourcemanager.redisenterprise.models.Protocol;
import com.azure.resourcemanager.redisenterprise.models.ProvisioningState;
import com.azure.resourcemanager.redisenterprise.models.RegenerateKeyParameters;
import com.azure.resourcemanager.redisenterprise.models.ResourceState;
import java.util.Collections;
import java.util.List;

public final class DatabaseImpl
implements Database,
Database.Definition,
Database.Update {
    private DatabaseInner innerObject;
    private final RedisEnterpriseManager serviceManager;
    private String resourceGroupName;
    private String clusterName;
    private String databaseName;
    private DatabaseUpdate updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public Protocol clientProtocol() {
        return this.innerModel().clientProtocol();
    }

    @Override
    public Integer port() {
        return this.innerModel().port();
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public ResourceState resourceState() {
        return this.innerModel().resourceState();
    }

    @Override
    public ClusteringPolicy clusteringPolicy() {
        return this.innerModel().clusteringPolicy();
    }

    @Override
    public EvictionPolicy evictionPolicy() {
        return this.innerModel().evictionPolicy();
    }

    @Override
    public Persistence persistence() {
        return this.innerModel().persistence();
    }

    @Override
    public List<Module> modules() {
        List<Module> inner = this.innerModel().modules();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public DatabaseInner innerModel() {
        return this.innerObject;
    }

    private RedisEnterpriseManager manager() {
        return this.serviceManager;
    }

    @Override
    public DatabaseImpl withExistingRedisEnterprise(String resourceGroupName, String clusterName) {
        this.resourceGroupName = resourceGroupName;
        this.clusterName = clusterName;
        return this;
    }

    @Override
    public Database create() {
        this.innerObject = this.serviceManager.serviceClient().getDatabases().create(this.resourceGroupName, this.clusterName, this.databaseName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Database create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDatabases().create(this.resourceGroupName, this.clusterName, this.databaseName, this.innerModel(), context);
        return this;
    }

    DatabaseImpl(String name, RedisEnterpriseManager serviceManager) {
        this.innerObject = new DatabaseInner();
        this.serviceManager = serviceManager;
        this.databaseName = name;
    }

    @Override
    public DatabaseImpl update() {
        this.updateParameters = new DatabaseUpdate();
        return this;
    }

    @Override
    public Database apply() {
        this.innerObject = this.serviceManager.serviceClient().getDatabases().update(this.resourceGroupName, this.clusterName, this.databaseName, this.updateParameters, Context.NONE);
        return this;
    }

    @Override
    public Database apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDatabases().update(this.resourceGroupName, this.clusterName, this.databaseName, this.updateParameters, context);
        return this;
    }

    DatabaseImpl(DatabaseInner innerObject, RedisEnterpriseManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.clusterName = Utils.getValueFromIdByName(innerObject.id(), "redisEnterprise");
        this.databaseName = Utils.getValueFromIdByName(innerObject.id(), "databases");
    }

    @Override
    public Database refresh() {
        this.innerObject = (DatabaseInner)((Object)this.serviceManager.serviceClient().getDatabases().getWithResponse(this.resourceGroupName, this.clusterName, this.databaseName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Database refresh(Context context) {
        this.innerObject = (DatabaseInner)((Object)this.serviceManager.serviceClient().getDatabases().getWithResponse(this.resourceGroupName, this.clusterName, this.databaseName, context).getValue());
        return this;
    }

    @Override
    public AccessKeys listKeys() {
        return this.serviceManager.databases().listKeys(this.resourceGroupName, this.clusterName, this.databaseName);
    }

    @Override
    public Response<AccessKeys> listKeysWithResponse(Context context) {
        return this.serviceManager.databases().listKeysWithResponse(this.resourceGroupName, this.clusterName, this.databaseName, context);
    }

    @Override
    public AccessKeys regenerateKey(RegenerateKeyParameters parameters) {
        return this.serviceManager.databases().regenerateKey(this.resourceGroupName, this.clusterName, this.databaseName, parameters);
    }

    @Override
    public AccessKeys regenerateKey(RegenerateKeyParameters parameters, Context context) {
        return this.serviceManager.databases().regenerateKey(this.resourceGroupName, this.clusterName, this.databaseName, parameters, context);
    }

    @Override
    public void importMethod(ImportClusterParameters parameters) {
        this.serviceManager.databases().importMethod(this.resourceGroupName, this.clusterName, this.databaseName, parameters);
    }

    @Override
    public void importMethod(ImportClusterParameters parameters, Context context) {
        this.serviceManager.databases().importMethod(this.resourceGroupName, this.clusterName, this.databaseName, parameters, context);
    }

    @Override
    public void export(ExportClusterParameters parameters) {
        this.serviceManager.databases().export(this.resourceGroupName, this.clusterName, this.databaseName, parameters);
    }

    @Override
    public void export(ExportClusterParameters parameters, Context context) {
        this.serviceManager.databases().export(this.resourceGroupName, this.clusterName, this.databaseName, parameters, context);
    }

    @Override
    public DatabaseImpl withClientProtocol(Protocol clientProtocol) {
        if (this.isInCreateMode()) {
            this.innerModel().withClientProtocol(clientProtocol);
            return this;
        }
        this.updateParameters.withClientProtocol(clientProtocol);
        return this;
    }

    @Override
    public DatabaseImpl withPort(Integer port) {
        this.innerModel().withPort(port);
        return this;
    }

    @Override
    public DatabaseImpl withClusteringPolicy(ClusteringPolicy clusteringPolicy) {
        if (this.isInCreateMode()) {
            this.innerModel().withClusteringPolicy(clusteringPolicy);
            return this;
        }
        this.updateParameters.withClusteringPolicy(clusteringPolicy);
        return this;
    }

    @Override
    public DatabaseImpl withEvictionPolicy(EvictionPolicy evictionPolicy) {
        if (this.isInCreateMode()) {
            this.innerModel().withEvictionPolicy(evictionPolicy);
            return this;
        }
        this.updateParameters.withEvictionPolicy(evictionPolicy);
        return this;
    }

    @Override
    public DatabaseImpl withPersistence(Persistence persistence) {
        if (this.isInCreateMode()) {
            this.innerModel().withPersistence(persistence);
            return this;
        }
        this.updateParameters.withPersistence(persistence);
        return this;
    }

    @Override
    public DatabaseImpl withModules(List<Module> modules) {
        if (this.isInCreateMode()) {
            this.innerModel().withModules(modules);
            return this;
        }
        this.updateParameters.withModules(modules);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

