/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redisenterprise.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.redisenterprise.RedisEnterpriseManager;
import com.azure.resourcemanager.redisenterprise.fluent.OperationsClient;
import com.azure.resourcemanager.redisenterprise.fluent.models.OperationInner;
import com.azure.resourcemanager.redisenterprise.implementation.OperationImpl;
import com.azure.resourcemanager.redisenterprise.implementation.Utils;
import com.azure.resourcemanager.redisenterprise.models.Operation;
import com.azure.resourcemanager.redisenterprise.models.Operations;
import com.fasterxml.jackson.annotation.JsonIgnore;

public final class OperationsImpl
implements Operations {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(OperationsImpl.class);
    private final OperationsClient innerClient;
    private final RedisEnterpriseManager serviceManager;

    public OperationsImpl(OperationsClient innerClient, RedisEnterpriseManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Operation> list() {
        PagedIterable<OperationInner> inner = this.serviceClient().list();
        return Utils.mapPage(inner, inner1 -> new OperationImpl((OperationInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<Operation> list(Context context) {
        PagedIterable<OperationInner> inner = this.serviceClient().list(context);
        return Utils.mapPage(inner, inner1 -> new OperationImpl((OperationInner)inner1, this.manager()));
    }

    private OperationsClient serviceClient() {
        return this.innerClient;
    }

    private RedisEnterpriseManager manager() {
        return this.serviceManager;
    }
}

