/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redisenterprise.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.redisenterprise.fluent.PrivateEndpointConnectionsClient;
import com.azure.resourcemanager.redisenterprise.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.redisenterprise.implementation.RedisEnterpriseManagementClientImpl;
import com.azure.resourcemanager.redisenterprise.models.PrivateEndpointConnectionListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class PrivateEndpointConnectionsClientImpl
implements PrivateEndpointConnectionsClient {
    private final ClientLogger logger = new ClientLogger(PrivateEndpointConnectionsClientImpl.class);
    private final PrivateEndpointConnectionsService service;
    private final RedisEnterpriseManagementClientImpl client;

    PrivateEndpointConnectionsClientImpl(RedisEnterpriseManagementClientImpl client) {
        this.service = (PrivateEndpointConnectionsService)RestProxy.create(PrivateEndpointConnectionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<PrivateEndpointConnectionInner>> listSinglePageAsync(String resourceGroupName, String clusterName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceGroupName, clusterName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateEndpointConnectionListResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<PrivateEndpointConnectionInner>> listSinglePageAsync(String resourceGroupName, String clusterName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceGroupName, clusterName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateEndpointConnectionListResult)res.getValue()).value(), null, null));
    }

    private PagedFlux<PrivateEndpointConnectionInner> listAsync(String resourceGroupName, String clusterName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, clusterName));
    }

    private PagedFlux<PrivateEndpointConnectionInner> listAsync(String resourceGroupName, String clusterName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, clusterName, context));
    }

    @Override
    public PagedIterable<PrivateEndpointConnectionInner> list(String resourceGroupName, String clusterName) {
        return new PagedIterable(this.listAsync(resourceGroupName, clusterName));
    }

    @Override
    public PagedIterable<PrivateEndpointConnectionInner> list(String resourceGroupName, String clusterName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, clusterName, context));
    }

    private Mono<Response<PrivateEndpointConnectionInner>> getWithResponseAsync(String resourceGroupName, String clusterName, String privateEndpointConnectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, clusterName, privateEndpointConnectionName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<PrivateEndpointConnectionInner>> getWithResponseAsync(String resourceGroupName, String clusterName, String privateEndpointConnectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, clusterName, privateEndpointConnectionName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    private Mono<PrivateEndpointConnectionInner> getAsync(String resourceGroupName, String clusterName, String privateEndpointConnectionName) {
        return this.getWithResponseAsync(resourceGroupName, clusterName, privateEndpointConnectionName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((PrivateEndpointConnectionInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public PrivateEndpointConnectionInner get(String resourceGroupName, String clusterName, String privateEndpointConnectionName) {
        return (PrivateEndpointConnectionInner)((Object)this.getAsync(resourceGroupName, clusterName, privateEndpointConnectionName).block());
    }

    @Override
    public Response<PrivateEndpointConnectionInner> getWithResponse(String resourceGroupName, String clusterName, String privateEndpointConnectionName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, clusterName, privateEndpointConnectionName, context).block();
    }

    private Mono<Response<Flux<ByteBuffer>>> putWithResponseAsync(String resourceGroupName, String clusterName, String privateEndpointConnectionName, PrivateEndpointConnectionInner properties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (properties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.put(this.client.getEndpoint(), resourceGroupName, clusterName, this.client.getApiVersion(), this.client.getSubscriptionId(), privateEndpointConnectionName, properties, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> putWithResponseAsync(String resourceGroupName, String clusterName, String privateEndpointConnectionName, PrivateEndpointConnectionInner properties, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (properties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.put(this.client.getEndpoint(), resourceGroupName, clusterName, this.client.getApiVersion(), this.client.getSubscriptionId(), privateEndpointConnectionName, properties, "application/json", context);
    }

    private PollerFlux<PollResult<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner> beginPutAsync(String resourceGroupName, String clusterName, String privateEndpointConnectionName, PrivateEndpointConnectionInner properties) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.putWithResponseAsync(resourceGroupName, clusterName, privateEndpointConnectionName, properties);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)PrivateEndpointConnectionInner.class), (Type)((Object)PrivateEndpointConnectionInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner> beginPutAsync(String resourceGroupName, String clusterName, String privateEndpointConnectionName, PrivateEndpointConnectionInner properties, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.putWithResponseAsync(resourceGroupName, clusterName, privateEndpointConnectionName, properties, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)PrivateEndpointConnectionInner.class), (Type)((Object)PrivateEndpointConnectionInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner> beginPut(String resourceGroupName, String clusterName, String privateEndpointConnectionName, PrivateEndpointConnectionInner properties) {
        return this.beginPutAsync(resourceGroupName, clusterName, privateEndpointConnectionName, properties).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner> beginPut(String resourceGroupName, String clusterName, String privateEndpointConnectionName, PrivateEndpointConnectionInner properties, Context context) {
        return this.beginPutAsync(resourceGroupName, clusterName, privateEndpointConnectionName, properties, context).getSyncPoller();
    }

    private Mono<PrivateEndpointConnectionInner> putAsync(String resourceGroupName, String clusterName, String privateEndpointConnectionName, PrivateEndpointConnectionInner properties) {
        return this.beginPutAsync(resourceGroupName, clusterName, privateEndpointConnectionName, properties).last().flatMap(this.client::getLroFinalResultOrError);
    }

    private Mono<PrivateEndpointConnectionInner> putAsync(String resourceGroupName, String clusterName, String privateEndpointConnectionName, PrivateEndpointConnectionInner properties, Context context) {
        return this.beginPutAsync(resourceGroupName, clusterName, privateEndpointConnectionName, properties, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    public PrivateEndpointConnectionInner put(String resourceGroupName, String clusterName, String privateEndpointConnectionName, PrivateEndpointConnectionInner properties) {
        return (PrivateEndpointConnectionInner)((Object)this.putAsync(resourceGroupName, clusterName, privateEndpointConnectionName, properties).block());
    }

    @Override
    public PrivateEndpointConnectionInner put(String resourceGroupName, String clusterName, String privateEndpointConnectionName, PrivateEndpointConnectionInner properties, Context context) {
        return (PrivateEndpointConnectionInner)((Object)this.putAsync(resourceGroupName, clusterName, privateEndpointConnectionName, properties, context).block());
    }

    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String clusterName, String privateEndpointConnectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, clusterName, this.client.getApiVersion(), this.client.getSubscriptionId(), privateEndpointConnectionName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String clusterName, String privateEndpointConnectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, clusterName, this.client.getApiVersion(), this.client.getSubscriptionId(), privateEndpointConnectionName, "application/json", context);
    }

    private Mono<Void> deleteAsync(String resourceGroupName, String clusterName, String privateEndpointConnectionName) {
        return this.deleteWithResponseAsync(resourceGroupName, clusterName, privateEndpointConnectionName).flatMap(res -> Mono.empty());
    }

    @Override
    public void delete(String resourceGroupName, String clusterName, String privateEndpointConnectionName) {
        this.deleteAsync(resourceGroupName, clusterName, privateEndpointConnectionName).block();
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String clusterName, String privateEndpointConnectionName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, clusterName, privateEndpointConnectionName, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="RedisEnterpriseManag")
    private static interface PrivateEndpointConnectionsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/redisEnterprise/{clusterName}/privateEndpointConnections")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PrivateEndpointConnectionListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="clusterName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/redisEnterprise/{clusterName}/privateEndpointConnections/{privateEndpointConnectionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PrivateEndpointConnectionInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="clusterName") String var3, @PathParam(value="privateEndpointConnectionName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/redisEnterprise/{clusterName}/privateEndpointConnections/{privateEndpointConnectionName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> put(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="clusterName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="privateEndpointConnectionName") String var6, @BodyParam(value="application/json") PrivateEndpointConnectionInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/redisEnterprise/{clusterName}/privateEndpointConnections/{privateEndpointConnectionName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="clusterName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="privateEndpointConnectionName") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

