/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redisenterprise.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.redisenterprise.RedisEnterpriseManager;
import com.azure.resourcemanager.redisenterprise.fluent.PrivateEndpointConnectionsClient;
import com.azure.resourcemanager.redisenterprise.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.redisenterprise.implementation.PrivateEndpointConnectionImpl;
import com.azure.resourcemanager.redisenterprise.implementation.Utils;
import com.azure.resourcemanager.redisenterprise.models.PrivateEndpointConnection;
import com.azure.resourcemanager.redisenterprise.models.PrivateEndpointConnections;
import com.fasterxml.jackson.annotation.JsonIgnore;

public final class PrivateEndpointConnectionsImpl
implements PrivateEndpointConnections {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(PrivateEndpointConnectionsImpl.class);
    private final PrivateEndpointConnectionsClient innerClient;
    private final RedisEnterpriseManager serviceManager;

    public PrivateEndpointConnectionsImpl(PrivateEndpointConnectionsClient innerClient, RedisEnterpriseManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<PrivateEndpointConnection> list(String resourceGroupName, String clusterName) {
        PagedIterable<PrivateEndpointConnectionInner> inner = this.serviceClient().list(resourceGroupName, clusterName);
        return Utils.mapPage(inner, inner1 -> new PrivateEndpointConnectionImpl((PrivateEndpointConnectionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PrivateEndpointConnection> list(String resourceGroupName, String clusterName, Context context) {
        PagedIterable<PrivateEndpointConnectionInner> inner = this.serviceClient().list(resourceGroupName, clusterName, context);
        return Utils.mapPage(inner, inner1 -> new PrivateEndpointConnectionImpl((PrivateEndpointConnectionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PrivateEndpointConnection get(String resourceGroupName, String clusterName, String privateEndpointConnectionName) {
        PrivateEndpointConnectionInner inner = this.serviceClient().get(resourceGroupName, clusterName, privateEndpointConnectionName);
        if (inner != null) {
            return new PrivateEndpointConnectionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<PrivateEndpointConnection> getWithResponse(String resourceGroupName, String clusterName, String privateEndpointConnectionName, Context context) {
        Response<PrivateEndpointConnectionInner> inner = this.serviceClient().getWithResponse(resourceGroupName, clusterName, privateEndpointConnectionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PrivateEndpointConnectionImpl((PrivateEndpointConnectionInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String clusterName, String privateEndpointConnectionName) {
        this.serviceClient().delete(resourceGroupName, clusterName, privateEndpointConnectionName);
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String clusterName, String privateEndpointConnectionName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, clusterName, privateEndpointConnectionName, context);
    }

    @Override
    public PrivateEndpointConnection getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = Utils.getValueFromIdByName(id, "redisEnterprise");
        if (clusterName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'redisEnterprise'.", id)));
        }
        String privateEndpointConnectionName = Utils.getValueFromIdByName(id, "privateEndpointConnections");
        if (privateEndpointConnectionName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'privateEndpointConnections'.", id)));
        }
        return (PrivateEndpointConnection)this.getWithResponse(resourceGroupName, clusterName, privateEndpointConnectionName, Context.NONE).getValue();
    }

    @Override
    public Response<PrivateEndpointConnection> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = Utils.getValueFromIdByName(id, "redisEnterprise");
        if (clusterName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'redisEnterprise'.", id)));
        }
        String privateEndpointConnectionName = Utils.getValueFromIdByName(id, "privateEndpointConnections");
        if (privateEndpointConnectionName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'privateEndpointConnections'.", id)));
        }
        return this.getWithResponse(resourceGroupName, clusterName, privateEndpointConnectionName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = Utils.getValueFromIdByName(id, "redisEnterprise");
        if (clusterName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'redisEnterprise'.", id)));
        }
        String privateEndpointConnectionName = Utils.getValueFromIdByName(id, "privateEndpointConnections");
        if (privateEndpointConnectionName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'privateEndpointConnections'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, clusterName, privateEndpointConnectionName, Context.NONE).getValue();
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = Utils.getValueFromIdByName(id, "redisEnterprise");
        if (clusterName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'redisEnterprise'.", id)));
        }
        String privateEndpointConnectionName = Utils.getValueFromIdByName(id, "privateEndpointConnections");
        if (privateEndpointConnectionName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'privateEndpointConnections'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, clusterName, privateEndpointConnectionName, context);
    }

    private PrivateEndpointConnectionsClient serviceClient() {
        return this.innerClient;
    }

    private RedisEnterpriseManager manager() {
        return this.serviceManager;
    }

    @Override
    public PrivateEndpointConnectionImpl define(String name) {
        return new PrivateEndpointConnectionImpl(name, this.manager());
    }
}

