/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redisenterprise.models;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.redisenterprise.fluent.models.ClusterInner;
import com.azure.resourcemanager.redisenterprise.models.PrivateEndpointConnection;
import com.azure.resourcemanager.redisenterprise.models.ProvisioningState;
import com.azure.resourcemanager.redisenterprise.models.ResourceState;
import com.azure.resourcemanager.redisenterprise.models.Sku;
import com.azure.resourcemanager.redisenterprise.models.TlsVersion;
import java.util.List;
import java.util.Map;

public interface Cluster {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public Sku sku();

    public List<String> zones();

    public TlsVersion minimumTlsVersion();

    public String hostname();

    public ProvisioningState provisioningState();

    public ResourceState resourceState();

    public String redisVersion();

    public List<PrivateEndpointConnection> privateEndpointConnections();

    public Region region();

    public String regionName();

    public ClusterInner innerModel();

    public Update update();

    public Cluster refresh();

    public Cluster refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithMinimumTlsVersion {
            public Update withMinimumTlsVersion(TlsVersion var1);
        }

        public static interface WithSku {
            public Update withSku(Sku var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithSku,
    UpdateStages.WithMinimumTlsVersion {
        public Cluster apply();

        public Cluster apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithMinimumTlsVersion {
            public WithCreate withMinimumTlsVersion(TlsVersion var1);
        }

        public static interface WithZones {
            public WithCreate withZones(List<String> var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithZones,
        WithMinimumTlsVersion {
            public Cluster create();

            public Cluster create(Context var1);
        }

        public static interface WithSku {
            public WithCreate withSku(Sku var1);
        }

        public static interface WithResourceGroup {
            public WithSku withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithSku,
    DefinitionStages.WithCreate {
    }
}

