/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redisenterprise.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.redisenterprise.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.redisenterprise.models.ProvisioningState;
import com.azure.resourcemanager.redisenterprise.models.ResourceState;
import com.azure.resourcemanager.redisenterprise.models.Sku;
import com.azure.resourcemanager.redisenterprise.models.TlsVersion;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class ClusterUpdate {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ClusterUpdate.class);
    @JsonProperty(value="sku")
    private Sku sku;
    @JsonProperty(value="tags")
    private Map<String, String> tags;
    @JsonProperty(value="properties.minimumTlsVersion")
    private TlsVersion minimumTlsVersion;
    @JsonProperty(value="properties.hostName", access=JsonProperty.Access.WRITE_ONLY)
    private String hostname;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.resourceState", access=JsonProperty.Access.WRITE_ONLY)
    private ResourceState resourceState;
    @JsonProperty(value="properties.redisVersion", access=JsonProperty.Access.WRITE_ONLY)
    private String redisVersion;
    @JsonProperty(value="properties.privateEndpointConnections", access=JsonProperty.Access.WRITE_ONLY)
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;

    public Sku sku() {
        return this.sku;
    }

    public ClusterUpdate withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ClusterUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public TlsVersion minimumTlsVersion() {
        return this.minimumTlsVersion;
    }

    public ClusterUpdate withMinimumTlsVersion(TlsVersion minimumTlsVersion) {
        this.minimumTlsVersion = minimumTlsVersion;
        return this;
    }

    public String hostname() {
        return this.hostname;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public ResourceState resourceState() {
        return this.resourceState;
    }

    public String redisVersion() {
        return this.redisVersion;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
    }
}

