/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redisenterprise.models;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.redisenterprise.fluent.models.DatabaseInner;
import com.azure.resourcemanager.redisenterprise.models.AccessKeys;
import com.azure.resourcemanager.redisenterprise.models.ClusteringPolicy;
import com.azure.resourcemanager.redisenterprise.models.EvictionPolicy;
import com.azure.resourcemanager.redisenterprise.models.ExportClusterParameters;
import com.azure.resourcemanager.redisenterprise.models.ImportClusterParameters;
import com.azure.resourcemanager.redisenterprise.models.Module;
import com.azure.resourcemanager.redisenterprise.models.Persistence;
import com.azure.resourcemanager.redisenterprise.models.Protocol;
import com.azure.resourcemanager.redisenterprise.models.ProvisioningState;
import com.azure.resourcemanager.redisenterprise.models.RegenerateKeyParameters;
import com.azure.resourcemanager.redisenterprise.models.ResourceState;
import java.util.List;

public interface Database {
    public String id();

    public String name();

    public String type();

    public Protocol clientProtocol();

    public Integer port();

    public ProvisioningState provisioningState();

    public ResourceState resourceState();

    public ClusteringPolicy clusteringPolicy();

    public EvictionPolicy evictionPolicy();

    public Persistence persistence();

    public List<Module> modules();

    public DatabaseInner innerModel();

    public Update update();

    public Database refresh();

    public Database refresh(Context var1);

    public AccessKeys listKeys();

    public Response<AccessKeys> listKeysWithResponse(Context var1);

    public AccessKeys regenerateKey(RegenerateKeyParameters var1);

    public AccessKeys regenerateKey(RegenerateKeyParameters var1, Context var2);

    public void importMethod(ImportClusterParameters var1);

    public void importMethod(ImportClusterParameters var1, Context var2);

    public void export(ExportClusterParameters var1);

    public void export(ExportClusterParameters var1, Context var2);

    public static interface UpdateStages {

        public static interface WithModules {
            public Update withModules(List<Module> var1);
        }

        public static interface WithPersistence {
            public Update withPersistence(Persistence var1);
        }

        public static interface WithEvictionPolicy {
            public Update withEvictionPolicy(EvictionPolicy var1);
        }

        public static interface WithClusteringPolicy {
            public Update withClusteringPolicy(ClusteringPolicy var1);
        }

        public static interface WithClientProtocol {
            public Update withClientProtocol(Protocol var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithClientProtocol,
    UpdateStages.WithClusteringPolicy,
    UpdateStages.WithEvictionPolicy,
    UpdateStages.WithPersistence,
    UpdateStages.WithModules {
        public Database apply();

        public Database apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithModules {
            public WithCreate withModules(List<Module> var1);
        }

        public static interface WithPersistence {
            public WithCreate withPersistence(Persistence var1);
        }

        public static interface WithEvictionPolicy {
            public WithCreate withEvictionPolicy(EvictionPolicy var1);
        }

        public static interface WithClusteringPolicy {
            public WithCreate withClusteringPolicy(ClusteringPolicy var1);
        }

        public static interface WithPort {
            public WithCreate withPort(Integer var1);
        }

        public static interface WithClientProtocol {
            public WithCreate withClientProtocol(Protocol var1);
        }

        public static interface WithCreate
        extends WithClientProtocol,
        WithPort,
        WithClusteringPolicy,
        WithEvictionPolicy,
        WithPersistence,
        WithModules {
            public Database create();

            public Database create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingRedisEnterprise(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

